/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordTrackedSet;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexCallback;
import com.orientechnologies.orient.core.index.OIndexFactory;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.index.OIndexManagerAbstract;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OIndexManagerShared
extends OIndexManagerAbstract {
    public OIndexManagerShared(ODatabaseRecord iDatabase) {
        super(iDatabase);
    }

    public synchronized OIndex<?> getIndexInternal(String iName) {
        OIndex index = (OIndex)this.indexes.get(iName.toLowerCase());
        return this.getIndexInstance(index);
    }

    @Override
    public synchronized OIndex<?> createIndex(String iName, String iType, OType iKeyType, int[] iClusterIdsToIndex, OIndexCallback iCallback, OProgressListener iProgressListener, boolean iAutomatic) {
        Object index = OIndexFactory.instance().newInstance(this.getDatabase(), iType);
        index.setCallback(iCallback);
        index.create(iName, iKeyType, this.getDatabase(), this.defaultClusterName, iClusterIdsToIndex, iProgressListener, iAutomatic);
        this.indexes.put(iName.toLowerCase(), index);
        this.setDirty();
        this.save();
        return this.getIndexInstance((OIndex<?>)index);
    }

    @Override
    public synchronized OIndexManager dropIndex(String iIndexName) {
        OIndex idx = (OIndex)this.indexes.remove(iIndexName.toLowerCase());
        if (idx != null) {
            idx.delete();
            this.setDirty();
            this.save();
        }
        return this;
    }

    @Override
    protected synchronized void fromStream() {
        Collection idxs = (Collection)this.document.field("indexes");
        if (idxs != null) {
            for (ODocument d : idxs) {
                Object index = OIndexFactory.instance().newInstance(this.getDatabase(), (String)d.field("type"));
                d.setDatabase(this.getDatabase());
                index.loadFromConfiguration(d);
                this.indexes.put(index.getName().toLowerCase(), index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODocument toStream() {
        this.document.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
        try {
            ORecordTrackedSet idxs = new ORecordTrackedSet(this.document);
            for (OIndexInternal i : this.indexes.values()) {
                idxs.add(i.updateConfiguration());
            }
            this.document.field("indexes", idxs, OType.EMBEDDEDSET);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.document.setInternalStatus(ORecordElement.STATUS.LOADED);
            throw throwable;
        }
        this.document.setInternalStatus(ORecordElement.STATUS.LOADED);
        this.document.setDirty();
        return this.document;
    }

    @Override
    protected synchronized OIndex<?> getIndexInstance(OIndex<?> iIndex) {
        return iIndex;
    }
}

