/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.collection.ONavigableMap;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazySet;
import com.orientechnologies.orient.core.index.OIndexMVRBTreeAbstract;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerListRID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OIndexMultiValues
extends OIndexMVRBTreeAbstract<Set<OIdentifiable>> {
    public OIndexMultiValues(String iType) {
        super(iType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<OIdentifiable> get(Object iKey) {
        ORecordLazySet values;
        block4: {
            ORecordLazySet oRecordLazySet;
            this.acquireExclusiveLock();
            try {
                values = (ORecordLazySet)this.map.get(iKey);
                if (values != null) {
                    values.setDatabase((ODatabaseRecord)ODatabaseRecordThreadLocal.INSTANCE.get());
                }
                if (values != null) break block4;
                oRecordLazySet = ORecordLazySet.EMPTY_SET;
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.releaseExclusiveLock();
                throw throwable;
            }
            this.releaseExclusiveLock();
            return oRecordLazySet;
        }
        ORecordLazySet oRecordLazySet = values;
        Object var5_6 = null;
        this.releaseExclusiveLock();
        return oRecordLazySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIndexMultiValues put(Object iKey, OIdentifiable iSingleValue) {
        OIndexMultiValues oIndexMultiValues;
        this.acquireExclusiveLock();
        try {
            this.checkForKeyType(iKey);
            Set values = (Set)this.map.get(iKey);
            if (values == null) {
                values = new ORecordLazySet(this.configuration.getDatabase()).setRidOnly(true);
            }
            if (!iSingleValue.getIdentity().isValid()) {
                ((ORecord)iSingleValue).save();
            }
            values.add(iSingleValue);
            this.map.put(iKey, values);
            oIndexMultiValues = this;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return oIndexMultiValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object iKey, OIdentifiable iValue) {
        block3: {
            boolean bl;
            this.acquireExclusiveLock();
            try {
                Object recs = this.get(iKey);
                if (recs == null || recs.isEmpty() || !recs.remove(iValue)) break block3;
                this.map.put(iKey, recs);
                bl = true;
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.releaseExclusiveLock();
                throw throwable;
            }
            this.releaseExclusiveLock();
            return bl;
        }
        boolean bl = false;
        Object var6_7 = null;
        this.releaseExclusiveLock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remove(OIdentifiable iRecord) {
        int n;
        this.acquireExclusiveLock();
        try {
            int tot = 0;
            for (Map.Entry entries : this.map.entrySet()) {
                Set rids = (Set)entries.getValue();
                if (rids == null || !rids.contains(iRecord)) continue;
                this.remove(entries.getKey(), iRecord);
                ++tot;
            }
            n = tot;
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count(OIdentifiable iRecord) {
        int n;
        this.acquireExclusiveLock();
        try {
            int tot = 0;
            for (Map.Entry entries : this.map.entrySet()) {
                Set rids = (Set)entries.getValue();
                if (rids == null || !rids.contains(iRecord)) continue;
                ++tot;
            }
            n = tot;
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<OIdentifiable> getValuesMajor(Object fromKey, boolean isInclusive) {
        ORecordLazySet oRecordLazySet;
        ONavigableMap subSet;
        block4: {
            this.acquireExclusiveLock();
            subSet = this.map.tailMap(fromKey, isInclusive);
            if (subSet != null) break block4;
            ORecordLazySet oRecordLazySet2 = ORecordLazySet.EMPTY_SET;
            Object var8_6 = null;
            this.releaseExclusiveLock();
            return oRecordLazySet2;
        }
        try {
            ORecordLazySet result = new ORecordLazySet(this.configuration.getDatabase());
            for (Set v : subSet.values()) {
                result.addAll(v);
            }
            oRecordLazySet = result;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return oRecordLazySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<OIdentifiable> getValuesMinor(Object toKey, boolean isInclusive) {
        ORecordLazySet oRecordLazySet;
        ONavigableMap subSet;
        block4: {
            this.acquireExclusiveLock();
            subSet = this.map.headMap(toKey, isInclusive);
            if (subSet != null) break block4;
            ORecordLazySet oRecordLazySet2 = ORecordLazySet.EMPTY_SET;
            Object var8_6 = null;
            this.releaseExclusiveLock();
            return oRecordLazySet2;
        }
        try {
            ORecordLazySet result = new ORecordLazySet(this.configuration.getDatabase());
            for (Set v : subSet.values()) {
                result.addAll(v);
            }
            oRecordLazySet = result;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return oRecordLazySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ODocument> getEntriesMajor(Object fromKey, boolean isInclusive) {
        HashSet<ODocument> hashSet;
        this.acquireExclusiveLock();
        try {
            HashSet<ODocument> result = new HashSet<ODocument>();
            ONavigableMap subSet = this.map.tailMap(fromKey, isInclusive);
            if (subSet != null) {
                for (Map.Entry v : subSet.entrySet()) {
                    for (OIdentifiable id : (Set)v.getValue()) {
                        ODocument document = new ODocument();
                        document.field("key", v.getKey());
                        document.field("rid", id.getIdentity());
                        document.unsetDirty();
                        result.add(document);
                    }
                }
            }
            hashSet = result;
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ODocument> getEntriesMinor(Object toKey, boolean isInclusive) {
        HashSet<ODocument> hashSet;
        this.acquireExclusiveLock();
        try {
            HashSet<ODocument> result = new HashSet<ODocument>();
            ONavigableMap subSet = this.map.headMap(toKey, isInclusive);
            if (subSet != null) {
                for (Map.Entry v : subSet.entrySet()) {
                    for (OIdentifiable id : (Set)v.getValue()) {
                        ODocument document = new ODocument();
                        document.field("key", v.getKey());
                        document.field("rid", id.getIdentity());
                        document.unsetDirty();
                        result.add(document);
                    }
                }
            }
            hashSet = result;
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OIdentifiable> getValuesBetween(Object iRangeFrom, Object iRangeTo, boolean iInclusive) {
        ORecordLazySet oRecordLazySet;
        ONavigableMap subSet;
        block5: {
            if (iRangeFrom.getClass() != iRangeTo.getClass()) {
                throw new IllegalArgumentException("Range from-to parameters are of different types");
            }
            this.acquireExclusiveLock();
            subSet = this.map.subMap(iRangeFrom, iInclusive, iRangeTo, iInclusive);
            if (subSet != null) break block5;
            ORecordLazySet oRecordLazySet2 = ORecordLazySet.EMPTY_SET;
            Object var9_7 = null;
            this.releaseExclusiveLock();
            return oRecordLazySet2;
        }
        try {
            ORecordLazySet result = new ORecordLazySet(this.configuration.getDatabase());
            for (Set v : subSet.values()) {
                result.addAll(v);
            }
            oRecordLazySet = result;
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return oRecordLazySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ODocument> getEntriesBetween(Object iRangeFrom, Object iRangeTo, boolean iInclusive) {
        HashSet<ODocument> hashSet;
        if (iRangeFrom.getClass() != iRangeTo.getClass()) {
            throw new IllegalArgumentException("Range from-to parameters are of different types");
        }
        this.acquireExclusiveLock();
        try {
            HashSet<ODocument> result = new HashSet<ODocument>();
            ONavigableMap subSet = this.map.subMap(iRangeFrom, iInclusive, iRangeTo, iInclusive);
            if (subSet != null) {
                for (Map.Entry v : subSet.entrySet()) {
                    for (OIdentifiable id : (Set)v.getValue()) {
                        ODocument document = new ODocument();
                        document.field("key", v.getKey());
                        document.field("rid", id.getIdentity());
                        document.unsetDirty();
                        result.add(document);
                    }
                }
            }
            hashSet = result;
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return hashSet;
    }

    public OIndexMultiValues create(String iName, OType iKeyType, ODatabaseRecord iDatabase, String iClusterIndexName, int[] iClusterIdsToIndex, OProgressListener iProgressListener, boolean iAutomatic) {
        return (OIndexMultiValues)super.create(iName, iKeyType, iDatabase, iClusterIndexName, iClusterIdsToIndex, iProgressListener, iAutomatic, OStreamSerializerListRID.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<OIdentifiable> getValues(Collection<?> iKeys) {
        ArrayList sortedKeys = new ArrayList(iKeys);
        Collections.sort(sortedKeys);
        HashSet<OIdentifiable> result = new HashSet<OIdentifiable>();
        this.acquireExclusiveLock();
        try {
            for (Comparable key : sortedKeys) {
                ORecordLazySet values = (ORecordLazySet)this.map.get(key);
                if (values != null) {
                    values.setDatabase((ODatabaseRecord)ODatabaseRecordThreadLocal.INSTANCE.get());
                }
                if (values == null) continue;
                result.addAll(values);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ODocument> getEntries(Collection<?> iKeys) {
        ArrayList sortedKeys = new ArrayList(iKeys);
        Collections.sort(sortedKeys);
        HashSet<ODocument> result = new HashSet<ODocument>();
        this.acquireExclusiveLock();
        try {
            for (Comparable key : sortedKeys) {
                ORecordLazySet values = (ORecordLazySet)this.map.get(key);
                if (values != null) {
                    values.setDatabase((ODatabaseRecord)ODatabaseRecordThreadLocal.INSTANCE.get());
                }
                if (values == null) continue;
                for (OIdentifiable value : values) {
                    ODocument document = new ODocument();
                    document.field("key", key);
                    document.field("rid", value.getIdentity());
                    document.unsetDirty();
                    result.add(document);
                }
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return result;
    }
}

