/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexCallback;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.util.Collection;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OIndexRemote<T>
implements OIndex<T> {
    private final String wrappedType;
    private final ORID rid;
    protected String name;
    protected static final String QUERY_GET = "select from index:%s where key = ?";
    protected static final String QUERY_ENTRIES = "select key, rid from index:%s";
    private static final String QUERY_GET_MAJOR = "select from index:%s where key > ?";
    private static final String QUERY_GET_MAJOR_EQUALS = "select from index:%s where key >= ?";
    private static final String QUERY_GET_VALUE_MAJOR = "select @rid from index:%s where key > ?";
    private static final String QUERY_GET_VALUE_MAJOR_EQUALS = "select @rid from index:%s where key >= ?";
    private static final String QUERY_GET_MINOR = "select from index:%s where key < ?";
    private static final String QUERY_GET_MINOR_EQUALS = "select from index:%s where key <= ?";
    private static final String QUERY_GET_VALUE_MINOR = "select @rid from index:%s where key < ?";
    private static final String QUERY_GET_VALUE_MINOR_EQUALS = "select @rid from index:%s where key <= ?";
    private static final String QUERY_GET_RANGE = "select from index:%s where key between ? and ?";
    private static final String QUERY_GET_VALUES = "select @rid from index:%s where key in [%s]";
    private static final String QUERY_GET_ENTRIES = "select from index:%s where key in [%s]";
    private static final String QUERY_GET_VALUE_RANGE = "select @rid from index:%s where key between ? and ?";
    private static final String QUERY_PUT = "insert into index:%s (key,rid) values (%s,%s)";
    private static final String QUERY_REMOVE = "delete from index:%s where key = %s";
    private static final String QUERY_REMOVE2 = "delete from index:%s where key = %s and rid = %s";
    private static final String QUERY_REMOVE3 = "delete from index:%s where rid = ?";
    private static final String QUERY_CONTAINS = "select count(*) as size from\tindex:%s where key = ?";
    private static final String QUERY_SIZE = "select count(*) as size from index:%s";
    private static final String QUERY_KEYS = "select key from index:%s";
    private static final String QUERY_REBUILD = "rebuild index %s";
    private static final String QUERY_CLEAR = "delete from index:%s";

    public OIndexRemote(String iName, String iWrappedType, ORID iRid) {
        this.name = iName;
        this.wrappedType = iWrappedType;
        this.rid = iRid;
    }

    @Override
    public OIndexRemote<T> create(String iName, OType iKeyType, ODatabaseRecord iDatabase, String iClusterIndexName, int[] iClusterIdsToIndex, OProgressListener iProgressListener, boolean iAutomatic) {
        this.name = iName;
        return this;
    }

    @Override
    public OIndexRemote<T> delete() {
        return this;
    }

    @Override
    public Collection<OIdentifiable> getValuesBetween(Object iRangeFrom, Object iRangeTo) {
        OCommandRequest cmd = this.formatCommand(QUERY_GET_VALUE_RANGE, this.name);
        return (Collection)this.getDatabase().command(cmd).execute(iRangeFrom, iRangeTo);
    }

    @Override
    public Collection<OIdentifiable> getValuesBetween(Object iRangeFrom, Object iRangeTo, boolean iInclusive) {
        OCommandRequest cmd = this.formatCommand(QUERY_GET_VALUE_RANGE, this.name);
        return (Collection)this.getDatabase().command(cmd).execute(iRangeFrom, iRangeTo);
    }

    public Set<ODocument> getEntriesBetween(Object iRangeFrom, Object iRangeTo, boolean iInclusive) {
        OCommandRequest cmd = this.formatCommand(QUERY_GET_RANGE, this.name);
        return (Set)this.getDatabase().command(cmd).execute(iRangeFrom, iRangeTo);
    }

    @Override
    public Collection<ODocument> getEntriesBetween(Object iRangeFrom, Object iRangeTo) {
        OCommandRequest cmd = this.formatCommand(QUERY_GET_RANGE, this.name);
        return (Collection)this.getDatabase().command(cmd).execute(iRangeFrom, iRangeTo);
    }

    @Override
    public Collection<OIdentifiable> getValuesMajor(Object fromKey, boolean isInclusive) {
        OCommandRequest cmd = isInclusive ? this.formatCommand(QUERY_GET_VALUE_MAJOR_EQUALS, this.name) : this.formatCommand(QUERY_GET_VALUE_MAJOR, this.name);
        return (Collection)this.getDatabase().command(cmd).execute(fromKey);
    }

    @Override
    public Collection<ODocument> getEntriesMajor(Object fromKey, boolean isInclusive) {
        OCommandRequest cmd = isInclusive ? this.formatCommand(QUERY_GET_MAJOR_EQUALS, this.name) : this.formatCommand(QUERY_GET_MAJOR, this.name);
        return (Collection)this.getDatabase().command(cmd).execute(fromKey);
    }

    @Override
    public Collection<OIdentifiable> getValuesMinor(Object toKey, boolean isInclusive) {
        OCommandRequest cmd = isInclusive ? this.formatCommand(QUERY_GET_VALUE_MINOR_EQUALS, this.name) : this.formatCommand(QUERY_GET_VALUE_MINOR, this.name);
        return (Collection)this.getDatabase().command(cmd).execute(toKey);
    }

    @Override
    public Collection<ODocument> getEntriesMinor(Object toKey, boolean isInclusive) {
        OCommandRequest cmd = isInclusive ? this.formatCommand(QUERY_GET_MINOR_EQUALS, this.name) : this.formatCommand(QUERY_GET_MINOR, this.name);
        return (Collection)this.getDatabase().command(cmd).execute(toKey);
    }

    @Override
    public boolean contains(Object iKey) {
        OCommandRequest cmd = this.formatCommand(QUERY_CONTAINS, this.name);
        List result = (List)this.getDatabase().command(cmd).execute(new Object[0]);
        return (Long)((ODocument)result.get(0)).field("size") > 0L;
    }

    @Override
    public OIndexRemote<T> put(Object iKey, OIdentifiable iValue) {
        if (iKey instanceof String) {
            iKey = "'" + iKey + "'";
        }
        if (iValue instanceof ORecord && !iValue.getIdentity().isValid()) {
            ((ORecord)iValue).save();
        }
        OCommandRequest cmd = this.formatCommand(QUERY_PUT, this.name, iKey, iValue.getIdentity());
        this.getDatabase().command(cmd).execute(new Object[0]);
        return this;
    }

    @Override
    public boolean remove(Object iKey) {
        if (iKey instanceof String) {
            iKey = "'" + iKey + "'";
        }
        OCommandRequest cmd = this.formatCommand(QUERY_REMOVE, this.name, iKey);
        return Boolean.parseBoolean((String)this.getDatabase().command(cmd).execute(iKey));
    }

    @Override
    public boolean remove(Object iKey, OIdentifiable iRID) {
        if (iKey instanceof String) {
            iKey = "'" + iKey + "'";
        }
        OCommandRequest cmd = this.formatCommand(QUERY_REMOVE2, this.name, iKey, iRID.getIdentity());
        return Boolean.parseBoolean((String)this.getDatabase().command(cmd).execute(iKey, iRID));
    }

    @Override
    public int remove(OIdentifiable iRecord) {
        OCommandRequest cmd = this.formatCommand(QUERY_REMOVE3, this.name, iRecord.getIdentity());
        return (Integer)this.getDatabase().command(cmd).execute(iRecord);
    }

    @Override
    public long rebuild() {
        OCommandRequest cmd = this.formatCommand(QUERY_REBUILD, this.name);
        return (Long)this.getDatabase().command(cmd).execute(new Object[0]);
    }

    @Override
    public OIndexRemote<T> clear() {
        OCommandRequest cmd = this.formatCommand(QUERY_CLEAR, this.name);
        this.getDatabase().command(cmd).execute(new Object[0]);
        return this;
    }

    @Override
    public Iterable<Object> keys() {
        OCommandRequest cmd = this.formatCommand(QUERY_KEYS, this.name);
        return (Iterable)this.getDatabase().command(cmd).execute(new Object[0]);
    }

    @Override
    public long getSize() {
        OCommandRequest cmd = this.formatCommand(QUERY_SIZE, this.name);
        List result = (List)this.getDatabase().command(cmd).execute(new Object[0]);
        return (Long)((ODocument)result.get(0)).field("size");
    }

    @Override
    public void unload() {
    }

    @Override
    public boolean isAutomatic() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public OIndexRemote<T> lazySave() {
        return this;
    }

    @Override
    public String getType() {
        return this.wrappedType;
    }

    @Override
    public void setCallback(OIndexCallback iCallback) {
    }

    @Override
    public ODocument getConfiguration() {
        return null;
    }

    @Override
    public ORID getIdentity() {
        return this.rid;
    }

    protected OCommandRequest formatCommand(String iTemplate, Object ... iArgs) {
        String text = String.format(iTemplate, iArgs);
        return new OCommandSQL(text);
    }

    @Override
    public void commit(ODocument iDocument) {
    }

    @Override
    public OIndexInternal<T> getInternal() {
        return null;
    }

    protected ODatabaseComplex<ORecordInternal<?>> getDatabase() {
        return (ODatabaseComplex)ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    @Override
    public long rebuild(OProgressListener iProgressListener) {
        return this.rebuild();
    }

    @Override
    public OType getKeyType() {
        return null;
    }

    @Override
    public Collection<OIdentifiable> getValues(Collection<?> iKeys) {
        StringBuilder params = new StringBuilder();
        if (!iKeys.isEmpty()) {
            params.append("?");
            for (int i = 1; i < iKeys.size(); ++i) {
                params.append(", ?");
            }
        }
        OCommandRequest cmd = this.formatCommand(QUERY_GET_VALUES, this.name, params.toString());
        return (Collection)this.getDatabase().command(cmd).execute(iKeys.toArray());
    }

    @Override
    public Collection<ODocument> getEntries(Collection<?> iKeys) {
        StringBuilder params = new StringBuilder();
        if (!iKeys.isEmpty()) {
            params.append("?");
            for (int i = 1; i < iKeys.size(); ++i) {
                params.append(", ?");
            }
        }
        OCommandRequest cmd = this.formatCommand(QUERY_GET_ENTRIES, this.name, params.toString());
        return (Collection)this.getDatabase().command(cmd).execute(iKeys.toArray());
    }
}

