/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.hook.ODocumentHookAbstract;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OPropertyIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPropertyIndexManager
extends ODocumentHookAbstract {
    @Override
    public boolean onRecordBeforeCreate(ODocument iRecord) {
        this.checkIndexedProperties(iRecord);
        return false;
    }

    @Override
    public boolean onRecordAfterCreate(ODocument iRecord) {
        Map<OProperty, Object> indexedProperties = this.getIndexedProperties(iRecord);
        if (indexedProperties != null) {
            for (Map.Entry<OProperty, Object> propEntry : indexedProperties.entrySet()) {
                propEntry.getKey().getIndex().getUnderlying().put(propEntry.getValue(), iRecord.placeholder());
            }
        }
        return false;
    }

    @Override
    public boolean onRecordBeforeUpdate(ODocument iRecord) {
        this.checkIndexedProperties(iRecord);
        return false;
    }

    @Override
    public boolean onRecordAfterUpdate(ODocument iRecord) {
        String[] dirtyFields;
        Map<OProperty, Object> indexedProperties = this.getIndexedProperties(iRecord);
        if (indexedProperties != null && (dirtyFields = iRecord.getDirtyFields()).length > 0) {
            OIndex<?> index;
            Object originalValue = null;
            block0: for (Map.Entry<OProperty, Object> propEntry : indexedProperties.entrySet()) {
                for (String f : dirtyFields) {
                    if (!f.equals(propEntry.getKey().getName())) continue;
                    originalValue = iRecord.getOriginalValue(propEntry.getKey().getName());
                    index = propEntry.getKey().getIndex().getUnderlying();
                    index.remove(originalValue, iRecord);
                    continue block0;
                }
            }
            block2: for (Map.Entry<OProperty, Object> propEntry : indexedProperties.entrySet()) {
                for (String f : dirtyFields) {
                    if (!f.equals(propEntry.getKey().getName())) continue;
                    index = propEntry.getKey().getIndex().getUnderlying();
                    index.put(propEntry.getValue(), iRecord.placeholder());
                    continue block2;
                }
            }
        }
        if (iRecord.isTrackingChanges()) {
            iRecord.setTrackingChanges(false);
            iRecord.setTrackingChanges(true);
        }
        return false;
    }

    @Override
    public boolean onRecordAfterDelete(ODocument iRecord) {
        Map<OProperty, Object> indexedProperties = this.getIndexedProperties(iRecord);
        if (indexedProperties != null) {
            OIndex<?> index;
            String[] dirtyFields = iRecord.getDirtyFields();
            if (dirtyFields.length > 0) {
                block0: for (Map.Entry<OProperty, Object> propEntry : indexedProperties.entrySet()) {
                    for (String f : dirtyFields) {
                        if (!f.equals(propEntry.getKey().getName())) continue;
                        index = propEntry.getKey().getIndex().getUnderlying();
                        index.remove(iRecord.getOriginalValue(propEntry.getKey().getName()), iRecord);
                        continue block0;
                    }
                }
            }
            for (Map.Entry<OProperty, Object> propEntry : indexedProperties.entrySet()) {
                if (!iRecord.containsField(propEntry.getKey().getName())) continue;
                boolean found = false;
                for (String f : dirtyFields) {
                    if (!f.equals(propEntry.getKey().getName())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                index = propEntry.getKey().getIndex().getUnderlying();
                index.remove(propEntry.getValue(), iRecord);
            }
        }
        if (iRecord.isTrackingChanges()) {
            iRecord.setTrackingChanges(false);
            iRecord.setTrackingChanges(true);
        }
        return false;
    }

    protected void checkIndexedProperties(ODocument iRecord) {
        OClass cls = iRecord.getSchemaClass();
        if (cls == null) {
            return;
        }
        for (OProperty prop : cls.getIndexedProperties()) {
            OPropertyIndex index = prop.getIndex();
            if (index == null) continue;
            index.checkEntry(iRecord);
        }
    }

    protected Map<OProperty, Object> getIndexedProperties(ODocument iRecord) {
        ODocument record = iRecord;
        OClass cls = record.getSchemaClass();
        if (cls == null) {
            return null;
        }
        HashMap indexedProperties = null;
        for (OProperty prop : cls.getIndexedProperties()) {
            Object fieldValue;
            OPropertyIndex index = prop.getIndex();
            if (index == null || (fieldValue = prop.getType() == OType.LINK ? record.field(prop.getName(), OType.LINK) : record.field(prop.getName())) == null) continue;
            if (indexedProperties == null) {
                indexedProperties = new HashMap();
            }
            indexedProperties.put(prop, fieldValue);
        }
        return indexedProperties;
    }
}

