/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.iterator;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.graph.ODatabaseGraphTx;
import com.orientechnologies.orient.core.db.graph.OGraphElement;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordAbstract;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OGraphElementIterator<T extends OGraphElement>
implements Iterator<T>,
Iterable<T> {
    protected ODatabaseGraphTx database;
    protected ORecordIteratorClass<ODocument> underlying;
    private String fetchPlan;
    private T reusedObject;
    private String className;

    public OGraphElementIterator(ODatabaseGraphTx iDatabase, String iClassName, boolean iPolymorphic) {
        this.database = iDatabase;
        this.className = iClassName;
        this.underlying = new ORecordIteratorClass((ODatabaseRecord)iDatabase.getUnderlying(), (ODatabaseRecordAbstract)((ODatabaseDocumentTx)iDatabase.getUnderlying()).getUnderlying(), iClassName, iPolymorphic);
        this.setReuseSameObject(false);
        this.underlying.setReuseSameRecord(false);
    }

    public OGraphElementIterator(ODatabaseGraphTx iDatabase, ORecordIteratorClass<ODocument> iUnderlying) {
        this.database = iDatabase;
        this.underlying = iUnderlying;
    }

    public abstract T next(String var1);

    @Override
    public boolean hasNext() {
        return this.underlying.hasNext();
    }

    @Override
    public T next() {
        return this.next(this.fetchPlan);
    }

    @Override
    public void remove() {
        this.underlying.remove();
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    public String getFetchPlan() {
        return this.fetchPlan;
    }

    public OGraphElementIterator<T> setFetchPlan(String fetchPlan) {
        this.fetchPlan = fetchPlan;
        return this;
    }

    public boolean isReuseSameObject() {
        return this.reusedObject != null;
    }

    public OGraphElementIterator<T> setReuseSameObject(boolean iReuse) {
        this.reusedObject = this.database.newInstance(this.className);
        return this;
    }

    protected T getObject() {
        Object object;
        if (this.reusedObject != null) {
            object = this.reusedObject;
            ((OGraphElement)object).reset();
        } else {
            object = this.database.newInstance(this.className);
        }
        return object;
    }
}

