/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.iterator;

import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordAbstract;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.iterator.OIterationException;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.tx.OTransactionRecordEntry;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ORecordIterator<REC extends ORecordInternal<?>>
implements Iterator<REC>,
Iterable<REC> {
    protected final ODatabaseRecord database;
    protected final ODatabaseRecordAbstract lowLevelDatabase;
    protected boolean liveUpdated = false;
    protected long limit = -1L;
    protected long browsedRecords = 0L;
    protected String fetchPlan;
    private ORecordInternal<?> reusedRecord = null;
    protected Boolean directionForward;
    protected final ORecordId current = new ORecordId();
    protected long firstClusterPosition;
    protected long lastClusterPosition;
    protected long totalAvailableRecords;
    protected List<OTransactionRecordEntry> txEntries;
    protected int currentTxEntryPosition = -1;

    public ORecordIterator(ODatabaseRecord iDatabase, ODatabaseRecordAbstract iLowLevelDatabase) {
        this.database = iDatabase;
        this.lowLevelDatabase = iLowLevelDatabase;
        this.current.clusterPosition = -1L;
    }

    public abstract boolean hasPrevious();

    public abstract REC previous();

    public abstract ORecordIterator<REC> begin();

    public abstract ORecordIterator<REC> last();

    protected REC getTransactionEntry() {
        long physicalRecordTobrowse;
        long l = physicalRecordTobrowse = this.current.clusterPosition > -2L && this.lastClusterPosition > -1L ? this.lastClusterPosition - this.current.clusterPosition : 0L;
        if (physicalRecordTobrowse == 0L && this.txEntries != null) {
            ++this.currentTxEntryPosition;
            if (this.currentTxEntryPosition >= this.txEntries.size()) {
                throw new NoSuchElementException();
            }
            return (REC)this.txEntries.get(this.currentTxEntryPosition).getRecord();
        }
        return null;
    }

    public String getFetchPlan() {
        return this.fetchPlan;
    }

    public void setFetchPlan(String fetchPlan) {
        this.fetchPlan = fetchPlan;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public boolean isReuseSameRecord() {
        return this.reusedRecord != null;
    }

    public ORecordIterator<REC> setReuseSameRecord(boolean reuseSameRecord) {
        this.reusedRecord = reuseSameRecord ? this.database.newInstance() : null;
        return this;
    }

    protected ORecordInternal<?> getRecord() {
        ORecordInternal<?> record;
        if (this.reusedRecord != null) {
            record = this.reusedRecord;
            record.reset();
        } else {
            record = null;
        }
        return record;
    }

    @Override
    public Iterator<REC> iterator() {
        return this;
    }

    public long getLimit() {
        return this.limit;
    }

    public ORecordIterator<REC> setLimit(long limit) {
        this.limit = limit;
        return this;
    }

    public boolean isLiveUpdated() {
        return this.liveUpdated;
    }

    public ORecordIterator<REC> setLiveUpdated(boolean liveUpdated) {
        this.liveUpdated = liveUpdated;
        return this;
    }

    protected void checkDirection(boolean iForward) {
        if (this.directionForward == null) {
            this.directionForward = iForward;
        } else if (this.directionForward != iForward) {
            throw new OIterationException("Iterator can't change direction while browsing");
        }
    }
}

