/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata;

import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.index.OIndexManagerAbstract;
import com.orientechnologies.orient.core.index.OIndexManagerProxy;
import com.orientechnologies.orient.core.index.OIndexManagerRemote;
import com.orientechnologies.orient.core.index.OIndexManagerShared;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.metadata.schema.OSchemaShared;
import com.orientechnologies.orient.core.metadata.security.OSecurity;
import com.orientechnologies.orient.core.metadata.security.OSecurityNull;
import com.orientechnologies.orient.core.metadata.security.OSecurityProxy;
import com.orientechnologies.orient.core.metadata.security.OSecurityShared;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import java.io.IOException;
import java.util.concurrent.Callable;

public class OMetadata {
    protected ODatabaseRecord database;
    protected int schemaClusterId;
    protected OSchemaProxy schema;
    protected OSecurity security;
    protected OIndexManagerProxy indexManager;

    public OMetadata(ODatabaseRecord iDatabase) {
        this.database = iDatabase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        long timer = OProfiler.getInstance().startChrono();
        try {
            this.init(true);
            if (this.schemaClusterId == -1 || this.database.countClusterElements("internal") == 0L) {
                return;
            }
        }
        finally {
            OProfiler.getInstance().stopChrono("OMetadata.load", timer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create() throws IOException {
        long timer = OProfiler.getInstance().startChrono();
        try {
            this.init(false);
            this.schema.create();
            this.security.create();
            this.indexManager.create();
        }
        finally {
            OProfiler.getInstance().stopChrono("OMetadata.load", timer);
        }
    }

    public OSchema getSchema() {
        return this.schema;
    }

    public OSecurity getSecurity() {
        return this.security;
    }

    public OIndexManagerProxy getIndexManager() {
        return this.indexManager;
    }

    public int getSchemaClusterId() {
        return this.schemaClusterId;
    }

    private void init(final boolean iLoad) {
        this.schemaClusterId = this.database.getClusterIdByName("internal");
        this.indexManager = new OIndexManagerProxy((OIndexManager)this.database.getStorage().getResource(OIndexManager.class.getSimpleName(), new Callable<OIndexManager>(){

            @Override
            public OIndexManager call() {
                OIndexManagerAbstract instance = OMetadata.this.database.getStorage() instanceof OStorageEmbedded ? new OIndexManagerShared(OMetadata.this.database) : new OIndexManagerRemote(OMetadata.this.database);
                if (iLoad) {
                    instance.load();
                }
                return instance;
            }
        }), this.database);
        this.schema = new OSchemaProxy((OSchemaShared)this.database.getStorage().getResource(OSchema.class.getSimpleName(), new Callable<OSchemaShared>(){

            @Override
            public OSchemaShared call() {
                OSchemaShared instance = new OSchemaShared(OMetadata.this.schemaClusterId);
                if (iLoad) {
                    instance.load();
                }
                return instance;
            }
        }), this.database);
        Boolean enableSecurity = (Boolean)this.database.getProperty(ODatabase.OPTIONS.SECURITY.toString());
        this.security = enableSecurity != null && enableSecurity == false ? new OSecurityNull() : new OSecurityProxy((OSecurityShared)this.database.getStorage().getResource(OSecurity.class.getSimpleName(), new Callable<OSecurityShared>(){

            @Override
            public OSecurityShared call() {
                OSecurityShared instance = new OSecurityShared();
                if (iLoad) {
                    instance.load();
                }
                return instance;
            }
        }), this.database);
    }

    public void reload() {
        this.schema.reload();
        this.indexManager.load();
        this.security.load();
    }

    public void close() {
        this.indexManager.flush();
        this.schema.close();
        this.security.close();
    }
}

