/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.security;

import com.orientechnologies.orient.core.annotation.OAfterDeserialization;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.security.OSecurityManager;
import com.orientechnologies.orient.core.type.ODocumentWrapper;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OUser
extends ODocumentWrapper {
    public static final String ADMIN = "admin";
    protected Set<ORole> roles = new HashSet<ORole>();

    public OUser() {
    }

    public OUser(ODatabaseRecord iDatabase, String iName) {
        super(iDatabase, "OUser");
        this.document.field("name", iName);
        this.setAccountStatus(STATUSES.ACTIVE);
    }

    public OUser(ODatabaseRecord iDatabase, String iUserName, String iUserPassword) {
        super(iDatabase, "OUser");
        this.document.field("name", iUserName);
        this.setPassword(iUserPassword);
        this.setAccountStatus(STATUSES.ACTIVE);
    }

    public OUser(ODocument iSource) {
        this.fromStream(iSource);
    }

    @Override
    @OAfterDeserialization
    public void fromStream(ODocument iSource) {
        if (this.document != null) {
            return;
        }
        this.document = iSource;
        this.roles = new HashSet<ORole>();
        Set loadedRoles = (Set)iSource.field("roles");
        if (loadedRoles != null) {
            for (ODocument d : loadedRoles) {
                this.roles.add(this.document.getDatabase().getMetadata().getSecurity().getRole((String)d.field("name")));
            }
        }
    }

    public ORole allow(String iResource, int iOperation) {
        if (this.roles == null || this.roles.isEmpty()) {
            throw new OSecurityAccessException(this.document.getDatabase().getName(), "User '" + this.document.field("name") + "' has no role defined");
        }
        ORole role = this.checkIfAllowed(iResource, iOperation);
        if (role == null) {
            throw new OSecurityAccessException(this.document.getDatabase().getName(), "User '" + this.document.field("name") + "' has no the permission to execute the operation '" + ORole.permissionToString(iOperation) + "' against the resource: " + iResource);
        }
        return role;
    }

    public ORole checkIfAllowed(String iResource, int iOperation) {
        for (ORole r : this.roles) {
            if (!r.allow(iResource, iOperation)) continue;
            return r;
        }
        return null;
    }

    public boolean isRuleDefined(String iResource) {
        for (ORole r : this.roles) {
            if (!r.hasRule(iResource)) continue;
            return true;
        }
        return false;
    }

    public boolean checkPassword(String iPassword) {
        return OSecurityManager.instance().check(iPassword, (String)this.document.field("password"));
    }

    public String getName() {
        return (String)this.document.field("name");
    }

    public String getPassword() {
        return (String)this.document.field("password");
    }

    public OUser setPassword(String iPassword) {
        this.document.field("password", iPassword);
        return this;
    }

    public static final String encryptPassword(String iPassword) {
        return OSecurityManager.instance().digest2String(iPassword);
    }

    public STATUSES getAccountStatus() {
        return STATUSES.valueOf((String)this.document.field("status"));
    }

    public void setAccountStatus(STATUSES accountStatus) {
        this.document.field("status", (Object)accountStatus);
    }

    public Set<ORole> getRoles() {
        return this.roles;
    }

    public OUser addRole(String iRole) {
        if (iRole != null) {
            this.addRole(this.document.getDatabase().getMetadata().getSecurity().getRole(iRole));
        }
        return this;
    }

    public OUser addRole(ORole iRole) {
        if (iRole != null) {
            this.roles.add(iRole);
        }
        HashSet<ODocument> persistentRoles = new HashSet<ODocument>();
        for (ORole r : this.roles) {
            persistentRoles.add(r.toStream());
        }
        this.document.field("roles", persistentRoles);
        return this;
    }

    public OUser save() {
        this.document.save(OUser.class.getSimpleName());
        return this;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum STATUSES {
        SUSPENDED,
        ACTIVE;

    }
}

