/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ORecordBytes;
import com.orientechnologies.orient.core.record.impl.ORecordFlat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORecordFactoryManager {
    protected final String[] recordTypeNames = new String[127];
    protected final Class<? extends ORecord<?>>[] recordTypes = new Class[127];
    protected final ORecordFactory[] recordFactories = new ORecordFactory[127];

    public ORecordFactoryManager() {
        this.declareRecordType((byte)100, "document", ODocument.class, new ORecordFactory(){

            @Override
            public ORecord<?> newRecord(ODatabaseRecord iDatabase) {
                return new ODocument(iDatabase);
            }
        });
        this.declareRecordType((byte)102, "flat", ORecordFlat.class, new ORecordFactory(){

            @Override
            public ORecord<?> newRecord(ODatabaseRecord iDatabase) {
                return new ORecordFlat(iDatabase);
            }
        });
        this.declareRecordType((byte)98, "bytes", ORecordBytes.class, new ORecordFactory(){

            @Override
            public ORecord<?> newRecord(ODatabaseRecord iDatabase) {
                return new ORecordBytes(iDatabase);
            }
        });
    }

    public String getRecordTypeName(byte iRecordType) {
        String name = this.recordTypeNames[iRecordType];
        if (name == null) {
            throw new IllegalArgumentException("Unsupported record type: " + iRecordType);
        }
        return name;
    }

    public Class<? extends ORecord<?>> getRecordTypeClass(byte iRecordType) {
        Class<ORecord<?>> cls = this.recordTypes[iRecordType];
        if (cls == null) {
            throw new IllegalArgumentException("Unsupported record type: " + iRecordType);
        }
        return cls;
    }

    public ORecordInternal<?> newInstance(ODatabaseRecord iDatabase) {
        try {
            return (ORecordInternal)this.recordFactories[iDatabase.getRecordType()].newRecord(iDatabase);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unsupported record type: " + iDatabase.getRecordType(), e);
        }
    }

    public ORecordInternal<?> newInstance(ODatabaseRecord iDatabase, byte iRecordType) {
        try {
            return (ORecordInternal)this.recordFactories[iRecordType].newRecord(iDatabase);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unsupported record type: " + iRecordType, e);
        }
    }

    public void declareRecordType(byte iByte, String iName, Class<? extends ORecordInternal<?>> iClass, ORecordFactory iFactory) {
        if (this.recordTypes[iByte] != null) {
            throw new OException("Record type byte '" + iByte + "' already in used : " + this.recordTypes[iByte].getName());
        }
        this.recordTypeNames[iByte] = iName;
        this.recordTypes[iByte] = iClass;
        this.recordFactories[iByte] = iFactory;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ORecordFactory {
        public ORecord<?> newRecord(ODatabaseRecord var1);
    }
}

