/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record;

import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.OValidationException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordAbstract;
import com.orientechnologies.orient.core.record.ORecordListener;
import com.orientechnologies.orient.core.record.ORecordSchemaAware;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.OSerializationThreadLocal;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ORecordSchemaAwareAbstract<T>
extends ORecordAbstract<T>
implements ORecordSchemaAware<T> {
    protected OClass _clazz;

    public ORecordSchemaAwareAbstract() {
    }

    public ORecordSchemaAwareAbstract(ODatabaseRecord iDatabase) {
        super(iDatabase);
    }

    @Override
    public ORecordSchemaAwareAbstract<T> fill(ODatabaseRecord iDatabase, int iClassId, ORecordId iRid, int iVersion, byte[] iBuffer, boolean iDirty) {
        this.fill(iDatabase, iRid, iVersion, iBuffer, iDirty);
        this.setClass(null);
        return this;
    }

    @Override
    public ORecordAbstract<T> save() {
        if (this._clazz != null) {
            return this.save(this._database.getClusterNameById(this._clazz.getDefaultClusterId()));
        }
        return super.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORecordAbstract<T> save(String iClusterName) {
        ((Set)OSerializationThreadLocal.INSTANCE.get()).clear();
        try {
            this.validate();
            ORecord oRecord = super.save(iClusterName);
            Object var4_3 = null;
            ((Set)OSerializationThreadLocal.INSTANCE.get()).clear();
            return oRecord;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ((Set)OSerializationThreadLocal.INSTANCE.get()).clear();
            throw throwable;
        }
    }

    @Override
    public void validate() throws OValidationException {
        this.checkForLoading();
        this.checkForFields();
        if (this._clazz != null) {
            for (OProperty p : this._clazz.properties()) {
                ORecordSchemaAwareAbstract.validateField(this, p);
            }
        }
    }

    @Override
    public OClass getSchemaClass() {
        if (this._clazz == null) {
            this.checkForFields();
        }
        return this._clazz;
    }

    @Override
    public String getClassName() {
        this.checkForLoading();
        this.checkForFields();
        return this._clazz != null ? this._clazz.getName() : null;
    }

    @Override
    public void setClassName(String iClassName) {
        if (this._database == null || iClassName == null) {
            this._clazz = null;
            return;
        }
        this.setClass(this._database.getMetadata().getSchema().getOrCreateClass(iClassName));
    }

    @Override
    public void setClassNameIfExists(String iClassName) {
        if (this._database == null || iClassName == null) {
            this._clazz = null;
            return;
        }
        this.setClass(this._database.getMetadata().getSchema().getClass(iClassName));
    }

    @Override
    public ORecordSchemaAwareAbstract<T> reset() {
        super.reset();
        this._clazz = null;
        return this;
    }

    @Override
    public byte[] toStream() {
        return this.toStream(false);
    }

    public byte[] toStream(boolean iOnlyDelta) {
        if (this._source == null) {
            this._source = this._recordFormat.toStream(this._database, this, iOnlyDelta);
        }
        this.invokeListenerEvent(ORecordListener.EVENT.MARSHALL);
        return this._source;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected void checkForFields() {
        if (this._status == ORecordElement.STATUS.LOADED && this.fields() == 0) {
            this.deserializeFields();
        }
    }

    public void deserializeFields() {
        if (this._source == null) {
            return;
        }
        this._status = ORecordElement.STATUS.UNMARSHALLING;
        this._recordFormat.fromStream(this._database, this._source, this);
        this._status = ORecordElement.STATUS.LOADED;
    }

    protected void setClass(OClass iClass) {
        this._clazz = iClass;
    }

    protected void checkFieldAccess(int iIndex) {
        if (iIndex < 0 || iIndex >= this.fields()) {
            throw new IndexOutOfBoundsException("Index " + iIndex + " is out of range allowed: 0-" + this.fields());
        }
    }

    public static void validateField(ORecordSchemaAwareAbstract<?> iRecord, OProperty p) throws OValidationException {
        if (p.isMandatory() && !iRecord.containsField(p.getName())) {
            throw new OValidationException("The field '" + p.getName() + "' is mandatory");
        }
        Object fieldValue = iRecord instanceof ODocument ? ((ODocument)iRecord).rawField(p.getName()) : iRecord.field(p.getName());
        if (!p.isNotNull() && fieldValue == null) {
            throw new OValidationException("The field '" + p.getName() + "' is null");
        }
        if (fieldValue != null && p.getRegexp() != null && !fieldValue.toString().matches(p.getRegexp())) {
            throw new OValidationException("The field '" + p.getName() + "' doesn't match the regular expression '" + p.getRegexp() + "'. Field value is: " + fieldValue);
        }
        OType type = p.getType();
        if (p.getMin() != null) {
            String min = p.getMin();
            if (p.getType().equals((Object)OType.STRING) && fieldValue != null && ((String)fieldValue).length() < Integer.parseInt(min)) {
                throw new OValidationException("The field '" + iRecord.getClassName() + "." + p.getName() + "' contains less characters than " + min + " requested");
            }
            if (p.getType().equals((Object)OType.BINARY) && fieldValue != null && ((byte[])fieldValue).length < Integer.parseInt(min)) {
                throw new OValidationException("The field '" + iRecord.getClassName() + "." + p.getName() + "' contains less bytes than " + min + " requested");
            }
            if (p.getType().equals((Object)OType.INTEGER) && fieldValue != null && type.asInt(fieldValue) < Integer.parseInt(min)) {
                throw new OValidationException("The field '" + iRecord.getClassName() + "." + p.getName() + "' is minor than " + min);
            }
            if (p.getType().equals((Object)OType.LONG) && fieldValue != null && type.asLong(fieldValue) < Long.parseLong(min)) {
                throw new OValidationException("The field '" + iRecord.getClassName() + "." + p.getName() + "' is minor than " + min);
            }
            if (p.getType().equals((Object)OType.FLOAT) && fieldValue != null && type.asFloat(fieldValue) < Float.parseFloat(min)) {
                throw new OValidationException("The field '" + iRecord.getClassName() + "." + p.getName() + "' is minor than " + min);
            }
            if (p.getType().equals((Object)OType.DOUBLE) && fieldValue != null && type.asDouble(fieldValue) < Double.parseDouble(min)) {
                throw new OValidationException("The field '" + iRecord.getClassName() + "." + p.getName() + "' is minor than " + min);
            }
            if (p.getType().equals((Object)OType.DATE)) {
                try {
                    if (fieldValue != null && ((Date)fieldValue).before(iRecord.getDatabase().getStorage().getConfiguration().getDateFormatInstance().parse(min))) {
                        throw new OValidationException("The field '" + iRecord.getClassName() + "." + p.getName() + "' contains the date " + fieldValue + "that is before the date accepted (" + min + ")");
                    }
                }
                catch (ParseException e) {}
            } else if (p.getType().equals((Object)OType.DATETIME)) {
                try {
                    if (fieldValue != null && ((Date)fieldValue).before(iRecord.getDatabase().getStorage().getConfiguration().getDateTimeFormatInstance().parse(min))) {
                        throw new OValidationException("The field '" + iRecord.getClassName() + "." + p.getName() + "' contains the datetime " + fieldValue + "that is before the datetime accepted (" + min + ")");
                    }
                }
                catch (ParseException e) {}
            } else if (p.getType().equals((Object)OType.EMBEDDEDLIST) || p.getType().equals((Object)OType.EMBEDDEDSET) || p.getType().equals((Object)OType.LINKLIST) || p.getType().equals((Object)OType.LINKSET) && fieldValue != null && ((Collection)fieldValue).size() < Integer.parseInt(min)) {
                throw new OValidationException("The field '" + iRecord.getClassName() + "." + p.getName() + "' contains less items then " + min + " requested");
            }
        }
        if (p.getMax() != null) {
            String max = p.getMax();
            if (p.getType().equals((Object)OType.STRING) && fieldValue != null && ((String)fieldValue).length() > Integer.parseInt(max)) {
                throw new OValidationException("The field '" + iRecord.getClassName() + "." + p.getName() + "' contains more characters than " + max + " requested");
            }
            if (p.getType().equals((Object)OType.BINARY) && fieldValue != null && ((byte[])fieldValue).length > Integer.parseInt(max)) {
                throw new OValidationException("The field '" + iRecord.getClassName() + "." + p.getName() + "' contains more bytes than " + max + " requested");
            }
            if (p.getType().equals((Object)OType.INTEGER) && fieldValue != null && type.asInt(fieldValue) > Integer.parseInt(max)) {
                throw new OValidationException("The field '" + iRecord.getClassName() + "." + p.getName() + "' is major than " + max);
            }
            if (p.getType().equals((Object)OType.LONG) && fieldValue != null && type.asLong(fieldValue) > Long.parseLong(max)) {
                throw new OValidationException("The field '" + iRecord.getClassName() + "." + p.getName() + "' is major than " + max);
            }
            if (p.getType().equals((Object)OType.FLOAT) && fieldValue != null && type.asFloat(fieldValue) > Float.parseFloat(max)) {
                throw new OValidationException("The field '" + iRecord.getClassName() + "." + p.getName() + "' is major than " + max);
            }
            if (p.getType().equals((Object)OType.DOUBLE) && fieldValue != null && type.asDouble(fieldValue) > Double.parseDouble(max)) {
                throw new OValidationException("The field '" + iRecord.getClassName() + "." + p.getName() + "' is major than " + max);
            }
            if (p.getType().equals((Object)OType.DATE)) {
                try {
                    if (fieldValue != null && ((Date)fieldValue).before(iRecord.getDatabase().getStorage().getConfiguration().getDateFormatInstance().parse(max))) {
                        throw new OValidationException("The field '" + iRecord.getClassName() + "." + p.getName() + "' contains the date " + fieldValue + "that is after the date accepted (" + max + ")");
                    }
                }
                catch (ParseException e) {}
            } else if (p.getType().equals((Object)OType.DATETIME)) {
                try {
                    if (fieldValue != null && ((Date)fieldValue).before(iRecord.getDatabase().getStorage().getConfiguration().getDateTimeFormatInstance().parse(max))) {
                        throw new OValidationException("The field '" + iRecord.getClassName() + "." + p.getName() + "' contains the datetime " + fieldValue + "that is after the datetime accepted (" + max + ")");
                    }
                }
                catch (ParseException e) {}
            } else if (p.getType().equals((Object)OType.EMBEDDEDLIST) || p.getType().equals((Object)OType.EMBEDDEDSET) || p.getType().equals((Object)OType.LINKLIST) || p.getType().equals((Object)OType.LINKSET) && fieldValue != null && ((Collection)fieldValue).size() > Integer.parseInt(max)) {
                throw new OValidationException("The field '" + iRecord.getClassName() + "." + p.getName() + "' contains more items then " + max + " requested");
            }
        }
    }

    protected void checkForLoading() {
        if (this._status == ORecordElement.STATUS.NOT_LOADED && this._database != null) {
            this.reload(null, true);
        }
    }
}

