/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record.impl;

import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordLazyMap;
import com.orientechnologies.orient.core.db.record.ORecordLazySet;
import com.orientechnologies.orient.core.db.record.ORecordTrackedList;
import com.orientechnologies.orient.core.db.record.ORecordTrackedSet;
import com.orientechnologies.orient.core.db.record.OTrackedList;
import com.orientechnologies.orient.core.db.record.OTrackedMap;
import com.orientechnologies.orient.core.db.record.OTrackedSet;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentComparator;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerStringAbstract;
import java.lang.reflect.Array;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODocumentHelper {
    public static final String ATTRIBUTE_THIS = "@this";
    public static final String ATTRIBUTE_RID = "@rid";
    public static final String ATTRIBUTE_VERSION = "@version";
    public static final String ATTRIBUTE_CLASS = "@class";
    public static final String ATTRIBUTE_TYPE = "@type";
    public static final String ATTRIBUTE_SIZE = "@size";
    public static final String ATTRIBUTE_FIELDS = "@fields";

    public static void sort(List<OIdentifiable> ioResultSet, List<OPair<String, String>> iOrderCriteria) {
        Collections.sort(ioResultSet, new ODocumentComparator(iOrderCriteria));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <RET> RET convertField(ODocument iDocument, String iFieldName, Class<?> iFieldType, Object iValue) {
        if (iFieldType == null) {
            return (RET)iValue;
        }
        if (ORID.class.isAssignableFrom(iFieldType)) {
            if (iValue instanceof ORID) {
                return (RET)iValue;
            }
            if (iValue instanceof String) {
                return (RET)new ORecordId((String)iValue);
            }
            if (iValue instanceof ORecord) {
                return (RET)((ORecord)iValue).getIdentity();
            }
        } else if (ORecord.class.isAssignableFrom(iFieldType)) {
            if (iValue instanceof ORID || iValue instanceof ORecord) {
                return (RET)iValue;
            }
            if (iValue instanceof String) {
                return (RET)new ORecordId((String)iValue);
            }
        } else if (Set.class.isAssignableFrom(iFieldType)) {
            if (iValue instanceof Set) return (RET)iValue;
            Set<OIdentifiable> newValue = iValue instanceof ORecordLazyList || iValue instanceof ORecordLazyMap ? new ORecordLazySet(iDocument) : new OTrackedSet(iDocument);
            if (iValue instanceof Collection) {
                newValue.addAll((Collection)iValue);
                return (RET)newValue;
            }
            if (iValue instanceof Map) {
                newValue.addAll(((Map)iValue).values());
                return (RET)newValue;
            }
            if (iValue instanceof String) {
                String[] items;
                String stringValue = (String)iValue;
                if (stringValue == null || stringValue.length() <= 0) return (RET)newValue;
                for (String s : items = stringValue.split(",")) {
                    newValue.add((OIdentifiable)((Object)s));
                }
                return (RET)newValue;
            }
        } else if (List.class.isAssignableFrom(iFieldType)) {
            if (iValue instanceof List) return (RET)iValue;
            OTrackedList newValue = iValue instanceof ORecordLazySet || iValue instanceof ORecordLazyMap ? new ORecordLazyList(iDocument) : new OTrackedList(iDocument);
            if (iValue instanceof Collection) {
                newValue.addAll((Collection)iValue);
                return (RET)newValue;
            }
            if (iValue instanceof Map) {
                newValue.addAll(((Map)iValue).values());
                return (RET)newValue;
            }
            if (iValue instanceof String) {
                String[] items;
                String stringValue = (String)iValue;
                if (stringValue == null || stringValue.length() <= 0) return (RET)newValue;
                for (String s : items = stringValue.split(",")) {
                    newValue.add(s);
                }
                return (RET)newValue;
            }
        } else if (iValue instanceof Enum) {
            iValue = Number.class.isAssignableFrom(iFieldType) ? Integer.valueOf(((Enum)iValue).ordinal()) : iValue.toString();
            if (!(iValue instanceof String) && !iFieldType.isAssignableFrom(iValue.getClass())) {
                throw new IllegalArgumentException("Property '" + iFieldName + "' of type '" + iFieldType + "' can't accept value of type: " + iValue.getClass());
            }
        } else if (Date.class.isAssignableFrom(iFieldType) && iValue instanceof String && iDocument.getDatabase() != null) {
            OStorageConfiguration config = iDocument.getDatabase().getStorage().getConfiguration();
            DateFormat formatter = config.getDateFormatInstance();
            if (((String)iValue).length() > config.dateFormat.length()) {
                formatter = config.getDateTimeFormatInstance();
            }
            try {
                Date newValue = formatter.parse((String)iValue);
                return (RET)newValue;
            }
            catch (ParseException pe) {
                String dateFormat = ((String)iValue).length() > config.dateFormat.length() ? config.dateTimeFormat : config.dateFormat;
                throw new OQueryParsingException("Error on conversion of date '" + iValue + "' using the format: " + dateFormat);
            }
        }
        iValue = OType.convert(iValue, iFieldType);
        return (RET)iValue;
    }

    public static <RET> RET getFieldValue(ODocument current, String iFieldName) {
        int fieldNameLength = iFieldName.length();
        if (fieldNameLength == 0) {
            return null;
        }
        Object value = null;
        int beginPos = 0;
        int separatorPos = 0;
        do {
            int separator = 32;
            while (separatorPos < fieldNameLength && (separator = (int)iFieldName.charAt(separatorPos)) != 46 && separator != 91) {
                ++separatorPos;
            }
            String fieldName = separatorPos < fieldNameLength ? iFieldName.substring(beginPos, separatorPos) : (beginPos > 0 ? iFieldName.substring(beginPos) : iFieldName);
            if (separator == 46) {
                value = ODocumentHelper.getIdentifiableValue(current, fieldName);
                if (value == null || !(value instanceof ODocument)) {
                    return null;
                }
                current = (ODocument)value;
                if (current.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
                    current.reload();
                }
            } else if (separator == 91) {
                Object[] values;
                if (value == null) {
                    value = ODocumentHelper.getIdentifiableValue(current, fieldName);
                }
                if (value == null) {
                    return null;
                }
                int end = iFieldName.indexOf(93, separatorPos);
                if (end == -1) {
                    throw new IllegalArgumentException("Missed closed ']'");
                }
                String index = OStringSerializerHelper.getStringContent(iFieldName.substring(separatorPos + 1, end));
                separatorPos = end;
                if (value instanceof ODocument) {
                    List<String> indexParts = OStringSerializerHelper.smartSplit(index, ',', new char[0]);
                    if (indexParts.size() == 1) {
                        value = ((ODocument)value).field(index);
                    } else {
                        values = new Object[indexParts.size()];
                        for (int i = 0; i < indexParts.size(); ++i) {
                            values[i] = ((ODocument)value).field(indexParts.get(i));
                        }
                        value = values;
                    }
                } else if (value instanceof Map) {
                    List<String> indexParts = OStringSerializerHelper.smartSplit(index, ',', new char[0]);
                    if (indexParts.size() == 1) {
                        value = ((Map)value).get(index);
                    } else {
                        values = new Object[indexParts.size()];
                        for (int i = 0; i < indexParts.size(); ++i) {
                            values[i] = ((Map)value).get(indexParts.get(i));
                        }
                        value = values;
                    }
                } else if (value instanceof Collection || value.getClass().isArray()) {
                    Object[] values2;
                    boolean isArray = value.getClass().isArray();
                    List<String> indexParts = OStringSerializerHelper.smartSplit(index, ',', new char[0]);
                    List<String> indexRanges = OStringSerializerHelper.smartSplit(index, '-', new char[0]);
                    List<String> indexCondition = OStringSerializerHelper.smartSplit(index, '=', ' ');
                    if (indexParts.size() == 1 && indexRanges.size() == 1 && indexCondition.size() == 1) {
                        value = isArray ? Array.get(value, Integer.parseInt(index)) : ((List)value).get(Integer.parseInt(index));
                    } else if (indexParts.size() > 1) {
                        values2 = new Object[indexParts.size()];
                        for (int i = 0; i < indexParts.size(); ++i) {
                            values2[i] = isArray ? Array.get(value, Integer.parseInt(indexParts.get(i))) : ((List)value).get(Integer.parseInt(indexParts.get(i)));
                        }
                        value = values2;
                    } else if (indexRanges.size() > 1) {
                        int rangeFrom = Integer.parseInt(indexRanges.get(0));
                        int rangeTo = Integer.parseInt(indexRanges.get(1));
                        values2 = new Object[rangeTo - rangeFrom + 1];
                        for (int i = rangeFrom; i <= rangeTo; ++i) {
                            values2[i - rangeFrom] = isArray ? Array.get(value, i) : ((List)value).get(i);
                        }
                        value = values2;
                    } else if (indexCondition.size() > 0) {
                        String conditionFieldName = indexCondition.get(0);
                        Object conditionFieldValue = ORecordSerializerStringAbstract.getTypeValue(indexCondition.get(1));
                        if (conditionFieldValue instanceof String) {
                            conditionFieldValue = OStringSerializerHelper.getStringContent(conditionFieldValue);
                        }
                        ArrayList<ODocument> values3 = new ArrayList<ODocument>();
                        for (Object v : (Collection)value) {
                            if (!(v instanceof ODocument)) continue;
                            ODocument doc = (ODocument)v;
                            Object fieldValue = doc.field(conditionFieldName);
                            if ((fieldValue = OType.convert(fieldValue, conditionFieldValue.getClass())) == null || !fieldValue.equals(conditionFieldValue)) continue;
                            values3.add(doc);
                        }
                        value = values3.isEmpty() ? null : (values3.size() == 1 ? values3.iterator().next() : values3);
                    }
                }
            } else {
                value = ODocumentHelper.getIdentifiableValue(current, fieldName);
            }
            beginPos = ++separatorPos;
        } while (separatorPos < fieldNameLength);
        return (RET)value;
    }

    public static Object getIdentifiableValue(OIdentifiable iCurrent, String iFieldName) {
        if (iFieldName == null || iFieldName.length() == 0) {
            return null;
        }
        char begin = iFieldName.charAt(0);
        if (begin == '@') {
            if (iFieldName.equalsIgnoreCase(ATTRIBUTE_THIS)) {
                return iCurrent;
            }
            if (iFieldName.equalsIgnoreCase(ATTRIBUTE_RID)) {
                return iCurrent.getIdentity();
            }
            if (iFieldName.equalsIgnoreCase(ATTRIBUTE_VERSION)) {
                return ((ODocument)iCurrent.getRecord()).getVersion();
            }
            if (iFieldName.equalsIgnoreCase(ATTRIBUTE_CLASS)) {
                return ((ODocument)iCurrent.getRecord()).getClassName();
            }
            if (iFieldName.equalsIgnoreCase(ATTRIBUTE_TYPE)) {
                return Orient.instance().getRecordFactoryManager().getRecordTypeName(((ORecordInternal)iCurrent.getRecord()).getRecordType());
            }
            if (iFieldName.equalsIgnoreCase(ATTRIBUTE_TYPE)) {
                return Orient.instance().getRecordFactoryManager().getRecordTypeName(((ORecordInternal)iCurrent.getRecord()).getRecordType());
            }
            if (iFieldName.equalsIgnoreCase(ATTRIBUTE_SIZE)) {
                byte[] stream = ((ORecordInternal)iCurrent.getRecord()).toStream();
                if (stream != null) {
                    return stream.length;
                }
            } else if (iFieldName.equalsIgnoreCase(ATTRIBUTE_FIELDS)) {
                return ((ODocument)iCurrent.getRecord()).fieldNames();
            }
            throw new IllegalArgumentException("Document attribute '" + iFieldName + "' not supported");
        }
        return ((ODocument)iCurrent.getRecord())._fieldValues.get(iFieldName);
    }

    public static void copyFieldValue(ODocument iCloned, Map.Entry<String, Object> iEntry) {
        Object fieldValue = iEntry.getValue();
        if (fieldValue != null) {
            if (fieldValue instanceof ORecordLazyList) {
                iCloned._fieldValues.put(iEntry.getKey(), ((ORecordLazyList)fieldValue).copy(iCloned));
            } else if (fieldValue instanceof ORecordTrackedList) {
                ORecordTrackedList newList = new ORecordTrackedList(iCloned);
                newList.addAll((ORecordTrackedList)fieldValue);
                iCloned._fieldValues.put(iEntry.getKey(), newList);
            } else if (fieldValue instanceof OTrackedList) {
                OTrackedList newList = new OTrackedList(iCloned);
                newList.addAll((OTrackedList)fieldValue);
                iCloned._fieldValues.put(iEntry.getKey(), newList);
            } else if (fieldValue instanceof List) {
                iCloned._fieldValues.put(iEntry.getKey(), new ArrayList((List)fieldValue));
            } else if (fieldValue instanceof ORecordLazySet) {
                iCloned._fieldValues.put(iEntry.getKey(), ((ORecordLazySet)fieldValue).copy(iCloned));
            } else if (fieldValue instanceof ORecordTrackedSet) {
                ORecordTrackedSet newList = new ORecordTrackedSet(iCloned);
                newList.addAll((ORecordTrackedSet)fieldValue);
                iCloned._fieldValues.put(iEntry.getKey(), newList);
            } else if (fieldValue instanceof OTrackedSet) {
                OTrackedSet newList = new OTrackedSet(iCloned);
                newList.addAll((OTrackedSet)fieldValue);
                iCloned._fieldValues.put(iEntry.getKey(), newList);
            } else if (fieldValue instanceof Set) {
                iCloned._fieldValues.put(iEntry.getKey(), new HashSet((Set)fieldValue));
            } else if (fieldValue instanceof ORecordLazyMap) {
                ORecordLazyMap newMap = new ORecordLazyMap(iCloned, ((ORecordLazyMap)fieldValue).getRecordType());
                newMap.putAll((ORecordLazyMap)fieldValue);
                iCloned._fieldValues.put(iEntry.getKey(), newMap);
            } else if (fieldValue instanceof OTrackedMap) {
                OTrackedMap newMap = new OTrackedMap(iCloned);
                newMap.putAll((OTrackedMap)fieldValue);
                iCloned._fieldValues.put(iEntry.getKey(), newMap);
            } else if (fieldValue instanceof Map) {
                iCloned._fieldValues.put(iEntry.getKey(), new LinkedHashMap((Map)fieldValue));
            } else {
                iCloned._fieldValues.put(iEntry.getKey(), fieldValue);
            }
        }
    }

    public static boolean hasSameContentItem(Object iCurrent, Object iOther) {
        if (iCurrent instanceof ODocument) {
            ODocument otherDoc;
            ODocument current = (ODocument)iCurrent;
            if (iOther instanceof ORID ? (!current.isDirty() ? !current.getIdentity().equals(iOther) : !ODocumentHelper.hasSameContentOf(current, otherDoc = (ODocument)current.getDatabase().load((ORID)iOther))) : !ODocumentHelper.hasSameContentOf(current, (ODocument)iOther)) {
                return false;
            }
        } else if (!iCurrent.equals(iOther)) {
            return false;
        }
        return true;
    }

    public static boolean hasSameContentOf(ODocument iCurrent, ODocument iOther) {
        if (iOther == null) {
            return false;
        }
        if (!iCurrent.equals(iOther) && iCurrent.getIdentity().isValid()) {
            return false;
        }
        if (iCurrent.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
            iCurrent.reload();
        }
        if (iOther.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
            iOther = (ODocument)iOther.load();
        }
        iCurrent.checkForFields();
        iOther.checkForFields();
        if (iCurrent._fieldValues.size() != iOther._fieldValues.size()) {
            return false;
        }
        for (Map.Entry<String, Object> f : iCurrent._fieldValues.entrySet()) {
            Object myFieldValue = f.getValue();
            Object otherFieldValue = iOther._fieldValues.get(f.getKey());
            if (myFieldValue == null ? otherFieldValue != null : otherFieldValue == null) {
                return false;
            }
            if (myFieldValue == null || otherFieldValue == null) continue;
            if (myFieldValue instanceof Collection && otherFieldValue instanceof Collection) {
                Collection myCollection = (Collection)myFieldValue;
                Collection otherCollection = (Collection)otherFieldValue;
                if (myCollection.size() != otherCollection.size()) {
                    return false;
                }
                Iterator myIterator = myCollection.iterator();
                Iterator otherIterator = otherCollection.iterator();
                while (myIterator.hasNext()) {
                    ODocumentHelper.hasSameContentItem(myIterator.next(), otherIterator.next());
                }
                continue;
            }
            if (myFieldValue instanceof Map && otherFieldValue instanceof Map) {
                Map myMap = (Map)myFieldValue;
                Map otherMap = (Map)otherFieldValue;
                if (myMap.size() != otherMap.size()) {
                    return false;
                }
                for (Map.Entry myEntry : myMap.entrySet()) {
                    if (!otherMap.containsKey(myEntry.getKey())) {
                        return false;
                    }
                    if (!(myEntry.getValue() instanceof ODocument ? !ODocumentHelper.hasSameContentOf((ODocument)myEntry.getValue(), (ODocument)otherMap.get(myEntry.getKey())) : !myEntry.getValue().equals(otherMap.get(myEntry.getKey())))) continue;
                    return false;
                }
                continue;
            }
            if (myFieldValue.equals(otherFieldValue)) continue;
            return false;
        }
        return true;
    }
}

