/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization;

import com.orientechnologies.orient.core.serialization.OMemoryInputStream;
import java.io.IOException;
import java.io.InputStream;

public class OMemoryInputStreamCursor
extends InputStream {
    private final OMemoryInputStream source;
    private int offset;
    private int position;
    private final int size;

    public OMemoryInputStreamCursor(OMemoryInputStream iSource, int iOffset, int iSize) {
        this.source = iSource;
        this.offset = iOffset;
        this.size = iSize;
        this.position = this.offset;
    }

    public int read() throws IOException {
        ++this.position;
        return this.source.read();
    }

    public int available() throws IOException {
        return this.size - (this.position - this.offset);
    }

    public String getAsString() throws IOException {
        int beginOffset = this.source.getPosition();
        String s = this.source.getAsString();
        this.position += this.source.getPosition() - beginOffset;
        return s;
    }

    public byte[] getAsByteArrayFixed(int iSize) throws IOException {
        this.position += iSize;
        return this.source.getAsByteArrayFixed(iSize);
    }

    public long getAsLong() throws IOException {
        this.position += 8;
        return this.source.getAsLong();
    }

    public int getPosition() {
        return this.position;
    }

    public int getSize() {
        return this.size;
    }
}

