/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record;

import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerRaw;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerJSON;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerSchemaAware2CSV;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORecordSerializerFactory {
    private static final ORecordSerializerFactory instance = new ORecordSerializerFactory();
    private Map<String, ORecordSerializer> implementations = new HashMap<String, ORecordSerializer>();
    private ORecordSerializer defaultRecordFormat = new ORecordSerializerRaw();

    public ORecordSerializerFactory() {
        this.implementations.put("ORecordDocument2csv", new ORecordSerializerSchemaAware2CSV());
        this.implementations.put("json", new ORecordSerializerJSON());
        this.implementations.put("ORecordDocumentRaw", this.defaultRecordFormat);
    }

    public Collection<ORecordSerializer> getFormats() {
        return this.implementations.values();
    }

    public ORecordSerializer getFormat(String iFormatName) {
        if (iFormatName == null) {
            return null;
        }
        return this.implementations.get(iFormatName);
    }

    public ORecordSerializer getFormatForObject(Object iObject, String iFormatName) {
        if (iObject == null) {
            return null;
        }
        ORecordSerializer recordFormat = null;
        if (iFormatName != null) {
            recordFormat = this.implementations.get(iObject.getClass().getSimpleName() + "2" + iFormatName);
        }
        if (recordFormat == null) {
            recordFormat = this.defaultRecordFormat;
        }
        return recordFormat;
    }

    public ORecordSerializer getDefaultRecordFormat() {
        return this.defaultRecordFormat;
    }

    public void setDefaultRecordFormat(ORecordSerializer iDefaultFormat) {
        this.defaultRecordFormat = iDefaultFormat;
    }

    public static ORecordSerializerFactory instance() {
        return instance;
    }
}

