/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record.string;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OStringParser;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.OUserObject2RecordHandler;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordLazySet;
import com.orientechnologies.orient.core.db.record.OTrackedList;
import com.orientechnologies.orient.core.db.record.OTrackedSet;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.fetch.OFetchHelper;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordSchemaAware;
import com.orientechnologies.orient.core.record.ORecordStringable;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ORecordBytes;
import com.orientechnologies.orient.core.serialization.OBase64Utils;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerStringAbstract;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORecordSerializerJSON
extends ORecordSerializerStringAbstract {
    public static final String NAME = "json";
    public static final ORecordSerializerJSON INSTANCE = new ORecordSerializerJSON();
    public static final String ATTRIBUTE_FIELD_TYPES = "@fieldTypes";
    public static final String DEF_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss:SSS";
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");

    @Override
    public ORecordInternal<?> fromString(ODatabaseRecord iDatabase, String iSource) {
        return this.fromString(iDatabase, iSource, null);
    }

    @Override
    public ORecordInternal<?> fromString(ODatabaseRecord iDatabase, String iSource, ORecordInternal<?> iRecord) {
        String[] fields;
        if (iSource == null) {
            throw new OSerializationException("Error on unmarshalling JSON content: content is null");
        }
        if (!(iSource = iSource.trim()).startsWith("{") || !iSource.endsWith("}")) {
            throw new OSerializationException("Error on unmarshalling JSON content: content must be between { }");
        }
        if (iRecord != null) {
            iRecord.reset();
        }
        if ((fields = OStringParser.getWords((String)(iSource = iSource.substring(1, iSource.length() - 1).trim()), (String)":,", (boolean)true)).length % 2 != 0) {
            throw new OSerializationException("Error on unmarshalling JSON content: wrong format. Use <field> : <value>");
        }
        HashMap<String, Character> fieldTypes = null;
        if (fields != null && fields.length > 0) {
            String fieldValueAsString;
            String fieldValue;
            String fieldName;
            int i;
            for (i = 0; i < fields.length; i += 2) {
                fieldName = fields[i];
                fieldName = fieldName.substring(1, fieldName.length() - 1);
                fieldValue = fields[i + 1];
                String string = fieldValueAsString = fieldValue.length() >= 2 ? fieldValue.substring(1, fieldValue.length() - 1) : fieldValue;
                if (fieldName.equals(ATTRIBUTE_FIELD_TYPES) && iRecord instanceof ODocument) {
                    String[] fieldTypesParts = fieldValueAsString.split(",");
                    if (fieldTypesParts.length <= 0) continue;
                    fieldTypes = new HashMap<String, Character>();
                    for (String f : fieldTypesParts) {
                        String[] part = f.split("=");
                        if (part.length != 2) continue;
                        fieldTypes.put(part[0], Character.valueOf(part[1].charAt(0)));
                    }
                    continue;
                }
                if (!fieldName.equals("@type") || iRecord != null && iRecord.getRecordType() == fieldValueAsString.charAt(0)) continue;
                iRecord = Orient.instance().getRecordFactoryManager().newInstance(iDatabase, (byte)fieldValueAsString.charAt(0));
            }
            try {
                for (i = 0; i < fields.length; i += 2) {
                    fieldName = fields[i];
                    fieldName = fieldName.substring(1, fieldName.length() - 1);
                    fieldValue = fields[i + 1].trim();
                    String string = fieldValueAsString = fieldValue.length() >= 2 ? fieldValue.substring(1, fieldValue.length() - 1) : fieldValue;
                    if (fieldName.equals("@rid")) {
                        iRecord.setIdentity(new ORecordId(fieldValueAsString));
                        continue;
                    }
                    if (fieldName.equals("@version")) {
                        iRecord.setVersion(Integer.parseInt(fieldValue));
                        continue;
                    }
                    if (fieldName.equals("@type")) continue;
                    if (fieldName.equals("@class") && iRecord instanceof ODocument) {
                        ((ODocument)iRecord).setClassNameIfExists("null".equals(fieldValueAsString) ? null : fieldValueAsString);
                        continue;
                    }
                    if (fieldName.equals(ATTRIBUTE_FIELD_TYPES) && iRecord instanceof ODocument) continue;
                    if (fieldName.equals("value") && !(iRecord instanceof ODocument)) {
                        if ("null".equals(fieldValue)) {
                            iRecord.fromStream(new byte[0]);
                            continue;
                        }
                        if (iRecord instanceof ORecordBytes) {
                            iRecord.fromStream(OBase64Utils.decode(fieldValueAsString));
                            continue;
                        }
                        if (!(iRecord instanceof ORecordStringable)) continue;
                        ((ORecordStringable)((Object)iRecord)).value(fieldValueAsString);
                        continue;
                    }
                    if (!(iRecord instanceof ODocument)) continue;
                    Object v = this.getValue((ODocument)iRecord, fieldName, fieldValue, fieldValueAsString, null, null, fieldTypes);
                    if (v != null) {
                        Object first;
                        if (v instanceof Collection && ((Collection)v).size() > 0) {
                            if (v instanceof ORecordLazySet) {
                                ((ORecordLazySet)v).setAutoConvertToRecord(false);
                            } else if (v instanceof ORecordLazyList) {
                                ((ORecordLazyList)v).setAutoConvertToRecord(false);
                            }
                            first = ((Collection)v).iterator().next();
                            if (first != null && first instanceof ORecord && !((ORecord)first).getIdentity().isValid()) {
                                ((ODocument)iRecord).field(fieldName, v, v instanceof Set ? OType.EMBEDDEDSET : OType.EMBEDDEDLIST);
                                continue;
                            }
                        } else if (v instanceof Map && ((Map)v).size() > 0 && (first = ((Map)v).values().iterator().next()) != null && first instanceof ORecord && !((ORecord)first).getIdentity().isValid()) {
                            ((ODocument)iRecord).field(fieldName, v, OType.EMBEDDEDMAP);
                            continue;
                        }
                    }
                    ((ODocument)iRecord).field(fieldName, v);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new OSerializationException("Error on unmarshalling JSON content for record " + iRecord.getIdentity(), e);
            }
        }
        return iRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getValue(ODocument iRecord, String iFieldName, String iFieldValue, String iFieldValueAsString, OType iType, OType iLinkedType, Map<String, Character> iFieldTypes) {
        OProperty p;
        if (iFieldValue.equals("null")) {
            return null;
        }
        if (iFieldName != null && iRecord.getSchemaClass() != null && (p = iRecord.getSchemaClass().getProperty(iFieldName)) != null) {
            iType = p.getType();
            iLinkedType = p.getLinkedType();
        }
        if (iFieldValue.startsWith("{") && iFieldValue.endsWith("}")) {
            String[] fields = OStringParser.getWords((String)iFieldValueAsString, (String)":,", (boolean)true);
            if (fields == null || fields.length == 0) {
                return new HashMap();
            }
            if (this.hasTypeField(fields)) {
                return this.fromString(iRecord.getDatabase(), iFieldValue, null);
            }
            if (fields.length % 2 == 1) {
                throw new OSerializationException("Bad JSON format on map. Expected pairs of field:value but received '" + iFieldValueAsString + "'");
            }
            LinkedHashMap<String, Object> embeddedMap = new LinkedHashMap<String, Object>();
            for (int i = 0; i < fields.length; i += 2) {
                iFieldName = fields[i];
                if (iFieldName.length() >= 2) {
                    iFieldName = iFieldName.substring(1, iFieldName.length() - 1);
                }
                iFieldValueAsString = (iFieldValue = fields[i + 1]).length() >= 2 ? iFieldValue.substring(1, iFieldValue.length() - 1) : iFieldValue;
                embeddedMap.put(iFieldName, this.getValue(iRecord, null, iFieldValue, iFieldValueAsString, iLinkedType, null, iFieldTypes));
            }
            return embeddedMap;
        }
        if (iFieldValue.startsWith("[") && iFieldValue.endsWith("]")) {
            Collection<OIdentifiable> embeddedCollection = iType == OType.LINKSET ? new ORecordLazySet(iRecord) : (iType == OType.EMBEDDEDSET ? new OTrackedSet(iRecord) : (iType == OType.LINKLIST ? new ORecordLazyList(iRecord) : new OTrackedList(iRecord)));
            if ((iFieldValue = iFieldValue.substring(1, iFieldValue.length() - 1)).length() > 0) {
                List<String> items = OStringSerializerHelper.smartSplit(iFieldValue, ',', new char[0]);
                for (String item : items) {
                    iFieldValueAsString = (iFieldValue = item.trim()).length() >= 2 ? iFieldValue.substring(1, iFieldValue.length() - 1) : iFieldValue;
                    Object collectionItem = this.getValue(iRecord, null, iFieldValue, iFieldValueAsString, iLinkedType, null, iFieldTypes);
                    if (collectionItem instanceof ODocument && iRecord instanceof ODocument) {
                        ((ODocument)collectionItem).addOwner(iRecord);
                    }
                    embeddedCollection.add((OIdentifiable)collectionItem);
                }
            }
            return embeddedCollection;
        }
        if (iType == null) {
            Serializable c;
            if (iFieldValue.charAt(0) != '\"' && iFieldValue.charAt(0) != '\'') {
                if (iFieldValue.equalsIgnoreCase("false") || iFieldValue.equalsIgnoreCase("true")) {
                    iType = OType.BOOLEAN;
                } else {
                    c = null;
                    if (iFieldTypes != null && (c = iFieldTypes.get(iFieldName)) != null) {
                        iType = ORecordSerializerStringAbstract.getType(iFieldValue + c);
                    }
                    if (c == null && iFieldValue.length() > 0) {
                        iType = iFieldValue.charAt(0) == '#' && iFieldValue.contains(":") ? OType.LINK : (OStringSerializerHelper.contains(iFieldValue, '.') ? OType.FLOAT : OType.INTEGER);
                    }
                }
            } else if (iFieldValueAsString.length() >= 4 && iFieldValueAsString.charAt(0) == '#' && iFieldValueAsString.contains(":")) {
                iType = OType.LINK;
            } else if (iFieldValueAsString.startsWith("{") && iFieldValueAsString.endsWith("}")) {
                iType = OType.EMBEDDED;
            } else {
                if (iFieldValueAsString.length() == DEF_DATE_FORMAT.length()) {
                    try {
                        c = this.dateFormat;
                        synchronized (c) {
                            return this.dateFormat.parseObject(iFieldValueAsString);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                iType = OType.STRING;
            }
        }
        if (iType != null) {
            switch (iType) {
                case STRING: {
                    return iFieldValueAsString;
                }
                case LINK: {
                    int pos = iFieldValueAsString.indexOf(64);
                    if (pos > -1) {
                        return new ODocument(iRecord.getDatabase(), iFieldValueAsString.substring(1, pos), new ORecordId(iFieldValueAsString.substring(pos + 1)));
                    }
                    return new ORecordId(iFieldValueAsString.substring(1));
                }
                case EMBEDDED: {
                    return this.fromString(iRecord.getDatabase(), iFieldValueAsString);
                }
                case DATE: 
                case DATETIME: {
                    if (iFieldValueAsString == null || iFieldValueAsString.equals("")) {
                        return null;
                    }
                    try {
                        return Long.parseLong(iFieldValueAsString);
                    }
                    catch (NumberFormatException e) {
                        try {
                            return this.dateFormat.parseObject(iFieldValueAsString);
                        }
                        catch (ParseException ex) {
                            throw new OSerializationException("Unable to unmarshall date: " + iFieldValueAsString, e);
                        }
                    }
                }
            }
            return OStringSerializerHelper.fieldTypeFromStream(iRecord, iType, iFieldValue);
        }
        return iFieldValueAsString;
    }

    @Override
    public StringBuilder toString(ORecordInternal<?> iRecord, StringBuilder iOutput, String iFormat, OUserObject2RecordHandler iObjHandler, Set<Integer> iMarshalledRecords, boolean iOnlyDelta) {
        try {
            Object record;
            boolean keepTypes;
            int indentLevel;
            boolean attribSameRow;
            boolean includeClazz;
            boolean includeId;
            boolean includeVer;
            boolean includeType;
            StringWriter buffer = new StringWriter();
            OJSONWriter json = new OJSONWriter(buffer, iFormat);
            HashSet<ORID> parsedRecords = new HashSet<ORID>();
            String fetchPlan = null;
            if (iFormat == null) {
                includeType = true;
                includeVer = true;
                includeId = true;
                includeClazz = true;
                attribSameRow = true;
                indentLevel = 0;
                fetchPlan = "";
                keepTypes = false;
            } else {
                String[] format;
                includeType = false;
                includeVer = false;
                includeId = false;
                includeClazz = false;
                attribSameRow = false;
                indentLevel = 0;
                keepTypes = false;
                for (String f : format = iFormat.split(",")) {
                    if (f.equals("type")) {
                        includeType = true;
                        continue;
                    }
                    if (f.equals("rid")) {
                        includeId = true;
                        continue;
                    }
                    if (f.equals("version")) {
                        includeVer = true;
                        continue;
                    }
                    if (f.equals("class")) {
                        includeClazz = true;
                        continue;
                    }
                    if (f.equals("attribSameRow")) {
                        attribSameRow = true;
                        continue;
                    }
                    if (f.startsWith("indent")) {
                        indentLevel = Integer.parseInt(f.substring(f.indexOf(58) + 1));
                        continue;
                    }
                    if (f.startsWith("fetchPlan")) {
                        fetchPlan = f.substring(f.indexOf(58) + 1);
                        continue;
                    }
                    if (!f.startsWith("keepTypes")) continue;
                    keepTypes = true;
                }
            }
            json.beginObject(indentLevel);
            this.writeSignature(json, indentLevel, includeType, includeId, includeVer, includeClazz, attribSameRow, iRecord);
            if (iRecord instanceof ORecordSchemaAware) {
                record = (ORecordSchemaAware)iRecord;
                parsedRecords.add(iRecord.getIdentity());
                Map<String, Integer> fetchPlanMap = null;
                if (fetchPlan != null && fetchPlan.length() > 0) {
                    fetchPlanMap = OFetchHelper.buildFetchPlan(fetchPlan);
                }
                this.processRecord(json, indentLevel, includeType, includeId, includeVer, includeClazz, attribSameRow, (ORecordSchemaAware<?>)record, fetchPlanMap, keepTypes, 0, -1, (Set<ORID>)parsedRecords);
            } else if (iRecord instanceof ORecordStringable) {
                record = (ORecordStringable)((Object)iRecord);
                json.writeAttribute(indentLevel + 1, true, "value", record.value());
            } else if (iRecord instanceof ORecordBytes) {
                record = (ORecordBytes)iRecord;
                json.writeAttribute(indentLevel + 1, true, "value", OBase64Utils.encodeBytes(((ORecordBytes)record).toStream()));
            } else {
                throw new OSerializationException("Error on marshalling record of type '" + iRecord.getClass() + "' to JSON. The record type can't be exported to JSON");
            }
            json.endObject(indentLevel);
            parsedRecords.clear();
            iOutput.append(buffer);
            return iOutput;
        }
        catch (IOException e) {
            throw new OSerializationException("Error on marshalling of record to JSON", e);
        }
    }

    private void processRecord(OJSONWriter json, int indentLevel, boolean includeType, boolean includeId, boolean includeVer, boolean includeClazz, boolean attribSameRow, ORecordSchemaAware<?> record, Map<String, Integer> iFetchPlan, boolean keepTypes, int iCurrentLevel, int iMaxFetch, Set<ORID> parsedRecords) throws IOException {
        StringBuilder types = new StringBuilder();
        for (String fieldName : record.fieldNames()) {
            if (iFetchPlan == null) {
                Object v = record.field(fieldName);
                if (keepTypes) {
                    if (v instanceof Long) {
                        this.appendType(types, fieldName, 'l');
                    } else if (v instanceof Float) {
                        this.appendType(types, fieldName, 'f');
                    } else if (v instanceof Short) {
                        this.appendType(types, fieldName, 's');
                    } else if (v instanceof Double) {
                        this.appendType(types, fieldName, 'd');
                    } else if (v instanceof Date) {
                        this.appendType(types, fieldName, 't');
                    } else if (v instanceof Byte) {
                        this.appendType(types, fieldName, 'b');
                    }
                }
                json.writeAttribute(indentLevel + 1, true, fieldName, OJSONWriter.encode(v));
                continue;
            }
            Integer depthLevel = this.getDepthLevel(record, iFetchPlan, fieldName);
            if (depthLevel != null && (depthLevel == 0 || depthLevel > -1 && depthLevel >= iCurrentLevel)) continue;
            Object fieldValue = record.field(fieldName);
            if (!(fieldValue != null && (fieldValue instanceof OIdentifiable || fieldValue instanceof Collection && ((Collection)fieldValue).size() != 0 && ((Collection)fieldValue).iterator().next() instanceof OIdentifiable || fieldValue instanceof Map && ((Map)fieldValue).size() != 0 && ((Map)fieldValue).values().iterator().next() instanceof OIdentifiable))) {
                json.writeAttribute(indentLevel + 1, true, fieldName, OJSONWriter.encode(fieldValue));
                continue;
            }
            try {
                this.fetch(record, iFetchPlan, fieldValue, fieldName, iCurrentLevel + 1, iMaxFetch, json, indentLevel, includeType, includeId, includeVer, includeClazz, attribSameRow, keepTypes, parsedRecords);
            }
            catch (Exception e) {
                e.printStackTrace();
                OLogManager.instance().error(null, "Fetching error on record %s", (Throwable)e, new Object[]{record.getIdentity()});
            }
        }
        if (keepTypes && types.length() > 0) {
            json.writeAttribute(indentLevel + 1, true, ATTRIBUTE_FIELD_TYPES, types.toString());
        }
    }

    private void appendType(StringBuilder iBuffer, String iFieldName, char iType) {
        if (iBuffer.length() > 0) {
            iBuffer.append(',');
        }
        iBuffer.append(iFieldName);
        iBuffer.append('=');
        iBuffer.append(iType);
    }

    private void writeSignature(OJSONWriter json, int indentLevel, boolean includeType, boolean includeId, boolean includeVer, boolean includeClazz, boolean attribSameRow, ORecordInternal<?> record) throws IOException {
        boolean firstAttribute = true;
        if (includeType) {
            json.writeAttribute(firstAttribute ? indentLevel + 1 : 0, firstAttribute, "@type", "" + (char)record.getRecordType());
            if (attribSameRow) {
                firstAttribute = false;
            }
        }
        if (includeId && record.getIdentity() != null && record.getIdentity().isValid()) {
            json.writeAttribute(!firstAttribute ? indentLevel + 1 : 0, firstAttribute, "@rid", record.getIdentity().toString());
            if (attribSameRow) {
                firstAttribute = false;
            }
        }
        if (includeVer) {
            json.writeAttribute(firstAttribute ? indentLevel + 1 : 0, firstAttribute, "@version", record.getVersion());
            if (attribSameRow) {
                firstAttribute = false;
            }
        }
        if (includeClazz && record instanceof ORecordSchemaAware && ((ORecordSchemaAware)record).getClassName() != null) {
            json.writeAttribute(firstAttribute ? indentLevel + 1 : 0, firstAttribute, "@class", ((ORecordSchemaAware)record).getClassName());
            if (attribSameRow) {
                firstAttribute = false;
            }
        }
    }

    private void fetch(ORecordSchemaAware<?> iRootRecord, Map<String, Integer> iFetchPlan, Object fieldValue, String fieldName, int iCurrentLevel, int iMaxFetch, OJSONWriter json, int indentLevel, boolean includeType, boolean includeId, boolean includeVer, boolean includeClazz, boolean attribSameRow, boolean keepTypes, Set<ORID> parsedRecords) throws IOException {
        Integer anyFieldDepthLevel = iFetchPlan != null ? iFetchPlan.get("*") : -1;
        Integer depthLevel = this.getDepthLevel(iRootRecord, iFetchPlan, fieldName);
        if (depthLevel == null) {
            depthLevel = anyFieldDepthLevel;
        }
        if (depthLevel == 0) {
            return;
        }
        if (depthLevel > -1 && iCurrentLevel >= depthLevel) {
            return;
        }
        if (fieldValue == null) {
            json.writeAttribute(indentLevel + 1, true, fieldName, null);
        } else if (fieldValue instanceof ODocument) {
            this.fetchDocument(iFetchPlan, fieldValue, fieldName, iCurrentLevel, iMaxFetch, json, indentLevel, includeType, includeId, includeVer, includeClazz, attribSameRow, keepTypes, parsedRecords);
        } else if (fieldValue instanceof Collection) {
            this.fetchCollection(iRootRecord.getDatabase(), iFetchPlan, fieldValue, fieldName, iCurrentLevel, iMaxFetch, json, indentLevel, includeType, includeId, includeVer, includeClazz, attribSameRow, keepTypes, parsedRecords);
        } else if (fieldValue.getClass().isArray()) {
            this.fetchArray(iFetchPlan, fieldValue, fieldName, iCurrentLevel, iMaxFetch, json, indentLevel, includeType, includeId, includeVer, includeClazz, attribSameRow, keepTypes, parsedRecords);
        } else if (fieldValue instanceof Map) {
            this.fetchMap(iFetchPlan, fieldValue, fieldName, iCurrentLevel, iMaxFetch, json, indentLevel, includeType, includeId, includeVer, includeClazz, attribSameRow, keepTypes, parsedRecords);
        }
        if (iMaxFetch > -1 && iCurrentLevel >= iMaxFetch) {
            return;
        }
    }

    private void fetchMap(Map<String, Integer> iFetchPlan, Object fieldValue, String fieldName, int iCurrentLevel, int iMaxFetch, OJSONWriter json, int indentLevel, boolean includeType, boolean includeId, boolean includeVer, boolean includeClazz, boolean attribSameRow, boolean keepTypes, Set<ORID> parsedRecords) throws IOException {
        Map linked = (Map)fieldValue;
        json.beginObject(indentLevel + 1, true, fieldValue);
        for (ODocument d : linked.values()) {
            if (!parsedRecords.contains(d.getIdentity())) {
                parsedRecords.add(d.getIdentity());
                json.beginObject(indentLevel + 1, true, null);
                this.writeSignature(json, indentLevel, includeType, includeId, includeVer, includeClazz, attribSameRow, d);
                this.processRecord(json, indentLevel, includeType, includeId, includeVer, includeClazz, attribSameRow, d, iFetchPlan, keepTypes, iCurrentLevel + 1, iMaxFetch, parsedRecords);
                json.endObject(indentLevel + 1, true);
                continue;
            }
            json.writeValue(indentLevel + 1, false, OJSONWriter.encode(d));
        }
        json.endObject(indentLevel + 1, true);
    }

    private void fetchArray(Map<String, Integer> iFetchPlan, Object fieldValue, String fieldName, int iCurrentLevel, int iMaxFetch, OJSONWriter json, int indentLevel, boolean includeType, boolean includeId, boolean includeVer, boolean includeClazz, boolean attribSameRow, boolean keepTypes, Set<ORID> parsedRecords) throws IOException {
        if (fieldValue instanceof ODocument[]) {
            ODocument[] linked = (ODocument[])fieldValue;
            json.beginCollection(indentLevel + 1, true, fieldName);
            for (ODocument d : linked) {
                if (!parsedRecords.contains(d.getIdentity())) {
                    parsedRecords.add(d.getIdentity());
                    json.beginObject(indentLevel + 1, true, null);
                    this.writeSignature(json, indentLevel, includeType, includeId, includeVer, includeClazz, attribSameRow, d);
                    this.processRecord(json, indentLevel, includeType, includeId, includeVer, includeClazz, attribSameRow, d, iFetchPlan, keepTypes, iCurrentLevel + 1, iMaxFetch, parsedRecords);
                    json.endObject(indentLevel + 1, true);
                    continue;
                }
                json.writeValue(indentLevel + 1, false, OJSONWriter.encode(d));
            }
            json.endCollection(indentLevel + 1, false);
        } else {
            json.writeAttribute(indentLevel + 1, true, fieldName, null);
        }
    }

    private void fetchCollection(ODatabaseRecord iDatabase, Map<String, Integer> iFetchPlan, Object fieldValue, String fieldName, int iCurrentLevel, int iMaxFetch, OJSONWriter json, int indentLevel, boolean includeType, boolean includeId, boolean includeVer, boolean includeClazz, boolean attribSameRow, boolean keepTypes, Set<ORID> parsedRecords) throws IOException {
        Collection linked = (Collection)fieldValue;
        json.beginCollection(indentLevel + 1, true, fieldName);
        for (OIdentifiable d : linked) {
            if (!parsedRecords.contains(d.getIdentity())) {
                parsedRecords.add(d.getIdentity());
                if (d instanceof ORecordId) {
                    d = (OIdentifiable)iDatabase.load((ORecordId)d);
                }
                if (!(d instanceof ODocument)) {
                    json.writeValue(indentLevel + 1, false, OJSONWriter.encode(d));
                    continue;
                }
                json.beginObject(indentLevel + 1, true, null);
                this.writeSignature(json, indentLevel, includeType, includeId, includeVer, includeClazz, attribSameRow, (ORecordInternal<?>)d);
                this.processRecord(json, indentLevel, includeType, includeId, includeVer, includeClazz, attribSameRow, (ORecordSchemaAware<?>)d, iFetchPlan, keepTypes, iCurrentLevel + 1, iMaxFetch, parsedRecords);
                json.endObject(indentLevel + 1, true);
                continue;
            }
            json.writeValue(indentLevel + 1, false, OJSONWriter.encode(d));
        }
        json.endCollection(indentLevel + 1, false);
    }

    private void fetchDocument(Map<String, Integer> iFetchPlan, Object fieldValue, String fieldName, int iCurrentLevel, int iMaxFetch, OJSONWriter json, int indentLevel, boolean includeType, boolean includeId, boolean includeVer, boolean includeClazz, boolean attribSameRow, boolean keepTypes, Set<ORID> parsedRecords) throws IOException {
        if (!parsedRecords.contains(((ODocument)fieldValue).getIdentity())) {
            parsedRecords.add(((ODocument)fieldValue).getIdentity());
            ODocument linked = (ODocument)fieldValue;
            json.beginObject(indentLevel + 1, true, fieldName);
            this.writeSignature(json, indentLevel, includeType, includeId, includeVer, includeClazz, attribSameRow, linked);
            this.processRecord(json, indentLevel, includeType, includeId, includeVer, includeClazz, attribSameRow, linked, iFetchPlan, keepTypes, iCurrentLevel + 1, iMaxFetch, parsedRecords);
            json.endObject(indentLevel + 1, true);
        } else {
            json.writeAttribute(indentLevel + 1, true, fieldName, OJSONWriter.encode(fieldValue));
        }
    }

    private Integer getDepthLevel(ORecordSchemaAware<?> record, Map<String, Integer> iFetchPlan, String iFieldName) {
        Integer depthLevel;
        if (iFetchPlan != null) {
            depthLevel = iFetchPlan.get(iFieldName);
            if (depthLevel == null) {
                OClass cls = record.getSchemaClass();
                while (cls != null && depthLevel == null) {
                    depthLevel = iFetchPlan.get(cls.getName() + "." + iFieldName);
                    if (depthLevel != null) continue;
                    cls = cls.getSuperClass();
                }
            }
        } else {
            depthLevel = -1;
        }
        return depthLevel;
    }

    private boolean hasTypeField(String[] fields) {
        for (int i = 0; i < fields.length; i += 2) {
            if (!fields[i].equals("\"@type\"") && !fields[i].equals("'@type'")) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return NAME;
    }
}

