/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record.string;

import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.OUserObject2RecordHandler;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.OBase64Utils;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.OSerializationThreadLocal;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerSchemaAware2CSV;
import com.orientechnologies.orient.core.serialization.serializer.string.OStringSerializerAnyStreamable;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ORecordSerializerStringAbstract
implements ORecordSerializer {
    private static final char DECIMAL_SEPARATOR = '.';
    private static final String MAX_INTEGER_AS_STRING = String.valueOf(Integer.MAX_VALUE);
    private static final int MAX_INTEGER_DIGITS = MAX_INTEGER_AS_STRING.length();

    protected abstract StringBuilder toString(ORecordInternal<?> var1, StringBuilder var2, String var3, OUserObject2RecordHandler var4, Set<Integer> var5, boolean var6);

    protected abstract ORecordInternal<?> fromString(ODatabaseRecord var1, String var2, ORecordInternal<?> var3);

    public StringBuilder toString(ORecordInternal<?> iRecord, String iFormat) {
        return this.toString(iRecord, new StringBuilder(), iFormat, iRecord.getDatabase(), (Set)OSerializationThreadLocal.INSTANCE.get(), false);
    }

    public StringBuilder toString(ORecordInternal<?> iRecord, StringBuilder iOutput, String iFormat) {
        return this.toString(iRecord, iOutput, iFormat, iRecord.getDatabase(), (Set)OSerializationThreadLocal.INSTANCE.get(), false);
    }

    public ORecordInternal<?> fromString(ODatabaseRecord iDatabase, String iSource) {
        return this.fromString(iDatabase, iSource, (ORecordInternal)iDatabase.newInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORecordInternal<?> fromStream(ODatabaseRecord iDatabase, byte[] iSource, ORecordInternal<?> iRecord) {
        ORecordInternal<?> oRecordInternal;
        long timer = OProfiler.getInstance().startChrono();
        try {
            oRecordInternal = this.fromString(iDatabase, OBinaryProtocol.bytes2string(iSource), iRecord);
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            OProfiler.getInstance().stopChrono("ORecordSerializerStringAbstract.fromStream", timer);
            throw throwable;
        }
        OProfiler.getInstance().stopChrono("ORecordSerializerStringAbstract.fromStream", timer);
        return oRecordInternal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] toStream(ODatabaseRecord iDatabase, ORecordInternal<?> iRecord, boolean iOnlyDelta) {
        byte[] byArray;
        long timer = OProfiler.getInstance().startChrono();
        try {
            byArray = OBinaryProtocol.string2bytes(this.toString(iRecord, new StringBuilder(), null, iDatabase, (Set)OSerializationThreadLocal.INSTANCE.get(), iOnlyDelta).toString());
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            OProfiler.getInstance().stopChrono("ORecordSerializerStringAbstract.toStream", timer);
            throw throwable;
        }
        OProfiler.getInstance().stopChrono("ORecordSerializerStringAbstract.toStream", timer);
        return byArray;
    }

    public static Object fieldTypeFromStream(ODocument iDocument, OType iType, Object iValue) {
        if (iValue == null) {
            return null;
        }
        if (iType == null) {
            iType = OType.EMBEDDED;
        }
        switch (iType) {
            case STRING: {
                if (iValue instanceof String) {
                    String s = (String)iValue;
                    return OStringSerializerHelper.decode(s.substring(1, s.length() - 1));
                }
                return iValue.toString();
            }
            case INTEGER: {
                if (iValue instanceof Integer) {
                    return iValue;
                }
                return new Integer(iValue.toString());
            }
            case BOOLEAN: {
                if (iValue instanceof Boolean) {
                    return iValue;
                }
                return new Boolean(iValue.toString());
            }
            case FLOAT: {
                if (iValue instanceof Float) {
                    return iValue;
                }
                return ORecordSerializerStringAbstract.convertValue((String)iValue, iType);
            }
            case LONG: {
                if (iValue instanceof Long) {
                    return iValue;
                }
                return ORecordSerializerStringAbstract.convertValue((String)iValue, iType);
            }
            case DOUBLE: {
                if (iValue instanceof Double) {
                    return iValue;
                }
                return ORecordSerializerStringAbstract.convertValue((String)iValue, iType);
            }
            case SHORT: {
                if (iValue instanceof Short) {
                    return iValue;
                }
                return ORecordSerializerStringAbstract.convertValue((String)iValue, iType);
            }
            case BYTE: {
                if (iValue instanceof Byte) {
                    return iValue;
                }
                return ORecordSerializerStringAbstract.convertValue((String)iValue, iType);
            }
            case BINARY: {
                if (iValue instanceof byte[]) {
                    return iValue;
                }
                if (iValue instanceof String) {
                    String s = (String)iValue;
                    if (s.length() > 2) {
                        return OBase64Utils.decode(s.substring(1, s.length() - 1));
                    }
                    return null;
                }
            }
            case DATE: 
            case DATETIME: {
                if (iValue instanceof Date) {
                    return iValue;
                }
                return ORecordSerializerStringAbstract.convertValue((String)iValue, iType);
            }
            case LINK: {
                if (iValue instanceof ORID) {
                    return iValue.toString();
                }
                if (iValue instanceof String) {
                    return new ORecordId((String)iValue);
                }
                return ((ORecord)iValue).getIdentity().toString();
            }
            case EMBEDDED: {
                return OStringSerializerAnyStreamable.INSTANCE.fromStream(iDocument.getDatabase(), (String)iValue);
            }
            case EMBEDDEDSET: 
            case EMBEDDEDLIST: {
                String value = (String)iValue;
                return ORecordSerializerSchemaAware2CSV.INSTANCE.embeddedCollectionFromStream(iDocument.getDatabase(), iDocument, iType, null, null, value);
            }
            case EMBEDDEDMAP: {
                String value = (String)iValue;
                return ORecordSerializerSchemaAware2CSV.INSTANCE.embeddedMapFromStream(iDocument, null, value);
            }
        }
        throw new IllegalArgumentException("Type " + (Object)((Object)iType) + " not supported to convert value: " + iValue);
    }

    public static Object convertValue(String iValue, OType iExpectedType) {
        Object v = ORecordSerializerStringAbstract.getTypeValue(iValue);
        return OType.convert(v, iExpectedType.getDefaultJavaType());
    }

    public static void fieldTypeToString(StringBuilder iBuffer, ODatabaseComplex<?> iDatabase, OType iType, Object iValue) {
        if (iValue == null) {
            return;
        }
        long timer = OProfiler.getInstance().startChrono();
        if (iType == null) {
            iType = iValue instanceof ORID ? OType.LINK : OType.EMBEDDED;
        }
        switch (iType) {
            case STRING: {
                ORecordSerializerStringAbstract.simpleValueToStream(iBuffer, iType, iValue);
                OProfiler.getInstance().stopChrono("serializer.rec.str.string2string", timer);
                break;
            }
            case BOOLEAN: {
                ORecordSerializerStringAbstract.simpleValueToStream(iBuffer, iType, iValue);
                OProfiler.getInstance().stopChrono("serializer.rec.str.bool2string", timer);
                break;
            }
            case INTEGER: {
                ORecordSerializerStringAbstract.simpleValueToStream(iBuffer, iType, iValue);
                OProfiler.getInstance().stopChrono("serializer.rec.str.int2string", timer);
                break;
            }
            case FLOAT: {
                ORecordSerializerStringAbstract.simpleValueToStream(iBuffer, iType, iValue);
                OProfiler.getInstance().stopChrono("serializer.rec.str.float2string", timer);
                break;
            }
            case LONG: {
                ORecordSerializerStringAbstract.simpleValueToStream(iBuffer, iType, iValue);
                OProfiler.getInstance().stopChrono("serializer.rec.str.long2string", timer);
                break;
            }
            case DOUBLE: {
                ORecordSerializerStringAbstract.simpleValueToStream(iBuffer, iType, iValue);
                OProfiler.getInstance().stopChrono("serializer.rec.str.double2string", timer);
                break;
            }
            case SHORT: {
                ORecordSerializerStringAbstract.simpleValueToStream(iBuffer, iType, iValue);
                OProfiler.getInstance().stopChrono("serializer.rec.str.short2string", timer);
                break;
            }
            case BYTE: {
                ORecordSerializerStringAbstract.simpleValueToStream(iBuffer, iType, iValue);
                OProfiler.getInstance().stopChrono("serializer.rec.str.byte2string", timer);
                break;
            }
            case BINARY: {
                ORecordSerializerStringAbstract.simpleValueToStream(iBuffer, iType, iValue);
                OProfiler.getInstance().stopChrono("serializer.rec.str.binary2string", timer);
                break;
            }
            case DATE: {
                ORecordSerializerStringAbstract.simpleValueToStream(iBuffer, iType, iValue);
                OProfiler.getInstance().stopChrono("serializer.rec.str.date2string", timer);
                break;
            }
            case DATETIME: {
                ORecordSerializerStringAbstract.simpleValueToStream(iBuffer, iType, iValue);
                OProfiler.getInstance().stopChrono("serializer.rec.str.datetime2string", timer);
                break;
            }
            case LINK: {
                if (iValue instanceof ORecordId) {
                    ((ORecordId)iValue).toString(iBuffer);
                } else {
                    ((ORecord)iValue).getIdentity().toString(iBuffer);
                }
                OProfiler.getInstance().stopChrono("serializer.rec.str.link2string", timer);
                break;
            }
            case EMBEDDEDSET: {
                ORecordSerializerSchemaAware2CSV.INSTANCE.embeddedCollectionToStream(iDatabase, null, iBuffer, null, null, iValue, null, true);
                OProfiler.getInstance().stopChrono("serializer.rec.str.embedSet2string", timer);
                break;
            }
            case EMBEDDEDLIST: {
                ORecordSerializerSchemaAware2CSV.INSTANCE.embeddedCollectionToStream(iDatabase, null, iBuffer, null, null, iValue, null, true);
                OProfiler.getInstance().stopChrono("serializer.rec.str.embedList2string", timer);
                break;
            }
            case EMBEDDEDMAP: {
                ORecordSerializerSchemaAware2CSV.INSTANCE.embeddedMapToStream(iDatabase, null, iBuffer, null, null, iValue, null, true);
                OProfiler.getInstance().stopChrono("serializer.rec.str.embedMap2string", timer);
                break;
            }
            case EMBEDDED: {
                OStringSerializerAnyStreamable.INSTANCE.toStream(iDatabase, iBuffer, iValue);
                OProfiler.getInstance().stopChrono("serializer.rec.str.embed2string", timer);
                break;
            }
            default: {
                throw new IllegalArgumentException("Type " + (Object)((Object)iType) + " not supported to convert value: " + iValue);
            }
        }
    }

    public static OType getType(String iValue) {
        int numberLength;
        if (iValue.length() == 0) {
            return null;
        }
        char firstChar = iValue.charAt(0);
        if (firstChar == '#') {
            return OType.LINK;
        }
        if (firstChar == '\'' || firstChar == '\"') {
            return OType.STRING;
        }
        if (firstChar == '(') {
            return OType.EMBEDDED;
        }
        if (firstChar == '#') {
            return OType.LINK;
        }
        if (firstChar == '[') {
            return OType.EMBEDDEDLIST;
        }
        if (firstChar == '{') {
            return OType.EMBEDDEDMAP;
        }
        boolean integer = true;
        for (int index = 0; index < iValue.length(); ++index) {
            char c = iValue.charAt(index);
            if (c >= '0' && c <= '9' || index == 0 && (c == '+' || c == '-')) continue;
            if (c == '.') {
                integer = false;
                continue;
            }
            if (index > 0) {
                if (c == 'f') {
                    return OType.FLOAT;
                }
                if (c == 'l') {
                    return OType.LONG;
                }
                if (c == 'd') {
                    return OType.DOUBLE;
                }
                if (c == 'b') {
                    return OType.BYTE;
                }
                if (c == 'a') {
                    return OType.DATE;
                }
                if (c == 't') {
                    return OType.DATETIME;
                }
                if (c == 's') {
                    return OType.SHORT;
                }
            }
            return OType.STRING;
        }
        if (integer && ((numberLength = iValue.length()) > MAX_INTEGER_DIGITS || numberLength == MAX_INTEGER_DIGITS && iValue.compareTo(MAX_INTEGER_AS_STRING) > 0)) {
            return OType.LONG;
        }
        return integer ? OType.INTEGER : OType.FLOAT;
    }

    public static Object getTypeValue(String iValue) {
        if (iValue == null) {
            return null;
        }
        if (iValue.length() > 1 && iValue.charAt(0) == '\"' && iValue.charAt(iValue.length() - 1) == '\"') {
            return OStringSerializerHelper.decode(iValue.substring(1, iValue.length() - 1));
        }
        if (iValue.charAt(0) == '#') {
            return new ORecordId(iValue);
        }
        boolean integer = true;
        for (int index = 0; index < iValue.length(); ++index) {
            char c = iValue.charAt(index);
            if (c >= '0' && c <= '9' || index == 0 && (c == '+' || c == '-')) continue;
            if (c == '.') {
                integer = false;
                continue;
            }
            if (index > 0) {
                String v = iValue.substring(0, index);
                if (c == 'f') {
                    return new Float(v);
                }
                if (c == 'l') {
                    return new Long(v);
                }
                if (c == 'd') {
                    return new Double(v);
                }
                if (c == 'b') {
                    return new Byte(v);
                }
                if (c == 'a' || c == 't') {
                    return new Date(Long.parseLong(v));
                }
                if (c == 's') {
                    return new Short(v);
                }
            }
            return iValue;
        }
        if (integer) {
            return new Integer(iValue);
        }
        return new Float(iValue);
    }

    public static void simpleValueToStream(StringBuilder iBuffer, OType iType, Object iValue) {
        if (iValue == null || iType == null) {
            return;
        }
        switch (iType) {
            case STRING: {
                iBuffer.append('\"');
                iBuffer.append(OStringSerializerHelper.encode(iValue.toString()));
                iBuffer.append('\"');
                break;
            }
            case BOOLEAN: {
                iBuffer.append(String.valueOf(iValue));
                break;
            }
            case INTEGER: {
                iBuffer.append(String.valueOf(iValue));
                break;
            }
            case FLOAT: {
                iBuffer.append(String.valueOf(iValue));
                iBuffer.append('f');
                break;
            }
            case LONG: {
                iBuffer.append(String.valueOf(iValue));
                iBuffer.append('l');
                break;
            }
            case DOUBLE: {
                iBuffer.append(String.valueOf(iValue));
                iBuffer.append('d');
                break;
            }
            case SHORT: {
                iBuffer.append(String.valueOf(iValue));
                iBuffer.append('s');
                break;
            }
            case BYTE: {
                if (iValue instanceof Character) {
                    iBuffer.append((int)((Character)iValue).charValue());
                } else if (iValue instanceof String) {
                    iBuffer.append(String.valueOf((int)((String)iValue).charAt(0)));
                } else {
                    iBuffer.append(String.valueOf(iValue));
                }
                iBuffer.append('b');
                break;
            }
            case BINARY: {
                iBuffer.append('\"');
                if (iValue instanceof Byte) {
                    iBuffer.append(new String(new byte[]{(Byte)iValue}));
                } else {
                    iBuffer.append(OBase64Utils.encodeBytes((byte[])iValue));
                }
                iBuffer.append('\"');
                break;
            }
            case DATE: {
                if (iValue instanceof Date) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime((Date)iValue);
                    calendar.set(11, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    calendar.set(14, 0);
                    iBuffer.append(calendar.getTimeInMillis());
                } else {
                    iBuffer.append(iValue);
                }
                iBuffer.append('a');
                break;
            }
            case DATETIME: {
                if (iValue instanceof Date) {
                    iBuffer.append(((Date)iValue).getTime());
                } else {
                    iBuffer.append(iValue);
                }
                iBuffer.append('t');
            }
        }
    }
}

