/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLPermissionAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import java.util.Arrays;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLAlterClass
extends OCommandExecutorSQLPermissionAbstract {
    public static final String KEYWORD_ALTER = "ALTER";
    public static final String KEYWORD_CLASS = "CLASS";
    private String className;
    private OClass.ATTRIBUTES attribute;
    private String value;

    public OCommandExecutorSQLAlterClass parse(OCommandRequestText iRequest) {
        iRequest.getDatabase().checkSecurity("database.command", 4);
        this.init(iRequest.getDatabase(), iRequest.getText());
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_ALTER)) {
            throw new OCommandSQLParsingException("Keyword ALTER not found", this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true)) == -1 || !word.toString().equals(KEYWORD_CLASS)) {
            throw new OCommandSQLParsingException("Keyword CLASS not found", this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, false)) == -1) {
            throw new OCommandSQLParsingException("Expected <class>", this.text, oldPos);
        }
        this.className = word.toString();
        oldPos = pos;
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true)) == -1) {
            throw new OCommandSQLParsingException("Missed the class's attribute to change", this.text, oldPos);
        }
        String attributeAsString = word.toString();
        try {
            this.attribute = OClass.ATTRIBUTES.valueOf(attributeAsString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new OCommandSQLParsingException("Unknown class's attribute '" + attributeAsString + "'. Supported attributes are: " + Arrays.toString((Object[])OClass.ATTRIBUTES.values()), this.text, oldPos);
        }
        this.value = this.text.substring(pos + 1).trim();
        if (this.value.length() == 0) {
            throw new OCommandSQLParsingException("Missed the property's value to change for attribute '" + (Object)((Object)this.attribute) + "'", this.text, oldPos);
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.attribute == null) {
            throw new OCommandExecutionException("Can't execute the command because it hasn't been parsed yet");
        }
        OClassImpl cls = (OClassImpl)this.database.getMetadata().getSchema().getClass(this.className);
        if (cls == null) {
            throw new OCommandExecutionException("Source class '" + this.className + "' not found");
        }
        cls.setInternalAndSave(this.attribute, this.value);
        this.renameCluster();
        return null;
    }

    private void renameCluster() {
        if (this.attribute.equals((Object)OClass.ATTRIBUTES.NAME) && this.checkClusterRenameOk(this.database.getStorage().getClusterIdByName(this.value))) {
            this.database.command(new OCommandSQL("alter cluster " + this.className + " name " + this.value)).execute(new Object[0]);
        }
    }

    private boolean checkClusterRenameOk(int clusterId) {
        for (OClass clazz : this.database.getMetadata().getSchema().getClasses()) {
            if (clazz.getName().equals(this.value) || clazz.getDefaultClusterId() != clusterId && !Arrays.asList(new int[][]{clazz.getClusterIds()}).contains(clusterId)) continue;
            return false;
        }
        return true;
    }
}

