/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLPermissionAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import java.util.Arrays;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLAlterDatabase
extends OCommandExecutorSQLPermissionAbstract {
    public static final String KEYWORD_ALTER = "ALTER";
    public static final String KEYWORD_DATABASE = "DATABASE";
    private ODatabase.ATTRIBUTES attribute;
    private String value;

    public OCommandExecutorSQLAlterDatabase parse(OCommandRequestText iRequest) {
        iRequest.getDatabase().checkSecurity("database.command", 4);
        this.init(iRequest.getDatabase(), iRequest.getText());
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_ALTER)) {
            throw new OCommandSQLParsingException("Keyword ALTER not found", this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true)) == -1 || !word.toString().equals(KEYWORD_DATABASE)) {
            throw new OCommandSQLParsingException("Keyword DATABASE not found", this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true)) == -1) {
            throw new OCommandSQLParsingException("Missed the database's attribute to change", this.text, oldPos);
        }
        String attributeAsString = word.toString();
        try {
            this.attribute = ODatabase.ATTRIBUTES.valueOf(attributeAsString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new OCommandSQLParsingException("Unknown database's attribute '" + attributeAsString + "'. Supported attributes are: " + Arrays.toString((Object[])OClass.ATTRIBUTES.values()), this.text, oldPos);
        }
        this.value = this.text.substring(pos + 1).trim();
        if (this.value.length() == 0) {
            throw new OCommandSQLParsingException("Missed the database's value to change for attribute '" + (Object)((Object)this.attribute) + "'", this.text, oldPos);
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.attribute == null) {
            throw new OCommandExecutionException("Can't execute the command because it hasn't been parsed yet");
        }
        this.database.checkSecurity("database", 4);
        this.database.setInternal(this.attribute, this.value);
        return null;
    }
}

