/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OPropertyImpl;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLPermissionAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLCreateIndex
extends OCommandExecutorSQLPermissionAbstract {
    public static final String KEYWORD_CREATE = "CREATE";
    public static final String KEYWORD_INDEX = "INDEX";
    private String name;
    private String indexType;
    private OType keyType;

    public OCommandExecutorSQLCreateIndex parse(OCommandRequestText iRequest) {
        iRequest.getDatabase().checkSecurity("database.command", 1);
        this.init(iRequest.getDatabase(), iRequest.getText());
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_CREATE)) {
            throw new OCommandSQLParsingException("Keyword CREATE not found", this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true)) == -1 || !word.toString().equals(KEYWORD_INDEX)) {
            throw new OCommandSQLParsingException("Keyword INDEX not found", this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, false)) == -1) {
            throw new OCommandSQLParsingException("Expected index name", this.text, oldPos);
        }
        this.name = word.toString();
        oldPos = pos;
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true)) == -1) {
            throw new OCommandSQLParsingException("Index type requested", this.text, oldPos + 1);
        }
        this.indexType = word.toString();
        if (this.indexType == null) {
            throw new OCommandSQLParsingException("Index type is null", this.text, pos);
        }
        oldPos = pos;
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true)) == -1 || word.toString().equalsIgnoreCase("NULL")) {
            if (this.name.indexOf(46) > 0) {
                String[] parts = this.name.split("\\.");
                OClass cls = this.database.getMetadata().getSchema().getClass(parts[0]);
                OProperty prop = cls.getProperty(parts[1]);
                this.keyType = prop.getType();
            }
        } else {
            this.keyType = OType.valueOf(word.toString());
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        OIndex<?> idx;
        if (this.name == null) {
            throw new OCommandExecutionException("Can't execute the command because it hasn't been parsed yet");
        }
        if (this.name.indexOf(46) > -1) {
            String[] parts = this.name.split("\\.");
            String className = parts[0];
            if (className == null) {
                throw new OCommandExecutionException("Class " + className + " not found");
            }
            String fieldName = parts[1];
            OClass cls = this.database.getMetadata().getSchema().getClass(className);
            if (cls == null) {
                throw new OCommandExecutionException("Class '" + className + "' not found");
            }
            OPropertyImpl prop = (OPropertyImpl)cls.getProperty(fieldName);
            if (prop == null) {
                throw new IllegalArgumentException("Property '" + fieldName + "' was not found in class '" + cls + "'");
            }
            idx = prop.createIndexInternal(this.indexType.toUpperCase(), this.progressListener).getUnderlying();
        } else {
            idx = this.database.getMetadata().getIndexManager().createIndex(this.name, this.indexType.toUpperCase(), this.keyType, null, null, null, false);
        }
        if (idx != null) {
            return idx.getSize();
        }
        return null;
    }
}

