/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLPermissionAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLCreateLink
extends OCommandExecutorSQLPermissionAbstract {
    public static final String KEYWORD_CREATE = "CREATE";
    public static final String KEYWORD_LINK = "LINK";
    private static final String KEYWORD_FROM = "FROM";
    private static final String KEYWORD_TO = "TO";
    private String destClassName;
    private String destField;
    private String sourceClassName;
    private String sourceField;
    private String linkName;
    private String linkType;

    public OCommandExecutorSQLCreateLink parse(OCommandRequestText iRequest) {
        iRequest.getDatabase().checkSecurity("database.command", 1);
        this.init(iRequest.getDatabase(), iRequest.getText());
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_CREATE)) {
            throw new OCommandSQLParsingException("Keyword CREATE not found", this.text, oldPos);
        }
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, true)) == -1 || !word.toString().equals(KEYWORD_LINK)) {
            throw new OCommandSQLParsingException("Keyword LINK not found", this.text, oldPos);
        }
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, false)) == -1) {
            throw new OCommandSQLParsingException("Keyword FROM not found", this.text, oldPos);
        }
        if (!word.toString().equalsIgnoreCase(KEYWORD_FROM)) {
            this.linkName = word.toString();
            if (OStringSerializerHelper.contains(this.linkName, ' ')) {
                throw new OCommandSQLParsingException("Link name '" + this.linkName + "' contains not valid characters", this.text, oldPos);
            }
            if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, true)) == -1 || !word.toString().equals(KEYWORD_FROM)) {
                throw new OCommandSQLParsingException("Keyword FROM not found", this.text, oldPos);
            }
        }
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, false)) == -1) {
            throw new OCommandSQLParsingException("Expected <class>.<property>", this.text, pos);
        }
        String[] parts = word.toString().split("\\.");
        if (parts.length != 2) {
            throw new OCommandSQLParsingException("Expected <class>.<property>", this.text, pos);
        }
        this.sourceClassName = parts[0];
        if (this.sourceClassName == null) {
            throw new OCommandSQLParsingException("Class not found", this.text, pos);
        }
        this.sourceField = parts[1];
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, true)) == -1 || !word.toString().equals(KEYWORD_TO)) {
            throw new OCommandSQLParsingException("Keyword TO not found", this.text, oldPos);
        }
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, false)) == -1) {
            throw new OCommandSQLParsingException("Expected <class>.<property>", this.text, pos);
        }
        parts = word.toString().split("\\.");
        if (parts.length != 2) {
            throw new OCommandSQLParsingException("Expected <class>.<property>", this.text, pos);
        }
        this.destClassName = parts[0];
        if (this.destClassName == null) {
            throw new OCommandSQLParsingException("Class not found", this.text, pos);
        }
        this.destField = parts[1];
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, true)) == -1) {
            return this;
        }
        this.linkType = word.toString();
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.destField == null) {
            throw new OCommandExecutionException("Can't execute the command because it hasn't been parsed yet");
        }
        if (!(this.database.getDatabaseOwner() instanceof ODatabaseDocumentTx)) {
            throw new OCommandSQLParsingException("This command supports only the database type ODatabaseDocumentTx and type '" + this.database.getClass() + "' was found");
        }
        ODatabaseDocumentTx db = (ODatabaseDocumentTx)this.database.getDatabaseOwner();
        OClass sourceClass = this.database.getMetadata().getSchema().getClass(this.sourceClassName);
        if (sourceClass == null) {
            throw new OCommandExecutionException("Source class '" + this.sourceClassName + "' not found");
        }
        OClass destClass = this.database.getMetadata().getSchema().getClass(this.destClassName);
        if (destClass == null) {
            throw new OCommandExecutionException("Destination class '" + this.destClassName + "' not found");
        }
        String cmd = "select from " + this.destClassName + " where " + this.destField + " = ";
        long total = 0L;
        if (this.linkName == null) {
            this.linkName = this.sourceField;
        }
        boolean inverse = this.linkType != null && this.linkType.equalsIgnoreCase("inverse");
        boolean multipleRelationship = false;
        long totRecords = db.countClass(sourceClass.getName());
        long currRecord = 0L;
        if (this.progressListener != null) {
            this.progressListener.onBegin((Object)this, totRecords);
        }
        try {
            for (ODocument doc : db.browseClass(sourceClass.getName())) {
                Object value = doc.field(this.sourceField);
                if (!(value == null || value instanceof ODocument || value instanceof ORID || value instanceof Collection)) {
                    List result;
                    ODocument target = null;
                    if (value instanceof String) {
                        value = ((String)value).length() == 0 ? null : "'" + value + "'";
                    }
                    if ((result = (List)this.database.command(new OSQLSynchQuery(cmd + value)).execute(new Object[0])) == null || result.size() == 0) {
                        value = null;
                    } else {
                        if (result.size() > 1) {
                            throw new OCommandExecutionException("Can't create link because multiple records was found in class '" + destClass.getName() + "' with value " + value + " in field '" + this.destField + "'");
                        }
                        target = (ODocument)result.get(0);
                        value = target;
                    }
                    if (target != null && inverse) {
                        Object oldValue = target.field(this.linkName);
                        if (oldValue != null) {
                            ArrayList<ODocument> coll;
                            if (!multipleRelationship) {
                                multipleRelationship = true;
                            }
                            if (oldValue instanceof Collection) {
                                coll = (ArrayList<ODocument>)oldValue;
                                target.setDirty();
                            } else {
                                coll = new ArrayList<ODocument>(2);
                                target.field(this.linkName, coll);
                                coll.add((ODocument)oldValue);
                            }
                            coll.add(doc);
                        } else {
                            target.field(this.linkName, doc);
                        }
                        target.save();
                    } else {
                        doc.field(this.linkName, value);
                        doc.save();
                    }
                    ++total;
                }
                if (this.progressListener == null) continue;
                this.progressListener.onProgress((Object)this, currRecord, (float)currRecord * 100.0f / (float)totRecords);
            }
            if (total > 0L) {
                OProperty prop;
                if (inverse) {
                    prop = destClass.getProperty(this.linkName);
                    if (prop != null) {
                        destClass.dropProperty(this.linkName);
                    }
                    destClass.createProperty(this.linkName, multipleRelationship ? OType.LINKLIST : OType.LINK, sourceClass);
                } else {
                    prop = sourceClass.getProperty(this.linkName);
                    if (prop != null) {
                        sourceClass.dropProperty(this.linkName);
                    }
                    sourceClass.createProperty(this.linkName, OType.LINK, destClass);
                }
            }
            if (this.progressListener != null) {
                this.progressListener.onCompletition((Object)this, true);
            }
        }
        catch (Exception e) {
            if (this.progressListener != null) {
                this.progressListener.onCompletition((Object)this, false);
            }
            throw new OCommandExecutionException("Error on creation of links", e);
        }
        return total;
    }
}

