/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OPropertyImpl;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLPermissionAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLDropIndex
extends OCommandExecutorSQLPermissionAbstract {
    public static final String KEYWORD_DROP = "DROP";
    public static final String KEYWORD_INDEX = "INDEX";
    private String name;

    public OCommandExecutorSQLDropIndex parse(OCommandRequestText iRequest) {
        iRequest.getDatabase().checkSecurity("database.command", 1);
        this.init(iRequest.getDatabase(), iRequest.getText());
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_DROP)) {
            throw new OCommandSQLParsingException("Keyword DROP not found", this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, true)) == -1 || !word.toString().equals(KEYWORD_INDEX)) {
            throw new OCommandSQLParsingException("Keyword INDEX not found", this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, false)) == -1) {
            throw new OCommandSQLParsingException("Expected index name", this.text, oldPos);
        }
        this.name = word.toString();
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.name == null) {
            throw new OCommandExecutionException("Can't execute the command because it hasn't been parsed yet");
        }
        if (this.name.indexOf(46) > -1) {
            String[] parts = this.name.split("\\.");
            String className = parts[0];
            if (className == null) {
                throw new OCommandExecutionException("Class " + className + " not found");
            }
            String fieldName = parts[1];
            OClass cls = this.database.getMetadata().getSchema().getClass(className);
            if (cls == null) {
                throw new OCommandExecutionException("Class '" + className + "' not found");
            }
            OPropertyImpl prop = (OPropertyImpl)cls.getProperty(fieldName);
            if (prop == null) {
                throw new IllegalArgumentException("Property '" + fieldName + "' was not found in class '" + cls + "'");
            }
            prop.dropIndexInternal();
        } else {
            this.database.getMetadata().getIndexManager().dropIndex(this.name);
        }
        return null;
    }
}

