/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLPermissionAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLDropProperty
extends OCommandExecutorSQLPermissionAbstract {
    public static final String KEYWORD_DROP = "DROP";
    public static final String KEYWORD_PROPERTY = "PROPERTY";
    private String className;
    private String fieldName;

    public OCommandExecutorSQLDropProperty parse(OCommandRequestText iRequest) {
        iRequest.getDatabase().checkSecurity("database.command", 8);
        this.init(iRequest.getDatabase(), iRequest.getText());
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_DROP)) {
            throw new OCommandSQLParsingException("Keyword DROP not found", this.text, oldPos);
        }
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, true)) == -1 || !word.toString().equals(KEYWORD_PROPERTY)) {
            throw new OCommandSQLParsingException("Keyword PROPERTY not found", this.text, oldPos);
        }
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, false)) == -1) {
            throw new OCommandSQLParsingException("Expected <class>.<property>", this.text, pos);
        }
        String[] parts = word.toString().split("\\.");
        if (parts.length != 2) {
            throw new OCommandSQLParsingException("Expected <class>.<property>", this.text, pos);
        }
        this.className = parts[0];
        if (this.className == null) {
            throw new OCommandSQLParsingException("Class not found", this.text, pos);
        }
        this.fieldName = parts[1];
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.fieldName == null) {
            throw new OCommandExecutionException("Can't execute the command because it hasn't been parsed yet");
        }
        OClassImpl sourceClass = (OClassImpl)this.database.getMetadata().getSchema().getClass(this.className);
        if (sourceClass == null) {
            throw new OCommandExecutionException("Source class '" + this.className + "' not found");
        }
        sourceClass.dropPropertyInternal(this.fieldName);
        sourceClass.saveInternal();
        return null;
    }
}

