/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.parser.OStringParser;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazySet;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexFullText;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexNotUnique;
import com.orientechnologies.orient.core.index.OIndexUnique;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordSchemaAware;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentHelper;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilter;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItem;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionRuntime;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorBetween;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorContainsText;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEquals;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorIn;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMajor;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMajorEquals;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMinor;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMinorEquals;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorNotEquals;
import com.orientechnologies.orient.core.sql.query.OSQLAsynchQuery;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.core.storage.ORecordBrowsingListener;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLSelect
extends OCommandExecutorSQLAbstract
implements ORecordBrowsingListener {
    private static final String KEYWORD_AS = " AS ";
    public static final String KEYWORD_SELECT = "SELECT";
    public static final String KEYWORD_ASC = "ASC";
    public static final String KEYWORD_DESC = "DESC";
    public static final String KEYWORD_ORDER = "ORDER";
    public static final String KEYWORD_BY = "BY";
    public static final String KEYWORD_ORDER_BY = "ORDER BY";
    public static final String KEYWORD_LIMIT = "LIMIT";
    public static final String KEYWORD_RANGE = "RANGE";
    public static final String KEYWORD_RANGE_FIRST = "FIRST";
    public static final String KEYWORD_RANGE_LAST = "LAST";
    private static final String KEYWORD_FROM_2FIND = " FROM ";
    private static ORecordId FIRST = new ORecordId();
    private static ORecordId LAST = new ORecordId();
    private OSQLAsynchQuery<ORecordSchemaAware<?>> request;
    private OSQLFilter compiledFilter;
    private Map<String, Object> projections = null;
    private List<OPair<String, String>> orderedFields;
    private List<OIdentifiable> tempResult;
    private int resultCount;
    private ORecordId rangeFrom = FIRST;
    private ORecordId rangeTo = LAST;
    private Object flattenTarget;
    private boolean anyFunctionAggregates = false;

    public OCommandExecutorSQLSelect parse(OCommandRequestText iRequest) {
        int pos;
        iRequest.getDatabase().checkSecurity("database.command", 2);
        this.init(iRequest.getDatabase(), iRequest.getText());
        if (iRequest instanceof OSQLSynchQuery) {
            this.request = (OSQLSynchQuery)iRequest;
            if (this.request.getBeginRange().isValid()) {
                this.rangeFrom = this.request.getBeginRange();
            }
            if (this.request.getEndRange().isValid()) {
                this.rangeTo = this.request.getEndRange();
            }
        } else if (iRequest instanceof OSQLAsynchQuery) {
            this.request = (OSQLAsynchQuery)iRequest;
        } else {
            this.request = new OSQLSynchQuery(iRequest.getText());
            this.request.setDatabase(iRequest.getDatabase());
            if (iRequest.getResultListener() != null) {
                this.request.setResultListener(iRequest.getResultListener());
            }
        }
        if ((pos = this.parseProjections()) == -1) {
            return this;
        }
        int endPosition = this.textUpperCase.indexOf(" ORDER BY", this.currentPos);
        if (endPosition == -1 && (endPosition = this.textUpperCase.indexOf(" RANGE", this.currentPos)) == -1 && (endPosition = this.textUpperCase.indexOf(" LIMIT", this.currentPos)) == -1) {
            endPosition = this.text.length();
        }
        this.compiledFilter = OSQLEngine.getInstance().parseFromWhereCondition(iRequest.getDatabase(), this.text.substring(pos, endPosition));
        this.optimize();
        int n = this.currentPos = this.compiledFilter.currentPos < 0 ? endPosition : this.compiledFilter.currentPos + pos;
        if (this.currentPos > -1 && this.currentPos < this.text.length()) {
            this.currentPos = OStringParser.jump((CharSequence)this.text, (int)this.currentPos, (String)" \r\n");
            StringBuilder word = new StringBuilder();
            while (this.currentPos > -1) {
                this.currentPos = OSQLHelper.nextWord(this.text, this.textUpperCase, this.currentPos, word, true);
                if (this.currentPos <= -1) continue;
                String w = word.toString();
                if (w.equals(KEYWORD_ORDER)) {
                    this.parseOrderBy(word);
                    continue;
                }
                if (w.equals(KEYWORD_RANGE)) {
                    this.parseRange(word);
                    continue;
                }
                if (!w.equals(KEYWORD_LIMIT)) continue;
                this.parseLimit(word);
            }
        }
        if (this.limit == 0 || this.limit < -1) {
            throw new IllegalArgumentException("Limit must be > 0 or = -1 (no limit)");
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        this.compiledFilter.bindParameters(iArgs);
        if (this.compiledFilter.getTargetClasses() != null) {
            this.searchInClasses();
        } else if (this.compiledFilter.getTargetClusters() != null) {
            this.searchInClusters();
        } else if (this.compiledFilter.getTargetIndex() != null) {
            this.searchInIndex();
        } else if (this.compiledFilter.getTargetRecords() != null) {
            this.searchInRecords();
        } else {
            throw new OQueryParsingException("No source found in query: specify class, clusters or single records");
        }
        this.applyOrderBy();
        this.applyFlatten();
        return this.processResult();
    }

    @Override
    public boolean foreach(ORecordInternal<?> iRecord) {
        if (this.filter(iRecord)) {
            return this.addResult(iRecord);
        }
        return true;
    }

    protected boolean addResult(OIdentifiable iRecord) {
        Object recordCopy;
        ++this.resultCount;
        Object object = recordCopy = iRecord instanceof ORecord ? ((ORecord)iRecord).copy() : iRecord.getIdentity().copy();
        if (this.orderedFields != null || this.flattenTarget != null) {
            if (this.tempResult == null) {
                this.tempResult = new ArrayList<OIdentifiable>();
            }
            this.tempResult.add((OIdentifiable)recordCopy);
        } else {
            this.processRecordAsResult((OIdentifiable)recordCopy);
        }
        return (this.orderedFields != null || this.limit <= -1 || this.resultCount < this.limit) && (this.request.getLimit() <= -1 || this.resultCount < this.request.getLimit());
    }

    public Map<String, Object> getProjections() {
        return this.projections;
    }

    public List<OPair<String, String>> getOrderedFields() {
        return this.orderedFields;
    }

    protected void parseOrderBy(StringBuilder word) {
        int newPos = OSQLHelper.nextWord(this.text, this.textUpperCase, this.currentPos, word, true);
        if (!KEYWORD_BY.equals(word.toString())) {
            throw new OQueryParsingException("Expected keyword BY");
        }
        this.currentPos = newPos;
        this.orderedFields = new ArrayList<OPair<String, String>>();
        while (this.currentPos != -1 && (this.orderedFields.size() == 0 || word.toString().equals(","))) {
            String fieldOrdering;
            this.currentPos = OSQLHelper.nextWord(this.text, this.textUpperCase, this.currentPos, word, false);
            if (this.currentPos == -1) {
                throw new OCommandSQLParsingException("Field name expected", this.text, this.currentPos);
            }
            String fieldName = word.toString();
            this.currentPos = OSQLHelper.nextWord(this.text, this.textUpperCase, this.currentPos, word, true);
            if (this.currentPos == -1 || word.toString().equals(KEYWORD_LIMIT)) {
                fieldOrdering = KEYWORD_ASC;
            } else {
                if (word.toString().endsWith(",")) {
                    --this.currentPos;
                    word.deleteCharAt(word.length() - 1);
                }
                if (word.toString().equals(KEYWORD_ASC)) {
                    fieldOrdering = KEYWORD_ASC;
                } else if (word.toString().equals(KEYWORD_DESC)) {
                    fieldOrdering = KEYWORD_DESC;
                } else {
                    throw new OCommandSQLParsingException("Ordering mode '" + word + "' not supported. Valid is 'ASC', 'DESC' or nothing ('ASC' by default)", this.text, this.currentPos);
                }
                this.currentPos = OSQLHelper.nextWord(this.text, this.textUpperCase, this.currentPos, word, true);
            }
            this.orderedFields.add((OPair<String, String>)new OPair((Comparable)((Object)fieldName), (Object)fieldOrdering));
            if (this.currentPos != -1) continue;
        }
        if (this.orderedFields.size() == 0) {
            throw new OCommandSQLParsingException("Order by field set was missed. Example: ORDER BY name ASC, salary DESC", this.text, this.currentPos);
        }
        if (word.toString().equals(KEYWORD_LIMIT)) {
            this.currentPos -= KEYWORD_LIMIT.length();
        }
        if (word.toString().equals(KEYWORD_RANGE)) {
            this.currentPos -= KEYWORD_RANGE.length();
        }
    }

    protected void parseRange(StringBuilder word) {
        int newPos = OSQLHelper.nextWord(this.text, this.textUpperCase, this.currentPos, word, true);
        this.rangeFrom = this.extractRangeBound(word.toString());
        if (newPos == -1) {
            return;
        }
        this.currentPos = newPos;
        newPos = OSQLHelper.nextWord(this.text, this.textUpperCase, this.currentPos, word, true);
        if (newPos == -1) {
            return;
        }
        if (!word.toString().equalsIgnoreCase(KEYWORD_LIMIT)) {
            this.rangeTo = this.extractRangeBound(word.toString());
            this.currentPos = newPos;
        }
    }

    protected ORecordId extractRangeBound(String iRangeBound) throws OCommandSQLParsingException {
        if (iRangeBound.equalsIgnoreCase(KEYWORD_RANGE_FIRST)) {
            return FIRST;
        }
        if (iRangeBound.equalsIgnoreCase(KEYWORD_RANGE_LAST)) {
            return LAST;
        }
        if (!iRangeBound.contains(":")) {
            throw new OCommandSQLParsingException("Range must contains the keyword 'first', 'last' or a valid record id in the form of <cluster-id>:<cluster-pos>. Example: RANGE 10:50, last", this.text, this.currentPos);
        }
        try {
            return new ORecordId(iRangeBound);
        }
        catch (Exception e) {
            throw new OCommandSQLParsingException("Invalid record id setted as RANGE to. Value setted is '" + iRangeBound + "' but it should be a valid record id in the form of <cluster-id>:<cluster-pos>. Example: 10:50", this.text, this.currentPos);
        }
    }

    protected int parseLimit(StringBuilder word) throws OCommandSQLParsingException {
        if (!word.toString().equals(KEYWORD_LIMIT)) {
            return -1;
        }
        this.currentPos = OSQLHelper.nextWord(this.text, this.textUpperCase, this.currentPos, word, true);
        try {
            this.limit = Integer.parseInt(word.toString());
        }
        catch (Exception e) {
            throw new OCommandSQLParsingException("Invalid LIMIT value setted to '" + word + "' but it should be a valid integer. Example: LIMIT 10", this.text, this.currentPos);
        }
        return this.limit;
    }

    private boolean searchForIndexes(List<ORecord<?>> iResultSet, OClass iSchemaClass) {
        LinkedList<OSearchInIndexTriple> searchInIndexTriples = new LinkedList<OSearchInIndexTriple>();
        this.analyzeQueryBranch(iSchemaClass, this.compiledFilter.getRootCondition(), searchInIndexTriples);
        if (searchInIndexTriples.isEmpty()) {
            return false;
        }
        for (OSearchInIndexTriple indexTriple : searchInIndexTriples) {
            boolean indexCanBeUsedInEqualityOperators;
            OIndexInternal idx = indexTriple.index.getInternal();
            OQueryOperator operator = indexTriple.indexOperator;
            Object key = indexTriple.key;
            boolean bl = indexCanBeUsedInEqualityOperators = idx instanceof OIndexUnique || idx instanceof OIndexNotUnique;
            if (indexCanBeUsedInEqualityOperators && operator instanceof OQueryOperatorBetween) {
                Object[] betweenKeys = (Object[])key;
                this.fillSearchIndexResultSet(iResultSet, indexTriple.index.getValuesBetween(OSQLHelper.getValue(betweenKeys[0]), OSQLHelper.getValue(betweenKeys[2])));
                return true;
            }
            if (indexCanBeUsedInEqualityOperators && operator instanceof OQueryOperatorEquals || idx instanceof OIndexFullText && operator instanceof OQueryOperatorContainsText) {
                this.fillSearchIndexResultSet(iResultSet, indexTriple.index.get(key));
                return true;
            }
            if (indexCanBeUsedInEqualityOperators && operator instanceof OQueryOperatorMajor) {
                this.fillSearchIndexResultSet(iResultSet, idx.getValuesMajor(key, false));
                return true;
            }
            if (indexCanBeUsedInEqualityOperators && operator instanceof OQueryOperatorMajorEquals) {
                this.fillSearchIndexResultSet(iResultSet, idx.getValuesMajor(key, true));
                return true;
            }
            if (indexCanBeUsedInEqualityOperators && operator instanceof OQueryOperatorMinor) {
                this.fillSearchIndexResultSet(iResultSet, idx.getValuesMinor(key, false));
                return true;
            }
            if (indexCanBeUsedInEqualityOperators && operator instanceof OQueryOperatorMinorEquals) {
                this.fillSearchIndexResultSet(iResultSet, idx.getValuesMinor(key, true));
                return true;
            }
            if (!indexCanBeUsedInEqualityOperators || !(operator instanceof OQueryOperatorIn)) continue;
            this.fillSearchIndexResultSet(iResultSet, idx.getValues((List)key));
            return true;
        }
        return false;
    }

    private void analyzeQueryBranch(OClass iSchemaClass, OSQLFilterCondition iCondition, List<OSearchInIndexTriple> iSearchInIndexTriples) {
        if (iCondition == null) {
            return;
        }
        OQueryOperator operator = iCondition.getOperator();
        if (operator == null) {
            if (iCondition.getLeft() != null && iCondition.getRight() == null) {
                this.analyzeQueryBranch(iSchemaClass, (OSQLFilterCondition)iCondition.getLeft(), iSearchInIndexTriples);
                return;
            }
            return;
        }
        OIndexReuseType indexReuseType = operator.getIndexReuseType(iCondition.getLeft(), iCondition.getRight());
        if (indexReuseType.equals((Object)OIndexReuseType.ANY_INDEX)) {
            this.analyzeQueryBranch(iSchemaClass, (OSQLFilterCondition)iCondition.getLeft(), iSearchInIndexTriples);
            this.analyzeQueryBranch(iSchemaClass, (OSQLFilterCondition)iCondition.getRight(), iSearchInIndexTriples);
        } else if (indexReuseType.equals((Object)OIndexReuseType.INDEX_METHOD) && !this.searchIndexedProperty(iSchemaClass, iCondition, iCondition.getLeft(), iSearchInIndexTriples)) {
            this.searchIndexedProperty(iSchemaClass, iCondition, iCondition.getRight(), iSearchInIndexTriples);
        }
    }

    private boolean searchIndexedProperty(OClass iSchemaClass, OSQLFilterCondition iCondition, Object iItem, List<OSearchInIndexTriple> iSearchInIndexTriples) {
        if (iItem == null || !(iItem instanceof OSQLFilterItemField)) {
            return false;
        }
        if (iCondition.getLeft() instanceof OSQLFilterItemField && iCondition.getRight() instanceof OSQLFilterItemField) {
            return false;
        }
        OSQLFilterItemField item = (OSQLFilterItemField)iItem;
        OProperty prop = iSchemaClass.getProperty(item.getRoot());
        while (!(prop != null && prop.isIndexed() || iSchemaClass.getSuperClass() == null)) {
            iSchemaClass = iSchemaClass.getSuperClass();
            prop = iSchemaClass.getProperty(item.getRoot());
        }
        if (prop != null && prop.isIndexed()) {
            Object origValue = iCondition.getLeft() == iItem ? iCondition.getRight() : iCondition.getLeft();
            OIndex<?> underlyingIndex = prop.getIndex().getUnderlying();
            if (iCondition.getOperator() instanceof OQueryOperatorBetween) {
                Object[] betweenKeys = (Object[])origValue;
                betweenKeys[0] = OType.convert(betweenKeys[0], underlyingIndex.getKeyType().getDefaultJavaType());
                betweenKeys[2] = OType.convert(betweenKeys[2], underlyingIndex.getKeyType().getDefaultJavaType());
                iSearchInIndexTriples.add(new OSearchInIndexTriple(iCondition.getOperator(), origValue, underlyingIndex));
                return true;
            }
            if (iCondition.getOperator() instanceof OQueryOperatorIn) {
                List origValues = (List)origValue;
                ArrayList values = new ArrayList(origValues.size());
                for (Object val : origValues) {
                    val = OSQLHelper.getValue(val);
                    val = OType.convert(val, underlyingIndex.getKeyType().getDefaultJavaType());
                    values.add(val);
                }
                iSearchInIndexTriples.add(new OSearchInIndexTriple(iCondition.getOperator(), values, underlyingIndex));
                return true;
            }
            Object value = OSQLHelper.getValue(origValue);
            if (value == null) {
                return false;
            }
            if ((value = OType.convert(value, underlyingIndex.getKeyType().getDefaultJavaType())) == null) {
                return false;
            }
            iSearchInIndexTriples.add(new OSearchInIndexTriple(iCondition.getOperator(), value, underlyingIndex));
            return true;
        }
        return false;
    }

    private void fillSearchIndexResultSet(List<ORecord<?>> resultSet, Object indexResult) {
        if (indexResult != null) {
            if (indexResult instanceof Collection) {
                Collection indexResultSet = (Collection)indexResult;
                if (indexResultSet.size() > 0) {
                    for (OIdentifiable o : indexResultSet) {
                        this.fillResultSet(resultSet, o);
                    }
                }
            } else {
                this.fillResultSet(resultSet, (OIdentifiable)indexResult);
            }
        }
    }

    private void fillResultSet(List<ORecord<?>> resultSet, OIdentifiable o) {
        if (this.rangeFrom != FIRST && o.getIdentity().compareTo(this.rangeFrom) <= 0) {
            return;
        }
        if (this.rangeTo != LAST && o.getIdentity().compareTo(this.rangeTo) > 0) {
            return;
        }
        resultSet.add(o.getRecord());
    }

    protected boolean filter(ORecordInternal<?> iRecord) {
        return this.compiledFilter.evaluate(this.database, (ORecordSchemaAware)iRecord);
    }

    protected int parseProjections() {
        int currentPos = 0;
        StringBuilder word = new StringBuilder();
        currentPos = OSQLHelper.nextWord(this.text, this.textUpperCase, currentPos, word, true);
        if (!word.toString().equals(KEYWORD_SELECT)) {
            return -1;
        }
        int fromPosition = this.textUpperCase.indexOf(KEYWORD_FROM_2FIND, currentPos);
        if (fromPosition == -1) {
            throw new OQueryParsingException("Missed FROM", this.text, currentPos);
        }
        String projectionString = this.text.substring(currentPos, fromPosition).trim();
        if (projectionString.length() > 0 && !projectionString.equals("*")) {
            this.projections = new LinkedHashMap<String, Object>();
            List<String> items = OStringSerializerHelper.smartSplit(projectionString, ',', new char[0]);
            for (String projection : items) {
                projection = projection.trim();
                if (this.projections == null) {
                    throw new OCommandSQLParsingException("Projection not allowed with FLATTEN() operator");
                }
                String fieldName = null;
                int pos = projection.toUpperCase().indexOf(KEYWORD_AS);
                if (pos > -1) {
                    fieldName = projection.substring(pos + KEYWORD_AS.length()).trim();
                    projection = projection.substring(0, pos).trim();
                    if (this.projections.containsKey(fieldName)) {
                        throw new OCommandSQLParsingException("Field '" + fieldName + "' is duplicated in current SELECT, choose a different name");
                    }
                } else {
                    int pos1 = projection.indexOf(46);
                    int pos2 = projection.indexOf(40);
                    pos = -1;
                    if (pos1 > -1 && pos2 == -1) {
                        pos = pos1;
                    } else if (pos2 > -1 && pos1 == -1) {
                        pos = pos2;
                    } else if (pos1 > -1 && pos2 > -1) {
                        pos = Math.min(pos1, pos2);
                    }
                    fieldName = pos > -1 ? projection.substring(0, pos) : projection;
                    fieldName = OStringSerializerHelper.getStringContent(fieldName);
                    int fieldIndex = 2;
                    while (this.projections.containsKey(fieldName)) {
                        fieldName = fieldName + fieldIndex;
                        ++fieldIndex;
                    }
                }
                if (projection.toUpperCase().startsWith("FLATTEN(")) {
                    List<String> pars = OStringSerializerHelper.getParameters(projection);
                    if (pars.size() != 1) {
                        throw new OCommandSQLParsingException("FLATTEN operator expects the field name as parameter. Example FLATTEN( out )");
                    }
                    this.flattenTarget = OSQLHelper.parseValue(this.database, this, pars.get(0).trim());
                    this.projections = null;
                    if (this.anyFunctionAggregates || !(this.flattenTarget instanceof OSQLFunctionRuntime) || !((OSQLFunctionRuntime)this.flattenTarget).aggregateResults()) continue;
                    this.anyFunctionAggregates = true;
                    continue;
                }
                Object projectionValue = OSQLHelper.parseValue(this.database, this, projection);
                this.projections.put(fieldName, projectionValue);
                if (this.anyFunctionAggregates || !(projectionValue instanceof OSQLFunctionRuntime) || !((OSQLFunctionRuntime)projectionValue).aggregateResults()) continue;
                this.anyFunctionAggregates = true;
            }
        }
        currentPos = fromPosition + "FROM".length() + 1;
        return currentPos;
    }

    private void scanEntireClusters(int[] clusterIds) {
        ORecordId realRangeFrom = this.getRealRange(clusterIds, this.rangeFrom);
        ORecordId realRangeTo = this.getRealRange(clusterIds, this.rangeTo);
        ((OStorageEmbedded)this.database.getStorage()).browse(clusterIds, realRangeFrom, realRangeTo, this, (ORecordInternal)this.database.newInstance(), false);
    }

    private ORecordId getRealRange(int[] clusterIds, ORecordId iRange) {
        if (iRange == FIRST) {
            return new ORecordId(clusterIds[0], 0L);
        }
        if (iRange == LAST) {
            return new ORecordId(clusterIds[clusterIds.length - 1], -1L);
        }
        return iRange;
    }

    private void applyOrderBy() {
        if (this.orderedFields == null || this.tempResult == null) {
            return;
        }
        ODocumentHelper.sort(this.tempResult, this.orderedFields);
        this.orderedFields.clear();
    }

    private void applyFlatten() {
        if (this.flattenTarget == null) {
            return;
        }
        ArrayList<OIdentifiable> finalResult = new ArrayList<OIdentifiable>();
        if (this.tempResult != null) {
            for (OIdentifiable id : this.tempResult) {
                Object fieldValue = this.flattenTarget instanceof OSQLFilterItem ? ((OSQLFilterItem)this.flattenTarget).getValue((ORecordInternal)id.getRecord()) : (this.flattenTarget instanceof OSQLFunctionRuntime ? ((OSQLFunctionRuntime)this.flattenTarget).getResult() : this.flattenTarget.toString());
                if (fieldValue == null) continue;
                if (fieldValue instanceof Collection) {
                    for (Object o : (Collection)fieldValue) {
                        if (!(o instanceof ODocument)) continue;
                        finalResult.add((ODocument)o);
                    }
                    continue;
                }
                finalResult.add((ODocument)fieldValue);
            }
        }
        this.tempResult = finalResult;
    }

    private void processRecordAsResult(OIdentifiable iRecord) {
        if (this.projections != null) {
            if (this.projections.size() == 1 && this.projections.keySet().iterator().next().equalsIgnoreCase("@rid")) {
                this.request.getResultListener().result(iRecord.getIdentity());
                return;
            }
            ODocument doc = (ODocument)iRecord.getRecord();
            ODocument result = new ODocument(this.database).setOrdered(true);
            boolean canExcludeResult = false;
            for (Map.Entry<String, Object> projection : this.projections.entrySet()) {
                Object value;
                if (projection.getValue() instanceof OSQLFilterItemField) {
                    value = ((OSQLFilterItemField)projection.getValue()).getValue(doc);
                } else if (projection.getValue() instanceof OSQLFunctionRuntime) {
                    OSQLFunctionRuntime f = (OSQLFunctionRuntime)projection.getValue();
                    canExcludeResult = f.filterResult();
                    value = f.execute(doc);
                } else {
                    value = projection.getValue();
                }
                if (value == null) continue;
                result.field(projection.getKey(), value);
            }
            if (canExcludeResult && result.isEmpty()) {
                return;
            }
            if (!this.anyFunctionAggregates) {
                this.request.getResultListener().result(result);
            }
        } else {
            this.request.getResultListener().result(iRecord);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void searchInClasses() {
        void var5_7;
        int[] clusterIds;
        OClass cls = this.compiledFilter.getTargetClasses().keySet().iterator().next();
        this.database.checkSecurity("database.class", 2, (Object)cls.getName());
        int[] arr$ = clusterIds = cls.getPolymorphicClusterIds();
        int len$ = arr$.length;
        boolean bl = false;
        while (var5_7 < len$) {
            int clusterId = arr$[var5_7];
            this.database.checkSecurity("database.cluster", 2, (Object)this.database.getClusterNameById(clusterId));
            ++var5_7;
        }
        ArrayList resultSet = new ArrayList();
        if (this.searchForIndexes(resultSet, cls)) {
            OProfiler.getInstance().updateCounter("Query.indexUsage", 1L);
            for (ORecord oRecord : resultSet) {
                if (!this.filter((ORecordInternal)oRecord)) continue;
                this.addResult(oRecord);
            }
        } else {
            this.scanEntireClusters(clusterIds);
        }
    }

    private void searchInClusters() {
        String firstCluster = this.compiledFilter.getTargetClusters().keySet().iterator().next();
        if (firstCluster == null || firstCluster.length() == 0) {
            throw new OCommandExecutionException("No cluster or schema class selected in query");
        }
        int[] clusterIds = Character.isDigit(firstCluster.charAt(0)) ? OStringSerializerHelper.splitIntArray(firstCluster) : new int[]{this.database.getClusterIdByName(firstCluster.toLowerCase())};
        this.database.checkSecurity("database.cluster", 2, (Object)firstCluster.toLowerCase());
        this.scanEntireClusters(clusterIds);
    }

    private void searchInRecords() {
        ORecordId rid = new ORecordId();
        for (String rec : this.compiledFilter.getTargetRecords()) {
            rid.fromString(rec);
            ORecordInternal record = (ORecordInternal)this.database.load(rid);
            this.foreach(record);
        }
    }

    private void searchInIndex() {
        OIndex index = this.database.getMetadata().getIndexManager().getIndex(this.compiledFilter.getTargetIndex());
        if (index == null) {
            throw new OCommandExecutionException("Target index '" + this.compiledFilter.getTargetIndex() + "' not found");
        }
        if (this.compiledFilter.getRootCondition() != null) {
            Object value;
            Collection<ODocument> entries;
            if (!"KEY".equalsIgnoreCase(this.compiledFilter.getRootCondition().getLeft().toString())) {
                throw new OCommandExecutionException("'Key' field is required for queries against indexes");
            }
            Collection<OIdentifiable> result = null;
            OQueryOperator indexOperator = this.compiledFilter.getRootCondition().getOperator();
            if (indexOperator instanceof OQueryOperatorBetween) {
                Object[] values = (Object[])this.compiledFilter.getRootCondition().getRight();
                if (this.projections != null && this.projections.size() == 1 && this.projections.keySet().iterator().next().equalsIgnoreCase("@rid")) {
                    result = index.getValuesBetween(OSQLHelper.getValue(values[0]), OSQLHelper.getValue(values[2]));
                    for (OIdentifiable e : result) {
                        this.addResult(e.getIdentity());
                    }
                } else {
                    entries = index.getEntriesBetween(OSQLHelper.getValue(values[0]), OSQLHelper.getValue(values[2]));
                    for (ODocument r : entries) {
                        this.addResult(r);
                    }
                }
            } else if (indexOperator instanceof OQueryOperatorMajor) {
                value = this.compiledFilter.getRootCondition().getRight();
                if (this.projections != null && this.projections.size() == 1 && this.projections.keySet().iterator().next().equalsIgnoreCase("@rid")) {
                    result = index.getValuesMajor(OSQLHelper.getValue(value), false);
                    for (OIdentifiable e : result) {
                        this.addResult(e.getIdentity());
                    }
                } else {
                    entries = index.getEntriesMajor(OSQLHelper.getValue(value), false);
                    for (ODocument document : entries) {
                        this.addResult(document);
                    }
                }
            } else if (indexOperator instanceof OQueryOperatorMajorEquals) {
                value = this.compiledFilter.getRootCondition().getRight();
                if (this.projections != null && this.projections.size() == 1 && this.projections.keySet().iterator().next().equalsIgnoreCase("@rid")) {
                    result = index.getValuesMajor(OSQLHelper.getValue(value), true);
                    for (OIdentifiable e : result) {
                        this.addResult(e.getIdentity());
                    }
                } else {
                    entries = index.getEntriesMajor(OSQLHelper.getValue(value), true);
                    for (ODocument document : entries) {
                        this.addResult(document);
                    }
                }
            } else if (indexOperator instanceof OQueryOperatorMinor) {
                value = this.compiledFilter.getRootCondition().getRight();
                if (this.projections != null && this.projections.size() == 1 && this.projections.keySet().iterator().next().equalsIgnoreCase("@rid")) {
                    result = index.getValuesMinor(OSQLHelper.getValue(value), false);
                    for (OIdentifiable e : result) {
                        this.addResult(e.getIdentity());
                    }
                } else {
                    entries = index.getEntriesMinor(OSQLHelper.getValue(value), false);
                    for (ODocument document : entries) {
                        this.addResult(document);
                    }
                }
            } else if (indexOperator instanceof OQueryOperatorMinorEquals) {
                value = this.compiledFilter.getRootCondition().getRight();
                if (this.projections != null && this.projections.size() == 1 && this.projections.keySet().iterator().next().equalsIgnoreCase("@rid")) {
                    result = index.getValuesMinor(OSQLHelper.getValue(value), true);
                    for (OIdentifiable e : result) {
                        this.addResult(e.getIdentity());
                    }
                } else {
                    entries = index.getEntriesMinor(OSQLHelper.getValue(value), true);
                    for (ODocument document : entries) {
                        this.addResult(document);
                    }
                }
            } else if (indexOperator instanceof OQueryOperatorIn) {
                List origValues = (List)this.compiledFilter.getRootCondition().getRight();
                ArrayList<Object> values = new ArrayList<Object>(origValues.size());
                for (Object val : origValues) {
                    val = OSQLHelper.getValue(val);
                    val = OType.convert(val, index.getKeyType().getDefaultJavaType());
                    values.add(val);
                }
                if (this.projections != null && this.projections.size() == 1 && this.projections.keySet().iterator().next().equalsIgnoreCase("@rid")) {
                    result = index.getValues(values);
                    for (OIdentifiable e : result) {
                        this.addResult(e.getIdentity());
                    }
                } else {
                    Collection<ODocument> entries2 = index.getEntries(values);
                    for (ODocument document : entries2) {
                        this.addResult(document);
                    }
                }
            } else {
                Object right = this.compiledFilter.getRootCondition().getRight();
                Object keyValue = OSQLHelper.getValue(right);
                Object res = index.get(keyValue);
                if (res != null) {
                    if (res instanceof Collection) {
                        for (OIdentifiable r : (Collection)res) {
                            this.addResult(this.createIndexEntryAsDocument(keyValue, r.getIdentity()));
                        }
                    } else {
                        this.addResult(this.createIndexEntryAsDocument(keyValue, ((OIdentifiable)res).getIdentity()));
                    }
                }
            }
        } else {
            Iterator<Map.Entry<Object, ?>> it = index.iterator();
            while (it.hasNext()) {
                Map.Entry<Object, ?> current = it.next();
                if (current.getValue() instanceof Collection) {
                    Iterator<OIdentifiable> collIt = ((ORecordLazySet)current.getValue()).rawIterator();
                    while (collIt.hasNext()) {
                        this.addResult(this.createIndexEntryAsDocument(current.getKey(), collIt.next().getIdentity()));
                    }
                    continue;
                }
                this.addResult(this.createIndexEntryAsDocument(current.getKey(), (OIdentifiable)current.getValue()));
            }
        }
        if (this.anyFunctionAggregates) {
            for (Map.Entry<String, Object> projection : this.projections.entrySet()) {
                if (!(projection.getValue() instanceof OSQLFunctionRuntime)) continue;
                OSQLFunctionRuntime f = (OSQLFunctionRuntime)projection.getValue();
                f.setResult(index.getSize());
            }
        }
    }

    private ODocument createIndexEntryAsDocument(Object iKey, OIdentifiable iValue) {
        ODocument doc = new ODocument().setOrdered(true);
        doc.field("key", iKey);
        doc.field("rid", iValue);
        doc.unsetDirty();
        return doc;
    }

    private Object processResult() {
        if (this.anyFunctionAggregates) {
            ODocument result = new ODocument(this.database).setOrdered(true);
            for (Map.Entry<String, Object> projection : this.projections.entrySet()) {
                Object value;
                if (projection.getValue() instanceof OSQLFilterItemField) {
                    value = ((OSQLFilterItemField)projection.getValue()).getValue(result);
                } else if (projection.getValue() instanceof OSQLFunctionRuntime) {
                    OSQLFunctionRuntime f = (OSQLFunctionRuntime)projection.getValue();
                    value = f.getResult();
                } else {
                    value = projection.getValue();
                }
                result.field(projection.getKey(), value);
            }
            this.request.getResultListener().result(result);
        } else if (this.tempResult != null) {
            int limitIndex = 0;
            for (OIdentifiable doc : this.tempResult) {
                if (this.orderedFields != null && this.limit > 0) {
                    if (limitIndex >= this.limit) break;
                    ++limitIndex;
                    this.processRecordAsResult(doc);
                    continue;
                }
                this.processRecordAsResult(doc);
            }
            this.tempResult.clear();
            this.tempResult = null;
        }
        if (this.request instanceof OSQLSynchQuery) {
            return ((OSQLSynchQuery)this.request).getResult();
        }
        return null;
    }

    private void optimize() {
        if (this.compiledFilter == null) {
            return;
        }
        this.optimizeBranch(null, this.compiledFilter.getRootCondition());
    }

    private void optimizeBranch(OSQLFilterCondition iParentCondition, OSQLFilterCondition iCondition) {
        Object right;
        if (iCondition == null) {
            return;
        }
        Object left = iCondition.getLeft();
        if (left instanceof OSQLFilterCondition) {
            this.optimizeBranch(iCondition, (OSQLFilterCondition)left);
        }
        if ((right = iCondition.getRight()) instanceof OSQLFilterCondition) {
            this.optimizeBranch(iCondition, (OSQLFilterCondition)right);
        }
        OQueryOperator oper = iCondition.getOperator();
        Boolean result = null;
        if (left instanceof OSQLFilterItemField & right instanceof OSQLFilterItemField && ((OSQLFilterItemField)left).getRoot().equals(((OSQLFilterItemField)right).getRoot())) {
            if (oper instanceof OQueryOperatorEquals) {
                result = Boolean.TRUE;
            } else if (oper instanceof OQueryOperatorNotEquals) {
                result = Boolean.FALSE;
            }
        }
        if (result != null) {
            if (iParentCondition != null) {
                if (iCondition == iParentCondition.getLeft()) {
                    iCondition.setLeft(result);
                } else {
                    iCondition.setRight(result);
                }
            } else if (result instanceof Boolean && ((Boolean)result).booleanValue()) {
                this.compiledFilter.setRootCondition(null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OSearchInIndexTriple {
        private OQueryOperator indexOperator;
        private Object key;
        private OIndex<?> index;

        private OSearchInIndexTriple(OQueryOperator indexOperator, Object key, OIndex<?> index) {
            this.indexOperator = indexOperator;
            this.key = key;
            this.index = index;
        }
    }
}

