/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLPermissionAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLTruncateCluster
extends OCommandExecutorSQLPermissionAbstract {
    public static final String KEYWORD_TRUNCATE = "TRUNCATE";
    public static final String KEYWORD_CLUSTER = "CLUSTER";
    private String clusterName;

    public OCommandExecutorSQLTruncateCluster parse(OCommandRequestText iRequest) {
        iRequest.getDatabase().checkSecurity("database.command", 8);
        this.init(iRequest.getDatabase(), iRequest.getText());
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_TRUNCATE)) {
            throw new OCommandSQLParsingException("Keyword TRUNCATE not found", this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true)) == -1 || !word.toString().equals(KEYWORD_CLUSTER)) {
            throw new OCommandSQLParsingException("Keyword CLUSTER not found", this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OSQLHelper.nextWord(this.text, this.text, oldPos, word, true)) == -1) {
            throw new OCommandSQLParsingException("Expected cluster name", this.text, oldPos);
        }
        this.clusterName = word.toString();
        if (this.database.getClusterIdByName(this.clusterName) == -1) {
            throw new OCommandSQLParsingException("Cluster '" + this.clusterName + "' not found", this.text, oldPos);
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.clusterName == null) {
            throw new OCommandExecutionException("Can't execute the command because it hasn't been parsed yet");
        }
        OCluster cluster = ((OStorageEmbedded)this.database.getStorage()).getClusterByName(this.clusterName);
        long recs = cluster.getEntries();
        try {
            cluster.truncate();
        }
        catch (IOException e) {
            throw new OCommandExecutionException("Error on executing command", e);
        }
        return recs;
    }
}

