/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.filter;

import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.query.OQueryRuntimeValueMulti;
import com.orientechnologies.orient.core.record.ORecordSchemaAware;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItem;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemAbstract;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionRuntime;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSQLFilterCondition {
    private static final String NULL_VALUE = "null";
    protected Object left;
    protected OQueryOperator operator;
    protected Object right;

    public OSQLFilterCondition(Object iLeft, OQueryOperator iOperator) {
        this.left = iLeft;
        this.operator = iOperator;
    }

    public OSQLFilterCondition(Object iLeft, OQueryOperator iOperator, Object iRight) {
        this.left = iLeft;
        this.operator = iOperator;
        this.right = iRight;
    }

    public Object evaluate(ORecordSchemaAware<?> iRecord) {
        Object r;
        Object l = this.evaluate(iRecord, this.left);
        Object[] convertedValues = this.checkForConversion(iRecord, l, r = this.evaluate(iRecord, this.right));
        if (convertedValues != null) {
            l = convertedValues[0];
            r = convertedValues[1];
        }
        if (this.operator == null) {
            return l;
        }
        return this.operator.evaluateRecord(iRecord, this, l, r);
    }

    private Object[] checkForConversion(ORecordSchemaAware<?> iRecord, Object l, Object r) {
        Object[] result = null;
        if (r instanceof String && r.equals("_DEFINED_") || l instanceof String && l.equals("_DEFINED_")) {
            result = new Object[]{((OSQLFilterItemAbstract)this.left).getRoot(), r};
        } else if (l != null && r != null && !l.getClass().isAssignableFrom(r.getClass()) && !r.getClass().isAssignableFrom(l.getClass())) {
            if (r instanceof Integer && !(l instanceof Number)) {
                if (l instanceof String && ((String)l).indexOf(46) > -1) {
                    result = new Object[]{new Float((String)l).intValue(), r};
                } else if (l instanceof Date) {
                    result = new Object[]{((Date)l).getTime(), r};
                } else if (!(l instanceof OQueryRuntimeValueMulti || l instanceof Collection || l.getClass().isArray())) {
                    result = new Object[]{this.getInteger(l), r};
                }
            } else if (l instanceof Integer && !(r instanceof Number)) {
                if (r instanceof String && ((String)r).indexOf(46) > -1) {
                    result = new Object[]{l, new Float((String)r).intValue()};
                } else if (r instanceof Date) {
                    result = new Object[]{l, ((Date)r).getTime()};
                } else if (!(r instanceof OQueryRuntimeValueMulti || r instanceof Collection || r.getClass().isArray())) {
                    result = new Object[]{l, this.getInteger(r)};
                }
            } else if (r instanceof Float && !(l instanceof Float)) {
                result = new Object[]{this.getFloat(l), r};
            } else if (l instanceof Float && !(r instanceof Float)) {
                result = new Object[]{l, this.getFloat(r)};
            } else if (r instanceof Date && !l.getClass().isArray() && !(l instanceof Date)) {
                result = new Object[]{this.getDate(iRecord, l), r};
            } else if (l instanceof Date && !r.getClass().isArray() && !(r instanceof Date)) {
                result = new Object[]{l, this.getDate(iRecord, r)};
            } else if (r instanceof ORID && l instanceof String && !l.equals("_NOT_NULL_")) {
                result = new Object[]{new ORecordId((String)l), r};
            } else if (l instanceof ORID && r instanceof String && !r.equals("_NOT_NULL_")) {
                result = new Object[]{l, new ORecordId((String)r)};
            }
        }
        return result;
    }

    protected Integer getInteger(Object iValue) {
        if (iValue == null) {
            return null;
        }
        String stringValue = iValue.toString();
        if (NULL_VALUE.equals(stringValue)) {
            return null;
        }
        if ("_DEFINED_".equals(stringValue)) {
            return null;
        }
        if (OStringSerializerHelper.contains(stringValue, '.') || OStringSerializerHelper.contains(stringValue, ',')) {
            return (int)Float.parseFloat(stringValue);
        }
        return stringValue.length() > 0 ? new Integer(stringValue) : new Integer(0);
    }

    protected Float getFloat(Object iValue) {
        if (iValue == null) {
            return null;
        }
        String stringValue = iValue.toString();
        if (NULL_VALUE.equals(stringValue)) {
            return null;
        }
        return stringValue.length() > 0 ? new Float(stringValue) : new Float(0.0f);
    }

    protected Date getDate(ORecordSchemaAware<?> iRecord, Object iValue) {
        if (iValue == null) {
            return null;
        }
        if (iValue instanceof Long) {
            return new Date((Long)iValue);
        }
        String stringValue = iValue.toString();
        if (NULL_VALUE.equals(stringValue)) {
            return null;
        }
        if (stringValue.length() <= 0) {
            return null;
        }
        if (Pattern.matches("^\\d+$", stringValue)) {
            return new Date(Long.valueOf(stringValue));
        }
        OStorageConfiguration config = iRecord.getDatabase().getStorage().getConfiguration();
        DateFormat formatter = config.getDateFormatInstance();
        if (stringValue.length() > config.dateFormat.length()) {
            formatter = config.getDateTimeFormatInstance();
        }
        try {
            return formatter.parse(stringValue);
        }
        catch (ParseException pe) {
            throw new OQueryParsingException("Error on conversion of date '" + stringValue + "' using the format: " + formatter.toString());
        }
    }

    protected Object evaluate(ORecordSchemaAware<?> iRecord, Object iValue) {
        if (iValue instanceof OSQLFilterItem) {
            if (iRecord.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
                try {
                    iRecord = (ORecordSchemaAware)iRecord.load();
                }
                catch (ORecordNotFoundException e) {
                    return null;
                }
            }
            return ((OSQLFilterItem)iValue).getValue(iRecord);
        }
        if (iValue instanceof OSQLFilterCondition) {
            return ((OSQLFilterCondition)iValue).evaluate(iRecord);
        }
        if (iValue instanceof OSQLFunctionRuntime) {
            OSQLFunctionRuntime f = (OSQLFunctionRuntime)iValue;
            return f.execute(iRecord);
        }
        return iValue;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('(');
        buffer.append(this.left);
        if (this.operator != null) {
            buffer.append(' ');
            buffer.append(this.operator);
            buffer.append(' ');
            buffer.append(this.right);
            buffer.append(')');
        }
        return buffer.toString();
    }

    public Object getLeft() {
        return this.left;
    }

    public Object getRight() {
        return this.right;
    }

    public OQueryOperator getOperator() {
        return this.operator;
    }

    public void setLeft(Object iValue) {
        this.left = iValue;
    }

    public void setRight(Object iValue) {
        this.right = iValue;
    }
}

