/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.math;

import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.sql.functions.math.OSQLFunctionMathAbstract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSQLFunctionAverage
extends OSQLFunctionMathAbstract {
    public static final String NAME = "avg";
    private Number sum;
    private int total = 0;

    public OSQLFunctionAverage() {
        super(NAME, 1, 1);
    }

    @Override
    public Object execute(ORecord<?> iCurrentRecord, Object[] iParameters) {
        Number value = (Number)iParameters[0];
        ++this.total;
        if (value != null && value instanceof Number) {
            if (this.sum == null) {
                this.sum = value;
            } else {
                Number contextValue = this.getContextValue(this.sum, value.getClass());
                if (contextValue instanceof Integer) {
                    this.sum = this.sum.intValue() + value.intValue();
                } else if (contextValue instanceof Long) {
                    this.sum = this.sum.longValue() + value.longValue();
                } else if (contextValue instanceof Short) {
                    this.sum = this.sum.shortValue() + value.shortValue();
                } else if (contextValue instanceof Float) {
                    this.sum = Float.valueOf(this.sum.floatValue() + value.floatValue());
                } else if (contextValue instanceof Double) {
                    this.sum = this.sum.doubleValue() + value.doubleValue();
                }
            }
        }
        return value;
    }

    @Override
    public String getSyntax() {
        return "Syntax error: avg(<field>)";
    }

    @Override
    public Object getResult() {
        if (this.sum instanceof Integer) {
            return this.sum.intValue() / this.total;
        }
        if (this.sum instanceof Long) {
            return this.sum.longValue() / (long)this.total;
        }
        if (this.sum instanceof Float) {
            return Float.valueOf(this.sum.floatValue() / (float)this.total);
        }
        if (this.sum instanceof Double) {
            return this.sum.doubleValue() / (double)this.total;
        }
        return null;
    }
}

