/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEqualityNotNulls;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OQueryOperatorBetween
extends OQueryOperatorEqualityNotNulls {
    public OQueryOperatorBetween() {
        super("BETWEEN", 5, false, 3);
    }

    @Override
    protected boolean evaluateExpression(ORecordInternal<?> iRecord, OSQLFilterCondition iCondition, Object iLeft, Object iRight) {
        if (!iRight.getClass().isArray()) {
            throw new IllegalArgumentException("Found '" + iRight + "' while was expected: " + this.getSyntax());
        }
        Object[] values = (Object[])iRight;
        if (values.length != 3) {
            throw new IllegalArgumentException("Found '" + OMultiValue.toString((Object)iRight) + "' while was expected: " + this.getSyntax());
        }
        Object right1 = OType.convert(values[0], iLeft.getClass());
        if (right1 == null) {
            return false;
        }
        Object right2 = OType.convert(values[2], iLeft.getClass());
        if (right2 == null) {
            return false;
        }
        return ((Comparable)iLeft).compareTo(right1) >= 0 && ((Comparable)iLeft).compareTo(right2) <= 0;
    }

    @Override
    public String getSyntax() {
        return "<left> " + this.keyword + " <minRange> AND <maxRange>";
    }

    @Override
    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        return OIndexReuseType.INDEX_METHOD;
    }
}

