/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.query.OQueryRuntimeValueMulti;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEqualityNotNulls;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OQueryOperatorTraverse
extends OQueryOperatorEqualityNotNulls {
    private int startDeepLevel = 0;
    private int endDeepLevel = -1;
    private String[] cfgFields;

    public OQueryOperatorTraverse() {
        super("TRAVERSE", 5, false);
    }

    public OQueryOperatorTraverse(int startDeepLevel, int endDeepLevel, String[] iFieldList) {
        this();
        this.startDeepLevel = startDeepLevel;
        this.endDeepLevel = endDeepLevel;
        this.cfgFields = iFieldList;
    }

    @Override
    public String getSyntax() {
        return "<left> TRAVERSE[(<begin-deep-level> [,<maximum-deep-level> [,<fields>]] )] ( <conditions> )";
    }

    @Override
    protected boolean evaluateExpression(ORecordInternal<?> iRecord, OSQLFilterCondition iCondition, Object iLeft, Object iRight) {
        Object target;
        OSQLFilterCondition condition;
        if (iCondition.getLeft() instanceof OSQLFilterCondition) {
            condition = (OSQLFilterCondition)iCondition.getLeft();
            target = iRight;
        } else {
            condition = (OSQLFilterCondition)iCondition.getRight();
            target = iLeft;
        }
        HashSet<ORID> evaluatedRecords = new HashSet<ORID>();
        return this.traverse(iRecord, iCondition, condition, target, 0, evaluatedRecords);
    }

    private boolean traverse(ORecordInternal<?> iRecord, OSQLFilterCondition iRootCondition, OSQLFilterCondition iCondition, Object iTarget, int iLevel, Set<ORID> iEvaluatedRecords) {
        block18: {
            block20: {
                block19: {
                    block17: {
                        if (this.endDeepLevel > -1 && iLevel > this.endDeepLevel) {
                            return false;
                        }
                        if (iTarget instanceof ORID) {
                            if (iEvaluatedRecords.contains(iTarget)) {
                                return false;
                            }
                            iTarget = new ODocument(iRecord.getDatabase(), (ORID)iTarget);
                        } else if (iTarget instanceof ODocument && iEvaluatedRecords.contains(((ODocument)iTarget).getIdentity())) {
                            return false;
                        }
                        if (!(iTarget instanceof ODocument)) break block17;
                        ODocument target = (ODocument)iTarget;
                        iEvaluatedRecords.add(target.getIdentity());
                        if (target.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
                            try {
                                target.load();
                            }
                            catch (ORecordNotFoundException e) {
                                return false;
                            }
                        }
                        if (iLevel >= this.startDeepLevel && (Boolean)iCondition.evaluate(target) == Boolean.TRUE) {
                            return true;
                        }
                        for (String cfgField : this.cfgFields) {
                            if (cfgField.equalsIgnoreCase("ANY()")) {
                                for (String fieldName : target.fieldNames()) {
                                    if (!this.traverse(iRecord, iRootCondition, iCondition, target.rawField(fieldName), iLevel + 1, iEvaluatedRecords)) continue;
                                    return true;
                                }
                                continue;
                            }
                            if (cfgField.equalsIgnoreCase("ANY()")) {
                                for (String fieldName : target.fieldNames()) {
                                    if (this.traverse(iRecord, iRootCondition, iCondition, target.rawField(fieldName), iLevel + 1, iEvaluatedRecords)) continue;
                                    return false;
                                }
                                return true;
                            }
                            if (!this.traverse(iRecord, iRootCondition, iCondition, target.rawField(cfgField), iLevel + 1, iEvaluatedRecords)) continue;
                            return true;
                        }
                        break block18;
                    }
                    if (!(iTarget instanceof OQueryRuntimeValueMulti)) break block19;
                    OQueryRuntimeValueMulti multi = (OQueryRuntimeValueMulti)iTarget;
                    for (Object o : multi.values) {
                        if (this.traverse(iRecord, iRootCondition, iCondition, o, iLevel + 1, iEvaluatedRecords) != Boolean.TRUE.booleanValue()) continue;
                        return true;
                    }
                    break block18;
                }
                if (!(iTarget instanceof Collection)) break block20;
                Collection collection = (Collection)iTarget;
                for (Object o : collection) {
                    if (this.traverse(iRecord, iRootCondition, iCondition, o, iLevel + 1, iEvaluatedRecords) != Boolean.TRUE.booleanValue()) continue;
                    return true;
                }
                break block18;
            }
            if (!(iTarget instanceof Map)) break block18;
            Map map = (Map)iTarget;
            for (ODocument o : map.values()) {
                if (this.traverse(iRecord, iRootCondition, iCondition, o, iLevel + 1, iEvaluatedRecords) != Boolean.TRUE.booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public OQueryOperator configure(List<String> iParams) {
        if (iParams == null) {
            return this;
        }
        int start = iParams.size() > 0 ? Integer.parseInt(iParams.get(0)) : this.startDeepLevel;
        int end = iParams.size() > 1 ? Integer.parseInt(iParams.get(1)) : this.endDeepLevel;
        String[] fields = new String[]{"any()"};
        if (iParams.size() > 2) {
            String f = iParams.get(2);
            if (f.startsWith("'") || f.startsWith("\"")) {
                f = f.substring(1, f.length() - 1);
            }
            fields = f.split(",");
        }
        return new OQueryOperatorTraverse(start, end, fields);
    }

    public int getStartDeepLevel() {
        return this.startDeepLevel;
    }

    public int getEndDeepLevel() {
        return this.endDeepLevel;
    }

    public String[] getCfgFields() {
        return this.cfgFields;
    }

    @Override
    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        return OIndexReuseType.NO_INDEX;
    }

    @Override
    public String toString() {
        return String.format("%s(%d,%d,%s)", this.keyword, this.startDeepLevel, this.endDeepLevel, Arrays.toString(this.cfgFields));
    }
}

