/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator.math;

import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OQueryOperatorMinus
extends OQueryOperator {
    public OQueryOperatorMinus() {
        super("-", 9, false);
    }

    @Override
    public Object evaluateRecord(ORecordInternal<?> iRecord, OSQLFilterCondition iCondition, Object iLeft, Object iRight) {
        if (iRight == null) {
            return iLeft;
        }
        if (iLeft instanceof Number && iRight instanceof Number) {
            Number l = (Number)iLeft;
            Number r = (Number)iRight;
            if (l instanceof Integer) {
                return l.intValue() - r.intValue();
            }
            if (l instanceof Long) {
                return l.longValue() - r.longValue();
            }
            if (l instanceof Short) {
                return l.shortValue() - r.shortValue();
            }
            if (l instanceof Float) {
                return Float.valueOf(l.floatValue() - r.floatValue());
            }
            if (l instanceof Double) {
                return l.doubleValue() - r.doubleValue();
            }
        }
        return null;
    }

    @Override
    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        if (iLeft instanceof Number && iRight instanceof Number) {
            return OIndexReuseType.INDEX_KEY;
        }
        return OIndexReuseType.NO_INDEX;
    }
}

