/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.query;

import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.query.OQueryAbstract;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.OMemoryInputStream;
import com.orientechnologies.orient.core.serialization.OMemoryOutputStream;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OSQLQuery<T>
extends OQueryAbstract<T>
implements OCommandRequestText {
    protected String text;

    public OSQLQuery() {
    }

    public OSQLQuery(String iText) {
        this.text = iText.trim();
    }

    @Override
    public List<T> run(Object ... iArgs) {
        if (this.database == null) {
            throw new OQueryParsingException("No database configured");
        }
        this.setParameters(iArgs);
        return (List)this.database.getStorage().command(this);
    }

    @Override
    public T runFirst(Object ... iArgs) {
        this.setLimit(1);
        List result = (List)this.execute(iArgs);
        return result != null && result.size() > 0 ? (T)result.get(0) : null;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public OCommandRequestText setText(String iText) {
        this.text = iText;
        return this;
    }

    public String toString() {
        return "OSQLQuery [text=" + this.text + "]";
    }

    @Override
    public OSerializableStream fromStream(byte[] iStream) throws OSerializationException {
        OMemoryInputStream buffer = new OMemoryInputStream(iStream);
        try {
            this.text = buffer.getAsString();
            this.limit = buffer.getAsInteger();
            this.beginRange = new ORecordId().fromStream(buffer.getAsByteArrayFixed(10));
            this.endRange = new ORecordId().fromStream(buffer.getAsByteArrayFixed(10));
            this.setFetchPlan(buffer.getAsString());
            byte[] paramBuffer = buffer.getAsByteArray();
            if (paramBuffer.length == 0) {
                this.parameters = null;
            } else {
                ODocument param = new ODocument();
                param.fromStream(paramBuffer);
                Map params = (Map)param.rawField("params");
                this.parameters = new HashMap();
                for (Map.Entry p : params.entrySet()) {
                    if (Character.isDigit(((String)p.getKey()).charAt(0))) {
                        this.parameters.put(Integer.parseInt((String)p.getKey()), p.getValue());
                        continue;
                    }
                    this.parameters.put(p.getKey(), p.getValue());
                }
            }
        }
        catch (IOException e) {
            throw new OSerializationException("Error while unmarshalling OSQLQuery", e);
        }
        return this;
    }

    @Override
    public byte[] toStream() throws OSerializationException {
        OMemoryOutputStream buffer = new OMemoryOutputStream();
        try {
            buffer.add(this.text);
            buffer.add(this.limit);
            buffer.addAsFixed(this.beginRange.toStream());
            buffer.addAsFixed(this.endRange.toStream());
            buffer.add(this.fetchPlan != null ? this.fetchPlan : "");
            if (this.parameters == null || this.parameters.size() == 0) {
                buffer.add(new byte[0]);
            } else {
                HashMap newParams = new HashMap(this.parameters);
                for (Map.Entry entry : newParams.entrySet()) {
                    Object value = entry.getValue();
                    if (value instanceof Set && ((Set)value).iterator().next() instanceof ORecord) {
                        HashSet<ORID> newSet = new HashSet<ORID>();
                        for (ORecord oRecord : (Set)value) {
                            newSet.add(oRecord.getIdentity());
                        }
                        this.parameters.put(entry.getKey(), newSet);
                        continue;
                    }
                    if (value instanceof List && ((List)value).get(0) instanceof ORecord) {
                        ArrayList<ORID> newList = new ArrayList<ORID>();
                        for (ORecord oRecord : (List)value) {
                            newList.add(oRecord.getIdentity());
                        }
                        this.parameters.put(entry.getKey(), newList);
                        continue;
                    }
                    if (!(value instanceof Map) || !(((Map)value).values().iterator().next() instanceof ORecord)) continue;
                    HashMap newMap = new HashMap();
                    for (Map.Entry entry2 : ((Map)value).entrySet()) {
                        newMap.put(entry2.getKey(), ((ORecord)entry2.getValue()).getIdentity());
                    }
                    this.parameters.put(entry.getKey(), newMap);
                }
                ODocument param = new ODocument();
                param.field("params", this.parameters);
                buffer.add(param.toStream());
            }
        }
        catch (IOException e) {
            throw new OSerializationException("Error while marshalling OSQLQuery", e);
        }
        return buffer.toByteArray();
    }
}

