/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage;

import com.orientechnologies.common.concur.lock.OLockManager;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.command.OCommandManager;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OClusterPositionIterator;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordBrowsingListener;
import com.orientechnologies.orient.core.storage.OStorageAbstract;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OStorageEmbedded
extends OStorageAbstract {
    protected final OLockManager<ORID, Runnable> lockManager = new OLockManager(OGlobalConfiguration.STORAGE_LOCK_TIMEOUT.getValueAsInteger());

    public OStorageEmbedded(String iName, String iFilePath, String iMode) {
        super(iName, iFilePath, iMode);
    }

    protected abstract ORawBuffer readRecord(OCluster var1, ORecordId var2, boolean var3);

    public abstract OCluster getClusterByName(String var1);

    @Override
    public Object command(OCommandRequestText iCommand) {
        OCommandExecutor executor = OCommandManager.instance().getExecutor(iCommand);
        executor.setProgressListener(iCommand.getProgressListener());
        executor.parse(iCommand);
        try {
            return executor.execute(iCommand.getParameters());
        }
        catch (OException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OCommandExecutionException("Error on execution of command: " + iCommand, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void browse(int[] iClusterId, ORecordId iBeginRange, ORecordId iEndRange, ORecordBrowsingListener iListener, ORecordInternal<?> ioRecord, boolean iLockEntireCluster) {
        this.checkOpeness();
        long timer = OProfiler.getInstance().startChrono();
        try {
            try {
                for (int clusterId : iClusterId) {
                    if (iBeginRange != null && clusterId < iBeginRange.getClusterId()) continue;
                    if (iEndRange != null && clusterId > iEndRange.getClusterId()) break;
                    OCluster cluster = this.getClusterById(clusterId);
                    long beginClusterPosition = iBeginRange != null && iBeginRange.getClusterId() == clusterId ? iBeginRange.getClusterPosition() : 0L;
                    long endClusterPosition = iEndRange != null && iEndRange.getClusterId() == clusterId ? iEndRange.getClusterPosition() : -1L;
                    ioRecord = this.browseCluster(iListener, ioRecord, cluster, beginClusterPosition, endClusterPosition, iLockEntireCluster);
                }
                Object var19_16 = null;
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "Error on browsing elements of cluster: " + iClusterId, (Throwable)e, new Object[0]);
                Object var19_17 = null;
                OProfiler.getInstance().stopChrono("OStorageLocal.foreach", timer);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var19_18 = null;
            OProfiler.getInstance().stopChrono("OStorageLocal.foreach", timer);
            throw throwable;
        }
        OProfiler.getInstance().stopChrono("OStorageLocal.foreach", timer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ORecordInternal<?> browseCluster(ORecordBrowsingListener iListener, ORecordInternal<?> ioRecord, OCluster cluster, long iBeginRange, long iEndRange, boolean iLockEntireCluster) throws IOException {
        if (iLockEntireCluster) {
            cluster.lock();
        }
        try {
            OClusterPositionIterator iterator = cluster.absoluteIterator(iBeginRange, iEndRange);
            ORecordId rid = new ORecordId(cluster.getId());
            ODatabaseRecord database = ioRecord.getDatabase();
            while (iterator.hasNext()) {
                long positionInPhyCluster = iterator.next();
                if (positionInPhyCluster == -1L) continue;
                rid.clusterPosition = positionInPhyCluster;
                ORecordInternal<?> record = (ORecordInternal<?>)database.load(rid);
                if (record != null && record.getRecordType() != 100) continue;
                ORecordInternal<?> recordToCheck = null;
                try {
                    if (record == null) {
                        ORawBuffer recordBuffer = this.readRecord(cluster, rid, !iLockEntireCluster);
                        if (recordBuffer == null || recordBuffer.recordType != 100) continue;
                        if (ioRecord.getRecordType() != recordBuffer.recordType) {
                            ioRecord = Orient.instance().getRecordFactoryManager().newInstance(ioRecord.getDatabase(), recordBuffer.recordType);
                        } else {
                            ioRecord.reset();
                        }
                        ioRecord.setVersion(recordBuffer.version);
                        ioRecord.setIdentity(cluster.getId(), positionInPhyCluster);
                        ioRecord.fromStream(recordBuffer.buffer);
                        recordToCheck = ioRecord;
                    } else {
                        recordToCheck = record;
                    }
                    if (iListener.foreach(recordToCheck)) continue;
                    break;
                }
                catch (OCommandExecutionException e) {
                    throw e;
                }
                catch (Exception e) {
                    OLogManager.instance().exception("Error on loading record %s. Cause: %s", e, OStorageException.class, new Object[]{recordToCheck != null ? recordToCheck.getIdentity() : null, e});
                }
            }
            Object var19_16 = null;
            if (iLockEntireCluster) {
                cluster.unlock();
            }
        }
        catch (Throwable throwable) {
            Object var19_17 = null;
            if (iLockEntireCluster) {
                cluster.unlock();
            }
            throw throwable;
        }
        return ioRecord;
    }

    protected void checkOpeness() {
        if (this.status != OStorageAbstract.STATUS.OPEN) {
            throw new OStorageException("Storage " + this.name + " is not opened.");
        }
    }
}

