/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local;

import com.orientechnologies.common.concur.resource.OSharedResourceExternal;
import com.orientechnologies.orient.core.config.OStorageLogicalClusterConfiguration;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerAnyStreamable;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerLong;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OClusterPositionIterator;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocal;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeStorage;
import java.io.IOException;

public class OClusterLogical
implements OCluster {
    private String name;
    private int id;
    private int localClusterId;
    private OMVRBTreeStorage<Long, OPhysicalPosition> map;
    private OPhysicalPosition total;
    private OSharedResourceExternal lock = new OSharedResourceExternal();
    public static final String TYPE = "LOGICAL";
    private OStorage storage;

    public OClusterLogical(OStorageLocal iStorage, int iId, String iName, int iPhysicalClusterId) throws IOException {
        this(iName, iId, iPhysicalClusterId);
        try {
            this.map = new OMVRBTreeStorage(iStorage, iStorage.getClusterById(iPhysicalClusterId).getName(), OStreamSerializerLong.INSTANCE, OStreamSerializerAnyStreamable.INSTANCE);
            this.map.getRecord().setIdentity(iPhysicalClusterId, -1L);
            this.total = new OPhysicalPosition(0, -1L, 0);
            this.map.put(new Long(-1L), this.total);
            this.storage = iStorage;
        }
        catch (Exception e) {
            throw new ODatabaseException("Error on creating internal map for logical cluster: " + iName, e);
        }
        this.map.save();
    }

    public OClusterLogical(OStorageLocal iStorage, String iName, int iId, ORID iRecordId) throws IOException {
        this(iName, iId, 0);
        try {
            this.map = new OMVRBTreeStorage(iStorage, iStorage.getClusterById(iRecordId.getClusterId()).getName(), iRecordId);
            this.map.load();
            this.total = (OPhysicalPosition)this.map.get(new Long(-1L));
            if (this.total == null) {
                this.total = new OPhysicalPosition(0, this.map.size(), 0);
                this.map.put(new Long(-1L), this.total);
            }
        }
        catch (Exception e) {
            throw new ODatabaseException("Error on load internal map for logical cluster: " + this.name, e);
        }
    }

    public OClusterLogical(OStorageLocal iStorage, OStorageLogicalClusterConfiguration iConfig) throws IOException {
        this(iStorage, iConfig.name, iConfig.id, iConfig.map);
    }

    protected OClusterLogical(String iName, int iId, int iPhysicalClusterId) {
        this.name = iName;
        this.id = iId;
        this.localClusterId = iPhysicalClusterId;
    }

    public void create(int iStartSize) throws IOException {
    }

    public void open() throws IOException {
    }

    public void close() {
    }

    public void delete() throws IOException {
        this.close();
        this.map.delete();
    }

    public void set(OCluster.ATTRIBUTES iAttribute, Object iValue) throws IOException {
        if (iAttribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        String stringValue = iValue != null ? iValue.toString() : null;
        switch (iAttribute) {
            case NAME: {
                this.storage.renameCluster(this.name, stringValue);
                this.name = stringValue;
            }
        }
    }

    public OPhysicalPosition getPhysicalPosition(long iPosition, OPhysicalPosition iPPosition) {
        return (OPhysicalPosition)this.map.get(iPosition);
    }

    public void setPhysicalPosition(long iPosition, long iDataPosition) {
        Long key = new Long(iPosition);
        OPhysicalPosition ppos = (OPhysicalPosition)this.map.get(key);
        ppos.dataPosition = iDataPosition;
        this.map.put(key, ppos);
    }

    public void setPhysicalPosition(long iPosition, int iDataId, long iDataPosition, byte iRecordType, int iVersion) {
        Long key = new Long(iPosition);
        OPhysicalPosition ppos = (OPhysicalPosition)this.map.get(key);
        ppos.dataSegment = iDataId;
        ppos.dataPosition = iDataPosition;
        ppos.type = iRecordType;
        this.map.put(key, ppos);
    }

    public void updateRecordType(long iPosition, byte iRecordType) throws IOException {
        Long key = new Long(iPosition);
        OPhysicalPosition ppos = (OPhysicalPosition)this.map.get(key);
        ppos.type = iRecordType;
        this.map.put(key, ppos);
    }

    public void updateVersion(long iPosition, int iVersion) throws IOException {
        Long key = new Long(iPosition);
        OPhysicalPosition ppos = (OPhysicalPosition)this.map.get(key);
        ppos.version = iVersion;
        this.map.put(key, ppos);
    }

    public void truncate() throws IOException {
        this.map.clear();
        this.total = new OPhysicalPosition(0, -1L, 0);
        this.map.put(new Long(-1L), this.total);
        this.map.save();
    }

    public void removePhysicalPosition(long iPosition, OPhysicalPosition iPPosition) {
        this.map.remove(iPosition);
        if (this.total.dataPosition == iPosition) {
            --this.total.dataPosition;
            this.map.put(new Long(-1L), this.total);
        }
    }

    public long addPhysicalPosition(int iDataSegmentId, long iRecordPosition, byte iRecordType) throws IOException {
        long pos = ++this.total.dataPosition;
        this.map.put(new Long(pos), new OPhysicalPosition(iDataSegmentId, iRecordPosition, iRecordType));
        this.map.put(new Long(-1L), this.total);
        return pos;
    }

    public long getEntries() {
        return this.map.size() - 1;
    }

    public long getFirstEntryPosition() {
        return 0L;
    }

    public long getLastEntryPosition() {
        return this.total.dataPosition;
    }

    public int getId() {
        return this.id;
    }

    public OClusterPositionIterator absoluteIterator() throws IOException {
        return new OClusterPositionIterator(this);
    }

    public OClusterPositionIterator absoluteIterator(long iBeginRange, long iEndRange) throws IOException {
        return new OClusterPositionIterator(this, iBeginRange, iEndRange);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name + " (id=" + this.id + ")";
    }

    public void synch() {
    }

    public void lock() {
        this.lock.acquireSharedLock();
    }

    public void unlock() {
        this.lock.releaseSharedLock();
    }

    public ORID getRID() {
        return this.map.getRecord().getIdentity();
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setRID(ORID iRID) {
        this.map.getRecord().setIdentity(iRID.getClusterId(), iRID.getClusterPosition());
    }

    public String getType() {
        return TYPE;
    }

    public int getLocalClusterId() {
        return this.localClusterId;
    }

    public long getSize() {
        return 0L;
    }

    public long getRecordsSize() throws IOException {
        return 0L;
    }
}

