/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OStorageFileConfiguration;
import com.orientechnologies.orient.core.config.OStorageSegmentConfiguration;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.storage.fs.OFile;
import com.orientechnologies.orient.core.storage.fs.OFileFactory;
import com.orientechnologies.orient.core.storage.impl.local.OSegment;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocal;
import java.io.IOException;

public class OMultiFileSegment
extends OSegment {
    protected OStorageSegmentConfiguration config;
    protected OFile[] files = new OFile[0];
    private final String fileExtension;
    private final String type;
    private final long maxSize;
    private final String defrag;
    private int fileStartSize;
    private int fileMaxSize;
    private final int fileIncrementSize;

    public OMultiFileSegment(OStorageLocal iStorage, OStorageSegmentConfiguration iConfig, String iFileExtension, int iRoundMaxSize) throws IOException {
        super(iStorage, iConfig.name);
        this.config = iConfig;
        this.fileExtension = iFileExtension;
        this.type = iConfig.fileType;
        this.defrag = iConfig.defrag;
        this.maxSize = OFileUtils.getSizeAsNumber((Object)iConfig.maxSize);
        this.fileStartSize = (int)OFileUtils.getSizeAsNumber((Object)iConfig.fileStartSize);
        this.fileMaxSize = (int)OFileUtils.getSizeAsNumber((Object)iConfig.fileMaxSize);
        this.fileIncrementSize = (int)OFileUtils.getSizeAsNumber((Object)iConfig.fileIncrementSize);
        if (iRoundMaxSize > 0) {
            this.fileMaxSize = this.fileMaxSize / iRoundMaxSize * iRoundMaxSize;
        }
        if (iConfig.infoFiles.length == 0) {
            this.files = new OFile[1];
            this.files[0] = OFileFactory.create(this.type, iStorage.getVariableParser().resolveVariables(this.storage.getStoragePath() + "/" + this.name + "." + 0 + this.fileExtension), iStorage.getMode());
            int perFileMaxSize = this.fileMaxSize;
            this.files[0].setMaxSize(perFileMaxSize);
            this.files[0].setIncrementSize(this.fileIncrementSize);
        } else {
            this.files = new OFile[iConfig.infoFiles.length];
            for (int i = 0; i < this.files.length; ++i) {
                this.files[i] = OFileFactory.create(this.type, iStorage.getVariableParser().resolveVariables(iConfig.infoFiles[i].path), iStorage.getMode());
                int perFileMaxSize = this.fileMaxSize;
                this.files[i].setMaxSize(perFileMaxSize);
                this.files[i].setIncrementSize(this.fileIncrementSize);
            }
        }
    }

    public void open() throws IOException {
        for (OFile file : this.files) {
            if (file.open()) continue;
            OLogManager.instance().warn((Object)this, "Segment file " + OFileUtils.getPath((String)file.getOsFile().getName()) + " was not closed correctly last time. Checking segments...", new Object[0]);
            OLogManager.instance().warn((Object)this, "OK", new Object[0]);
        }
    }

    public void create(int iStartSize) throws IOException {
        this.files = new OFile[1];
        this.fileStartSize = iStartSize;
        this.createNewFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.acquireExclusiveLock();
        try {
            for (OFile file : this.files) {
                if (file == null) continue;
                file.close();
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws IOException {
        this.acquireExclusiveLock();
        try {
            for (OFile file : this.files) {
                if (file == null) continue;
                file.delete();
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate() throws IOException {
        this.acquireExclusiveLock();
        try {
            this.files[0].shrink(0);
            if (this.files.length > 1) {
                for (int i = 1; i < this.files.length; ++i) {
                    if (this.files[i] == null) continue;
                    this.files[i].delete();
                }
                OFile f = this.files[0];
                this.files = new OFile[1];
                this.files[0] = f;
                OStorageFileConfiguration fileConfig = this.config.infoFiles[0];
                this.config.infoFiles = new OStorageFileConfiguration[1];
                this.config.infoFiles[0] = fileConfig;
                this.config.root.update();
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synch() {
        this.acquireSharedLock();
        try {
            for (OFile file : this.files) {
                if (file == null || !file.isOpen()) continue;
                file.synch();
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.releaseSharedLock();
            throw throwable;
        }
        this.releaseSharedLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFilledUpTo() {
        long l;
        this.acquireSharedLock();
        try {
            long filled = 0L;
            for (OFile file : this.files) {
                filled += (long)file.getFilledUpTo();
            }
            l = filled;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.releaseSharedLock();
            throw throwable;
        }
        this.releaseSharedLock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() {
        long l;
        this.acquireSharedLock();
        try {
            long size = 0L;
            for (OFile file : this.files) {
                size += (long)file.getFileSize();
            }
            l = size;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.releaseSharedLock();
            throw throwable;
        }
        this.releaseSharedLock();
        return l;
    }

    protected long[] allocateSpace(int iRecordSize) throws IOException {
        OFile file;
        int i;
        for (i = 0; i < this.files.length; ++i) {
            file = this.files[i];
            if (file.getFreeSpace() < iRecordSize) continue;
            return new long[]{i, file.allocateSpace(iRecordSize)};
        }
        for (i = 0; i < this.files.length; ++i) {
            file = this.files[i];
            if (!file.canOversize(iRecordSize)) continue;
            return new long[]{i, file.allocateSpace(iRecordSize)};
        }
        if (this.maxSize > 0L && this.getSize() >= this.maxSize) {
            throw new OStorageException("Unable to allocate the requested space of " + iRecordSize + " bytes because the segment is full: max-Size=" + this.maxSize + ", currentSize=" + this.getFilledUpTo());
        }
        OFile[] newFiles = new OFile[this.files.length + 1];
        for (int i2 = 0; i2 < this.files.length; ++i2) {
            newFiles[i2] = this.files[i2];
        }
        this.files = newFiles;
        file = this.createNewFile();
        file.allocateSpace(iRecordSize);
        this.config.root.update();
        return new long[]{this.files.length - 1, 0L};
    }

    protected long getAbsolutePosition(long[] iFilePosition) {
        long position = 0L;
        int i = 0;
        while ((long)i < iFilePosition[0]) {
            position += (long)this.fileMaxSize;
            ++i;
        }
        return position + iFilePosition[1];
    }

    protected long[] getRelativePosition(long iPosition) {
        if (iPosition < (long)this.fileMaxSize) {
            return new long[]{0L, iPosition};
        }
        int fileNum = (int)(iPosition / (long)this.fileMaxSize);
        if (fileNum >= this.files.length) {
            throw new ODatabaseException("Record position #" + iPosition + " was bound to file #" + fileNum + " that is out of limit (files range 0-" + (this.files.length - 1) + ")");
        }
        int fileRec = (int)(iPosition % (long)this.fileMaxSize);
        if (fileRec >= this.files[fileNum].getFilledUpTo()) {
            throw new ODatabaseException("Record position #" + iPosition + " was bound to file #" + fileNum + " but the position #" + this.files[fileNum].getFilledUpTo() + " is out of file size");
        }
        return new long[]{fileNum, fileRec};
    }

    private OFile createNewFile() throws IOException {
        int num = this.files.length - 1;
        OFile file = OFileFactory.create(this.type, this.storage.getStoragePath() + "/" + this.name + "." + num + this.fileExtension, this.storage.getMode());
        file.setMaxSize((int)OFileUtils.getSizeAsNumber((Object)this.config.root.fileTemplate.fileMaxSize));
        file.create(this.fileStartSize);
        this.files[num] = file;
        this.addInfoFileConfigEntry(file);
        return file;
    }

    private void addInfoFileConfigEntry(OFile file) throws IOException {
        OStorageFileConfiguration[] newConfigFiles = new OStorageFileConfiguration[this.config.infoFiles.length + 1];
        for (int i = 0; i < this.config.infoFiles.length; ++i) {
            newConfigFiles[i] = this.config.infoFiles[i];
        }
        this.config.infoFiles = newConfigFiles;
        String fileNameToStore = this.storage.getVariableParser().convertPathToRelative(OFileUtils.getPath((String)file.getOsFile().getPath()));
        OStorageSegmentConfiguration template = this.config.root.fileTemplate;
        this.config.infoFiles[this.config.infoFiles.length - 1] = new OStorageFileConfiguration(this.config, fileNameToStore, template.fileType, template.fileMaxSize, template.fileIncrementSize);
    }

    public OStorageSegmentConfiguration getConfig() {
        return this.config;
    }
}

