/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local;

import com.orientechnologies.common.concur.resource.OSharedResourceAdaptive;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageFileConfiguration;
import com.orientechnologies.orient.core.storage.fs.OFile;
import com.orientechnologies.orient.core.storage.fs.OFileFactory;
import com.orientechnologies.orient.core.storage.fs.OMMapManager;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocal;
import java.io.IOException;

public class OSingleFileSegment
extends OSharedResourceAdaptive {
    protected OStorageLocal storage;
    protected OFile file;
    protected OStorageFileConfiguration config;

    public OSingleFileSegment(OStorageLocal iStorage, OStorageFileConfiguration iConfig) throws IOException {
        super(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean());
        this.config = iConfig;
        this.storage = iStorage;
        this.file = OFileFactory.create(iConfig.type, iStorage.getVariableParser().resolveVariables(iConfig.path), iStorage.getMode());
        this.file.setMaxSize((int)OFileUtils.getSizeAsNumber((Object)iConfig.maxSize));
        this.file.setIncrementSize((int)OFileUtils.getSizeAsNumber((Object)iConfig.incrementSize));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open() throws IOException {
        this.acquireExclusiveLock();
        try {
            boolean softClosed = this.file.open();
            if (!softClosed) {
                OLogManager.instance().warn((Object)this, "File " + this.file.getOsFile().getAbsolutePath() + " was not closed correctly last time. Checking segments...", new Object[0]);
            }
            boolean bl = softClosed;
            return bl;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(int iStartSize) throws IOException {
        this.acquireExclusiveLock();
        try {
            this.file.create(iStartSize);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.acquireExclusiveLock();
        try {
            if (this.file != null) {
                this.file.close();
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws IOException {
        this.acquireExclusiveLock();
        try {
            if (this.file != null) {
                this.file.delete();
                OMMapManager.removeFile(this.file);
                this.file = null;
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate() throws IOException {
        this.acquireExclusiveLock();
        try {
            this.file.shrink(0);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public long getSize() {
        return this.file.getFileSize();
    }

    public long getFilledUpTo() {
        return this.file.getFilledUpTo();
    }

    public OStorageFileConfiguration getConfig() {
        return this.config;
    }

    public OFile getFile() {
        return this.file;
    }
}

