/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local;

import com.orientechnologies.common.concur.lock.OLockManager;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.common.util.OArrays;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.config.OStorageDataConfiguration;
import com.orientechnologies.orient.core.config.OStorageLogicalClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageMemoryClusterConfiguration;
import com.orientechnologies.orient.core.config.OStoragePhysicalClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageSegmentConfiguration;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.memory.OMemoryWatchDog;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageAbstract;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import com.orientechnologies.orient.core.storage.fs.OMMapManager;
import com.orientechnologies.orient.core.storage.impl.local.OClusterLocal;
import com.orientechnologies.orient.core.storage.impl.local.OClusterLogical;
import com.orientechnologies.orient.core.storage.impl.local.ODataHoleInfo;
import com.orientechnologies.orient.core.storage.impl.local.ODataLocal;
import com.orientechnologies.orient.core.storage.impl.local.OStorageConfigurationSegment;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocalTxExecuter;
import com.orientechnologies.orient.core.storage.impl.local.OStorageVariableParser;
import com.orientechnologies.orient.core.storage.impl.memory.OClusterMemory;
import com.orientechnologies.orient.core.tx.OTransaction;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OStorageLocal
extends OStorageEmbedded {
    private final int DELETE_MAX_RETRIES;
    private final int DELETE_WAIT_TIME;
    public static final String[] TYPES = new String[]{"PHYSICAL", "LOGICAL"};
    private final Map<String, OCluster> clusterMap = new LinkedHashMap<String, OCluster>();
    private OCluster[] clusters = new OCluster[0];
    private ODataLocal[] dataSegments = new ODataLocal[0];
    private final OStorageLocalTxExecuter txManager;
    private String storagePath;
    private final OStorageVariableParser variableParser;
    private int defaultClusterId = -1;
    private OStorageConfigurationSegment configurationSegment;
    private static String[] ALL_FILE_EXTENSIONS = new String[]{"ocf", ".och", ".ocl", ".oda", ".odh", ".otx"};
    private final String PROFILER_CREATE_RECORD;
    private final String PROFILER_READ_RECORD;
    private final String PROFILER_UPDATE_RECORD;
    private final String PROFILER_DELETE_RECORD;

    public OStorageLocal(String iName, String iFilePath, String iMode) throws IOException {
        super(iName, iFilePath, iMode);
        File f = new File(this.url);
        this.storagePath = f.exists() || !this.exists(f.getParent()) ? OSystemVariableResolver.resolveSystemVariables((String)OFileUtils.getPath((String)new File(this.url).getPath())) : OSystemVariableResolver.resolveSystemVariables((String)OFileUtils.getPath((String)new File(this.url).getParent()));
        this.variableParser = new OStorageVariableParser(this.storagePath);
        this.configuration = new OStorageConfigurationSegment(this, this.storagePath);
        this.txManager = new OStorageLocalTxExecuter(this, this.configuration.txSegment);
        this.PROFILER_CREATE_RECORD = "storage." + this.name + ".createRecord";
        this.PROFILER_READ_RECORD = "storage." + this.name + ".readRecord";
        this.PROFILER_UPDATE_RECORD = "storage." + this.name + ".updateRecord";
        this.PROFILER_DELETE_RECORD = "storage." + this.name + ".deleteRecord";
        this.DELETE_MAX_RETRIES = OGlobalConfiguration.FILE_MMAP_FORCE_RETRY.getValueAsInteger();
        this.DELETE_WAIT_TIME = OGlobalConfiguration.FILE_MMAP_FORCE_DELAY.getValueAsInteger();
        this.installProfilerHooks();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void open(String iUserName, String iUserPassword, Map<String, Object> iProperties) {
        long timer;
        block14: {
            block13: {
                timer = OProfiler.getInstance().startChrono();
                this.lock.acquireExclusiveLock();
                try {
                    try {
                        int i;
                        if (this.status != OStorageAbstract.STATUS.CLOSED) {
                            Object var10_5 = null;
                            break block13;
                        }
                        this.addUser();
                        if (!this.exists()) {
                            throw new OStorageException("Can't open the storage '" + this.name + "' because it not exists in path: " + this.url);
                        }
                        this.status = OStorageAbstract.STATUS.OPEN;
                        int pos = this.registerDataSegment(new OStorageDataConfiguration(this.configuration, "default"));
                        this.dataSegments[pos].open();
                        pos = this.createClusterFromConfig(new OStoragePhysicalClusterConfiguration(this.configuration, "internal", this.clusters.length));
                        this.clusters[pos].open();
                        this.configuration.load();
                        pos = this.createClusterFromConfig(new OStoragePhysicalClusterConfiguration(this.configuration, "index", this.clusters.length));
                        this.clusters[pos].open();
                        this.defaultClusterId = this.createClusterFromConfig(new OStoragePhysicalClusterConfiguration(this.configuration, "default", this.clusters.length));
                        this.clusters[this.defaultClusterId].open();
                        for (i = 0; i < this.configuration.dataSegments.size(); ++i) {
                            OStorageDataConfiguration dataConfig = this.configuration.dataSegments.get(i);
                            pos = this.registerDataSegment(dataConfig);
                            if (pos == -1) {
                                this.dataSegments[i].close();
                                this.dataSegments[i] = new ODataLocal(this, dataConfig, pos);
                                this.dataSegments[i].open();
                                continue;
                            }
                            this.dataSegments[pos].open();
                        }
                        for (i = 0; i < this.configuration.clusters.size(); ++i) {
                            OStorageClusterConfiguration clusterConfig = this.configuration.clusters.get(i);
                            if (clusterConfig != null) {
                                pos = this.createClusterFromConfig(clusterConfig);
                                if (pos == -1) {
                                    this.clusters[i].close();
                                    this.clusters[i] = new OClusterLocal(this, (OStoragePhysicalClusterConfiguration)clusterConfig);
                                    this.clusterMap.put(this.clusters[i].getName(), this.clusters[i]);
                                    this.clusters[i].open();
                                    continue;
                                }
                                if (clusterConfig.getName().equals("default")) {
                                    this.defaultClusterId = pos;
                                }
                                this.clusters[pos].open();
                                continue;
                            }
                            this.clusters = Arrays.copyOf(this.clusters, this.clusters.length + 1);
                            this.clusters[i] = null;
                        }
                        this.loadVersion();
                        this.txManager.open();
                        break block14;
                    }
                    catch (Exception e) {
                        this.close(true);
                        throw new OStorageException("Can't open local storage: " + this.url + ", with mode=" + this.mode, e);
                    }
                }
                catch (Throwable throwable) {
                    Object var10_7 = null;
                    this.lock.releaseExclusiveLock();
                    OProfiler.getInstance().stopChrono("storage." + this.name + ".open", timer);
                    throw throwable;
                }
            }
            this.lock.releaseExclusiveLock();
            OProfiler.getInstance().stopChrono("storage." + this.name + ".open", timer);
            return;
        }
        Object var10_6 = null;
        this.lock.releaseExclusiveLock();
        OProfiler.getInstance().stopChrono("storage." + this.name + ".open", timer);
    }

    @Override
    public void create(Map<String, Object> iProperties) {
        long timer = OProfiler.getInstance().startChrono();
        this.lock.acquireExclusiveLock();
        try {
            try {
                if (this.status != OStorageAbstract.STATUS.CLOSED) {
                    throw new OStorageException("Can't create new storage " + this.name + " because it isn't closed");
                }
                this.addUser();
                File storageFolder = new File(this.storagePath);
                if (!storageFolder.exists()) {
                    storageFolder.mkdir();
                }
                if (this.exists()) {
                    throw new OStorageException("Can't create new storage " + this.name + " because it already exists");
                }
                this.status = OStorageAbstract.STATUS.OPEN;
                this.addDataSegment("default");
                this.addCluster("internal", OStorage.CLUSTER_TYPE.PHYSICAL, new Object[0]);
                this.addCluster("index", OStorage.CLUSTER_TYPE.PHYSICAL, new Object[0]);
                this.defaultClusterId = this.addCluster("default", OStorage.CLUSTER_TYPE.PHYSICAL, new Object[0]);
                this.configuration.create();
                this.txManager.create();
            }
            catch (OStorageException e) {
                this.close();
                throw e;
            }
            catch (IOException e) {
                this.close();
                throw new OStorageException("Error on creation of storage: " + this.name, e);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.lock.releaseExclusiveLock();
            OProfiler.getInstance().stopChrono("storage." + this.name + ".create", timer);
            throw throwable;
        }
        this.lock.releaseExclusiveLock();
        OProfiler.getInstance().stopChrono("storage." + this.name + ".create", timer);
    }

    @Override
    public void reload() {
    }

    @Override
    public boolean exists() {
        return this.exists(this.storagePath);
    }

    private boolean exists(String path) {
        return new File(path + "/" + "default" + ".0" + ".oda").exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close(boolean iForce) {
        long timer;
        block9: {
            block8: {
                timer = OProfiler.getInstance().startChrono();
                this.lock.acquireExclusiveLock();
                try {
                    try {
                        if (!this.checkForClose(iForce)) {
                            Object var9_3 = null;
                            break block8;
                        }
                        this.status = OStorageAbstract.STATUS.CLOSING;
                        this.saveVersion();
                        for (OCluster oCluster : this.clusters) {
                            if (oCluster == null) continue;
                            oCluster.close();
                        }
                        this.clusters = new OCluster[0];
                        this.clusterMap.clear();
                        for (ODataLocal oDataLocal : this.dataSegments) {
                            oDataLocal.close();
                        }
                        this.dataSegments = new ODataLocal[0];
                        this.txManager.close();
                        this.configuration.close();
                        this.level2Cache.shutdown();
                        OMMapManager.flush();
                        super.close(iForce);
                        Orient.instance().unregisterStorage(this);
                        this.status = OStorageAbstract.STATUS.CLOSED;
                        break block9;
                    }
                    catch (IOException iOException) {
                        OLogManager.instance().error((Object)this, "Error on closing of the storage '" + this.name, (Throwable)iOException, OStorageException.class, new Object[0]);
                        Object var9_5 = null;
                        this.lock.releaseExclusiveLock();
                        OProfiler.getInstance().stopChrono("storage." + this.name + ".close", timer);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_6 = null;
                    this.lock.releaseExclusiveLock();
                    OProfiler.getInstance().stopChrono("storage." + this.name + ".close", timer);
                    throw throwable;
                }
            }
            this.lock.releaseExclusiveLock();
            OProfiler.getInstance().stopChrono("storage." + this.name + ".close", timer);
            return;
        }
        Object var9_4 = null;
        this.lock.releaseExclusiveLock();
        OProfiler.getInstance().stopChrono("storage." + this.name + ".close", timer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void delete() {
        long timer;
        block11: {
            block12: {
                if (this.status != OStorageAbstract.STATUS.CLOSED && this.getUsers() > 0) {
                    while (this.removeUser() > 0) {
                    }
                }
                this.close(true);
                try {
                    Orient.instance().unregisterStorage(this);
                }
                catch (Exception e) {
                    OLogManager.instance().error((Object)this, "Can't unregister storage", (Throwable)e, new Object[0]);
                }
                timer = OProfiler.getInstance().startChrono();
                File dbDir = new File(OSystemVariableResolver.resolveSystemVariables((String)this.url));
                if (!dbDir.exists() || !dbDir.isDirectory()) {
                    dbDir = dbDir.getParentFile();
                }
                this.lock.acquireExclusiveLock();
                try {
                    int i = 0;
                    while (i < this.DELETE_MAX_RETRIES) {
                        if (!dbDir.exists() || !dbDir.isDirectory()) break block11;
                        int notDeletedFiles = 0;
                        block6: for (File f : dbDir.listFiles()) {
                            for (String ext : ALL_FILE_EXTENSIONS) {
                                if (!f.getPath().endsWith(ext)) continue;
                                if (f.delete()) continue block6;
                                ++notDeletedFiles;
                                continue block6;
                            }
                        }
                        if (notDeletedFiles == 0) {
                            dbDir.delete();
                            Object var15_14 = null;
                            break block12;
                        }
                        OLogManager.instance().debug((Object)this, "Can't delete database files because are locked by the OrientDB process yet: waiting a %d ms and retry %d/%d...", new Object[]{this.DELETE_WAIT_TIME, i, this.DELETE_MAX_RETRIES});
                        OMemoryWatchDog.freeMemory(this.DELETE_WAIT_TIME);
                        ++i;
                    }
                    throw new OStorageException("Can't delete database '" + this.name + "' located in: " + dbDir + ". Database files seems locked");
                }
                catch (Throwable throwable) {
                    Object var15_16 = null;
                    this.lock.releaseExclusiveLock();
                    OProfiler.getInstance().stopChrono("storage." + this.name + ".delete", timer);
                    throw throwable;
                }
            }
            this.lock.releaseExclusiveLock();
            OProfiler.getInstance().stopChrono("storage." + this.name + ".delete", timer);
            return;
        }
        Object var15_15 = null;
        this.lock.releaseExclusiveLock();
        OProfiler.getInstance().stopChrono("storage." + this.name + ".delete", timer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODataLocal getDataSegment(int iDataSegmentId) {
        ODataLocal oDataLocal;
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            if (iDataSegmentId >= this.dataSegments.length) {
                throw new IllegalArgumentException("Data segment #" + iDataSegmentId + " doesn't exist in current storage");
            }
            oDataLocal = this.dataSegments[iDataSegmentId];
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
        this.lock.releaseSharedLock();
        return oDataLocal;
    }

    @Override
    public int addDataSegment(String iDataSegmentName) {
        String segmentFileName = this.storagePath + "/" + iDataSegmentName;
        return this.addDataSegment(iDataSegmentName, segmentFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addDataSegment(String iSegmentName, String iSegmentFileName) {
        int n;
        this.checkOpeness();
        iSegmentName = iSegmentName.toLowerCase();
        this.lock.acquireExclusiveLock();
        try {
            OStorageDataConfiguration conf = new OStorageDataConfiguration(this.configuration, iSegmentName);
            this.configuration.dataSegments.add(conf);
            int pos = this.registerDataSegment(conf);
            if (pos == -1) {
                throw new OConfigurationException("Can't add segment " + conf.name + " because it's already part of current storage");
            }
            this.dataSegments[pos].create(-1);
            this.configuration.update();
            n = pos;
            Object var7_8 = null;
        }
        catch (Throwable e) {
            int n2;
            try {
                OLogManager.instance().error((Object)this, "Error on creation of new data segment '" + iSegmentName + "' in: " + iSegmentFileName, e, OStorageException.class, new Object[0]);
                n2 = -1;
                Object var7_9 = null;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                this.lock.releaseExclusiveLock();
                throw throwable;
            }
            this.lock.releaseExclusiveLock();
            return n2;
        }
        this.lock.releaseExclusiveLock();
        return n;
    }

    @Override
    public int addCluster(String iClusterName, OStorage.CLUSTER_TYPE iClusterType, Object ... iParameters) {
        this.checkOpeness();
        try {
            iClusterName = iClusterName != null ? iClusterName.toLowerCase() : null;
            switch (iClusterType) {
                case PHYSICAL: {
                    String clusterFileName = (String)(iParameters.length < 1 ? this.storagePath + "/" + iClusterName : iParameters[0]);
                    int startSize = iParameters.length < 2 ? -1 : (Integer)iParameters[1];
                    return this.addPhysicalCluster(iClusterName, clusterFileName, startSize);
                }
                case LOGICAL: {
                    int physicalClusterId = iParameters.length < 1 ? this.getClusterIdByName("internal") : ((Integer)iParameters[0]).intValue();
                    return this.addLogicalCluster(iClusterName, physicalClusterId);
                }
                case MEMORY: {
                    return this.addMemoryCluster(iClusterName);
                }
            }
            OLogManager.instance().exception("Cluster type '" + (Object)((Object)iClusterType) + "' is not supported. Supported types are: " + Arrays.toString(TYPES), null, OStorageException.class, new Object[0]);
        }
        catch (Exception e) {
            OLogManager.instance().exception("Error in creation of new cluster '" + iClusterName + "' of type: " + (Object)((Object)iClusterType), e, OStorageException.class, new Object[0]);
        }
        return -1;
    }

    public ODataLocal[] getDataSegments() {
        return this.dataSegments;
    }

    public OStorageLocalTxExecuter getTxManager() {
        return this.txManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean dropCluster(int iClusterId) {
        boolean bl;
        OCluster cluster;
        block6: {
            this.lock.acquireExclusiveLock();
            if (iClusterId < 0 || iClusterId >= this.clusters.length) {
                throw new IllegalArgumentException("Cluster id '" + iClusterId + "' is out of range of configured clusters (0-" + (this.clusters.length - 1) + ")");
            }
            cluster = this.clusters[iClusterId];
            if (cluster != null) break block6;
            boolean bl2 = false;
            Object var5_6 = null;
            this.lock.releaseExclusiveLock();
            return bl2;
        }
        try {
            this.getLevel2Cache().freeCluster(iClusterId);
            cluster.delete();
            this.clusterMap.remove(cluster.getName());
            this.clusters[iClusterId] = null;
            this.configuration.clusters.set(iClusterId, null);
            this.configuration.update();
            bl = true;
            Object var5_7 = null;
        }
        catch (Exception e) {
            try {
                OLogManager.instance().exception("Error while removing cluster '" + iClusterId + "'", e, OStorageException.class, new Object[0]);
                Object var5_8 = null;
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                this.lock.releaseExclusiveLock();
                throw throwable;
            }
            this.lock.releaseExclusiveLock();
            return false;
        }
        this.lock.releaseExclusiveLock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count(int[] iClusterIds) {
        long l;
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            long tot = 0L;
            for (int i = 0; i < iClusterIds.length; ++i) {
                if (iClusterIds[i] >= this.clusters.length) {
                    throw new OConfigurationException("Cluster id " + iClusterIds[i] + "was not found");
                }
                OCluster c = this.clusters[iClusterIds[i]];
                if (c == null) continue;
                tot += c.getEntries();
            }
            l = tot;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
        this.lock.releaseSharedLock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getClusterDataRange(int iClusterId) {
        long[] lArray;
        if (iClusterId == -1) {
            throw new OStorageException("Cluster Id is invalid: " + iClusterId);
        }
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            long[] lArray2;
            if (this.clusters[iClusterId] != null) {
                long[] lArray3 = new long[2];
                lArray3[0] = this.clusters[iClusterId].getFirstEntryPosition();
                lArray2 = lArray3;
                lArray3[1] = this.clusters[iClusterId].getLastEntryPosition();
            } else {
                lArray2 = new long[]{};
            }
            lArray = lArray2;
            Object var5_4 = null;
        }
        catch (IOException e) {
            long[] lArray4;
            try {
                OLogManager.instance().error((Object)this, "Error on getting last entry position", (Throwable)e, new Object[0]);
                lArray4 = null;
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.lock.releaseSharedLock();
                throw throwable;
            }
            this.lock.releaseSharedLock();
            return lArray4;
        }
        this.lock.releaseSharedLock();
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count(int iClusterId) {
        long l;
        if (iClusterId == -1) {
            throw new OStorageException("Cluster Id is invalid: " + iClusterId);
        }
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            l = this.clusters[iClusterId] != null ? this.clusters[iClusterId].getEntries() : 0L;
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
        this.lock.releaseSharedLock();
        return l;
    }

    @Override
    public long createRecord(ORecordId iRid, byte[] iContent, byte iRecordType) {
        this.checkOpeness();
        iRid.clusterPosition = this.createRecord(this.getClusterById(iRid.clusterId), iContent, iRecordType);
        return iRid.clusterPosition;
    }

    @Override
    public ORawBuffer readRecord(ODatabaseRecord iDatabase, ORecordId iRid, String iFetchPlan) {
        this.checkOpeness();
        return this.readRecord(this.getClusterById(iRid.clusterId), iRid, true);
    }

    @Override
    public int updateRecord(ORecordId iRid, byte[] iContent, int iVersion, byte iRecordType) {
        this.checkOpeness();
        return this.updateRecord(this.getClusterById(iRid.clusterId), iRid, iContent, iVersion, iRecordType);
    }

    @Override
    public boolean deleteRecord(ORecordId iRid, int iVersion) {
        this.checkOpeness();
        return this.deleteRecord(this.getClusterById(iRid.clusterId), iRid, iVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getClusterNames() {
        Set<String> set;
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            set = this.clusterMap.keySet();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
        this.lock.releaseSharedLock();
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getClusterIdByName(String iClusterName) {
        block6: {
            int n;
            this.checkOpeness();
            if (iClusterName == null) {
                throw new IllegalArgumentException("Cluster name is null");
            }
            if (iClusterName.length() == 0) {
                throw new IllegalArgumentException("Cluster name is empty");
            }
            if (Character.isDigit(iClusterName.charAt(0))) {
                return Integer.parseInt(iClusterName);
            }
            this.lock.acquireSharedLock();
            try {
                OCluster segment = this.clusterMap.get(iClusterName.toLowerCase());
                if (segment == null) break block6;
                n = segment.getId();
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.lock.releaseSharedLock();
                throw throwable;
            }
            this.lock.releaseSharedLock();
            return n;
        }
        Object var5_5 = null;
        this.lock.releaseSharedLock();
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getClusterTypeByName(String iClusterName) {
        block4: {
            String string;
            this.checkOpeness();
            if (iClusterName == null) {
                throw new IllegalArgumentException("Cluster name is null");
            }
            this.lock.acquireSharedLock();
            try {
                OCluster segment = this.clusterMap.get(iClusterName.toLowerCase());
                if (segment == null) break block4;
                string = segment.getType();
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.lock.releaseSharedLock();
                throw throwable;
            }
            this.lock.releaseSharedLock();
            return string;
        }
        Object var5_5 = null;
        this.lock.releaseSharedLock();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(OTransaction iTx) {
        this.lock.acquireExclusiveLock();
        try {
            try {
                this.txManager.commitAllPendingRecords(iTx);
                this.incrementVersion();
                if (OGlobalConfiguration.TX_COMMIT_SYNCH.getValueAsBoolean()) {
                    this.synch();
                }
            }
            catch (RuntimeException e) {
                this.rollback(iTx);
                throw e;
            }
            catch (IOException e) {
                this.rollback(iTx);
                throw new OException((Throwable)e);
            }
            try {
                this.txManager.clearLogEntries(iTx);
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Clear tx log entries failed", (Throwable)e, new Object[0]);
            }
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.lock.releaseExclusiveLock();
            throw throwable;
        }
        this.lock.releaseExclusiveLock();
    }

    @Override
    public void rollback(OTransaction iTx) {
        try {
            this.txManager.getTxSegment().rollback(iTx);
            if (OGlobalConfiguration.TX_COMMIT_SYNCH.getValueAsBoolean()) {
                this.synch();
            }
        }
        catch (IOException ioe) {
            OLogManager.instance().error((Object)this, "Error executing rollback for transaction with id '" + iTx.getId() + "' cause: " + ioe.getMessage(), (Throwable)ioe, new Object[0]);
        }
    }

    @Override
    public void synch() {
        this.checkOpeness();
        long timer = OProfiler.getInstance().startChrono();
        this.lock.acquireExclusiveLock();
        try {
            try {
                this.saveVersion();
                for (OCluster oCluster : this.clusters) {
                    if (oCluster == null) continue;
                    oCluster.synch();
                }
                for (ODataLocal oDataLocal : this.dataSegments) {
                    if (oDataLocal == null) continue;
                    oDataLocal.synch();
                }
                Object var8_10 = null;
            }
            catch (IOException iOException) {
                throw new OStorageException("Error on synch", iOException);
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this.lock.releaseExclusiveLock();
            OProfiler.getInstance().stopChrono("storage." + this.name + ".synch", timer);
            throw throwable;
        }
        this.lock.releaseExclusiveLock();
        OProfiler.getInstance().stopChrono("storage." + this.name + ".synch", timer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ODataHoleInfo> getHolesList() {
        ArrayList<ODataHoleInfo> arrayList;
        ArrayList<ODataHoleInfo> holes = new ArrayList<ODataHoleInfo>();
        this.lock.acquireSharedLock();
        try {
            for (ODataLocal d : this.dataSegments) {
                holes.addAll(d.getHolesList());
            }
            arrayList = holes;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
        this.lock.releaseSharedLock();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHoles() {
        long l;
        this.lock.acquireSharedLock();
        try {
            long holes = 0L;
            for (ODataLocal d : this.dataSegments) {
                holes += d.getHoles();
            }
            l = holes;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
        this.lock.releaseSharedLock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHoleSize() {
        long l;
        this.lock.acquireSharedLock();
        try {
            List<ODataHoleInfo> holes = this.getHolesList();
            long size = 0L;
            for (ODataHoleInfo h : holes) {
                if (h.dataOffset <= -1L || h.size <= 0) continue;
                size += (long)h.size;
            }
            l = size;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
        this.lock.releaseSharedLock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPhysicalClusterNameById(int iClusterId) {
        block3: {
            String string;
            this.checkOpeness();
            this.lock.acquireSharedLock();
            try {
                if (iClusterId < this.clusters.length) break block3;
                string = null;
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.lock.releaseSharedLock();
                throw throwable;
            }
            this.lock.releaseSharedLock();
            return string;
        }
        String string = this.clusters[iClusterId] != null ? this.clusters[iClusterId].getName() : null;
        Object var4_5 = null;
        this.lock.releaseSharedLock();
        return string;
    }

    @Override
    public OStorageConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public int getDefaultClusterId() {
        return this.defaultClusterId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCluster getClusterById(int iClusterId) {
        OCluster oCluster;
        this.lock.acquireSharedLock();
        try {
            if (iClusterId == -1) {
                iClusterId = this.defaultClusterId;
            }
            this.checkClusterSegmentIndexRange(iClusterId);
            oCluster = this.clusters[iClusterId];
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
        this.lock.releaseSharedLock();
        return oCluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCluster getClusterByName(String iClusterName) {
        OCluster oCluster;
        this.lock.acquireSharedLock();
        try {
            OCluster cluster = this.clusterMap.get(iClusterName.toLowerCase());
            if (cluster == null) {
                throw new IllegalArgumentException("Cluster " + iClusterName + " not exists");
            }
            oCluster = cluster;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
        this.lock.releaseSharedLock();
        return oCluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSize() {
        long l;
        this.lock.acquireSharedLock();
        try {
            long size = 0L;
            for (ODataLocal oDataLocal : this.dataSegments) {
                if (oDataLocal == null) continue;
                size += oDataLocal.getFilledUpTo();
            }
            for (OCluster oCluster : this.clusters) {
                if (oCluster == null) continue;
                size += oCluster.getSize();
            }
            l = size;
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
        this.lock.releaseSharedLock();
        return l;
    }

    public OStorageConfigurationSegment getConfigurationSegment() {
        return this.configurationSegment;
    }

    public String getStoragePath() {
        return this.storagePath;
    }

    public String getMode() {
        return this.mode;
    }

    public OStorageVariableParser getVariableParser() {
        return this.variableParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getClusters() {
        int n;
        this.lock.acquireSharedLock();
        try {
            n = this.clusters.length;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
        this.lock.releaseSharedLock();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OCluster> getClusterInstances() {
        HashSet<OCluster> result = new HashSet<OCluster>();
        this.lock.acquireSharedLock();
        try {
            for (OCluster c : this.clusters) {
                result.add(c);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
        this.lock.releaseSharedLock();
        return result;
    }

    @Override
    public void renameCluster(String iOldName, String iNewName) {
        this.clusterMap.put(iNewName, this.clusterMap.remove(iOldName));
    }

    protected int registerDataSegment(OStorageDataConfiguration iConfig) throws IOException {
        this.checkOpeness();
        int pos = 0;
        for (ODataLocal data : this.dataSegments) {
            if (!data.getName().equals(iConfig.name)) continue;
            data.config = iConfig;
            return -1;
        }
        pos = this.dataSegments.length;
        ODataLocal segment = new ODataLocal(this, iConfig, pos);
        this.dataSegments = (ODataLocal[])OArrays.copyOf((Object[])this.dataSegments, (int)(this.dataSegments.length + 1));
        this.dataSegments[pos] = segment;
        return pos;
    }

    private int createClusterFromConfig(OStorageClusterConfiguration iConfig) throws IOException {
        OCluster cluster = this.clusterMap.get(iConfig.getName());
        if (cluster != null) {
            if (cluster instanceof OClusterLocal) {
                ((OClusterLocal)cluster).config = (OStorageSegmentConfiguration)((Object)iConfig);
            }
            return -1;
        }
        cluster = iConfig instanceof OStoragePhysicalClusterConfiguration ? new OClusterLocal(this, (OStoragePhysicalClusterConfiguration)iConfig) : new OClusterLogical(this, (OStorageLogicalClusterConfiguration)iConfig);
        return this.registerCluster(cluster);
    }

    private int registerCluster(OCluster iCluster) throws IOException {
        int id;
        if (iCluster != null) {
            if (this.clusterMap.containsKey(iCluster.getName())) {
                throw new OConfigurationException("Can't add segment '" + iCluster.getName() + "' because it was already registered");
            }
            this.clusterMap.put(iCluster.getName(), iCluster);
            id = iCluster.getId();
        } else {
            id = this.clusters.length;
        }
        this.clusters = (OCluster[])OArrays.copyOf((Object[])this.clusters, (int)(this.clusters.length + 1));
        this.clusters[id] = iCluster;
        return id;
    }

    private void checkClusterSegmentIndexRange(int iClusterId) {
        if (iClusterId > this.clusters.length - 1) {
            throw new IllegalArgumentException("Cluster segment #" + iClusterId + " not exists");
        }
    }

    protected int getDataSegmentForRecord(OCluster iCluster, byte[] iContent) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long createRecord(OCluster iClusterSegment, byte[] iContent, byte iRecordType) {
        long l;
        this.checkOpeness();
        if (iContent == null) {
            throw new IllegalArgumentException("Record is null");
        }
        long timer = OProfiler.getInstance().startChrono();
        this.lock.acquireSharedLock();
        try {
            try {
                this.lockManager.acquireLock((Object)Thread.currentThread(), (Object)ORecordId.EMPTY_RECORD_ID, OLockManager.LOCK.EXCLUSIVE);
                try {
                    int dataSegment = this.getDataSegmentForRecord(iClusterSegment, iContent);
                    ODataLocal data = this.getDataSegment(dataSegment);
                    ORecordId rid = new ORecordId(iClusterSegment.getId());
                    rid.clusterPosition = iClusterSegment.addPhysicalPosition(-1, -1L, iRecordType);
                    long dataOffset = data.addRecord(rid, iContent);
                    iClusterSegment.setPhysicalPosition(rid.clusterPosition, dataSegment, dataOffset, iRecordType, 0);
                    this.incrementVersion();
                    l = rid.clusterPosition;
                    Object var14_12 = null;
                }
                catch (Throwable throwable) {
                    Object var14_13 = null;
                    this.lockManager.releaseLock((Object)Thread.currentThread(), (Object)ORecordId.EMPTY_RECORD_ID, OLockManager.LOCK.EXCLUSIVE);
                    throw throwable;
                }
                this.lockManager.releaseLock((Object)Thread.currentThread(), (Object)ORecordId.EMPTY_RECORD_ID, OLockManager.LOCK.EXCLUSIVE);
                Object var16_14 = null;
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "Error on creating record in cluster: " + iClusterSegment, (Throwable)e, new Object[0]);
                long l2 = -1L;
                Object var16_15 = null;
                this.lock.releaseSharedLock();
                OProfiler.getInstance().stopChrono(this.PROFILER_CREATE_RECORD, timer);
                return l2;
            }
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            this.lock.releaseSharedLock();
            OProfiler.getInstance().stopChrono(this.PROFILER_CREATE_RECORD, timer);
            throw throwable;
        }
        this.lock.releaseSharedLock();
        OProfiler.getInstance().stopChrono(this.PROFILER_CREATE_RECORD, timer);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected ORawBuffer readRecord(OCluster iClusterSegment, ORecordId iRid, boolean iAtomicLock) {
        if (iRid.clusterPosition < 0L) {
            throw new IllegalArgumentException("Can't read the record " + iRid + " since the position is invalid");
        }
        long timer = OProfiler.getInstance().startChrono();
        if (iAtomicLock) {
            this.lock.acquireSharedLock();
        }
        try {
            try {
                OPhysicalPosition ppos;
                block14: {
                    ORawBuffer oRawBuffer;
                    this.lockManager.acquireLock((Object)Thread.currentThread(), (Object)iRid, OLockManager.LOCK.SHARED);
                    try {
                        long lastPos = iClusterSegment.getLastEntryPosition();
                        if (iRid.clusterPosition > lastPos) {
                            throw new ORecordNotFoundException("Record " + iRid + " is out cluster size. Valid range for cluster '" + iClusterSegment.getName() + "' is 0-" + lastPos);
                        }
                        ppos = iClusterSegment.getPhysicalPosition(iRid.clusterPosition, new OPhysicalPosition());
                        if (ppos != null && this.checkForRecordValidity(ppos)) break block14;
                        oRawBuffer = null;
                        Object var12_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var12_12 = null;
                        this.lockManager.releaseLock((Object)Thread.currentThread(), (Object)iRid, OLockManager.LOCK.SHARED);
                        throw throwable;
                    }
                    this.lockManager.releaseLock((Object)Thread.currentThread(), (Object)iRid, OLockManager.LOCK.SHARED);
                    Object var14_13 = null;
                    if (iAtomicLock) {
                        this.lock.releaseSharedLock();
                    }
                    OProfiler.getInstance().stopChrono(this.PROFILER_READ_RECORD, timer);
                    return oRawBuffer;
                }
                ODataLocal data = this.getDataSegment(ppos.dataSegment);
                ORawBuffer oRawBuffer = new ORawBuffer(data.getRecord(ppos.dataPosition), ppos.version, ppos.type);
                Object var12_11 = null;
                this.lockManager.releaseLock((Object)Thread.currentThread(), (Object)iRid, OLockManager.LOCK.SHARED);
                Object var14_14 = null;
                if (iAtomicLock) {
                    this.lock.releaseSharedLock();
                }
                OProfiler.getInstance().stopChrono(this.PROFILER_READ_RECORD, timer);
                return oRawBuffer;
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "Error on reading record " + iRid + " (cluster: " + iClusterSegment + ")", (Throwable)e, new Object[0]);
                ORawBuffer oRawBuffer = null;
                Object var14_15 = null;
                if (iAtomicLock) {
                    this.lock.releaseSharedLock();
                }
                OProfiler.getInstance().stopChrono(this.PROFILER_READ_RECORD, timer);
                return oRawBuffer;
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            if (iAtomicLock) {
                this.lock.releaseSharedLock();
            }
            OProfiler.getInstance().stopChrono(this.PROFILER_READ_RECORD, timer);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int updateRecord(OCluster iClusterSegment, ORecordId iRid, byte[] iContent, int iVersion, byte iRecordType) {
        long timer = OProfiler.getInstance().startChrono();
        this.lock.acquireExclusiveLock();
        try {
            try {
                OPhysicalPosition ppos;
                block10: {
                    int n;
                    this.lockManager.acquireLock((Object)Thread.currentThread(), (Object)iRid, OLockManager.LOCK.EXCLUSIVE);
                    try {
                        ppos = iClusterSegment.getPhysicalPosition(iRid.clusterPosition, new OPhysicalPosition());
                        if (this.checkForRecordValidity(ppos)) break block10;
                        n = -1;
                        Object var13_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var13_13 = null;
                        this.lockManager.releaseLock((Object)Thread.currentThread(), (Object)iRid, OLockManager.LOCK.EXCLUSIVE);
                        throw throwable;
                    }
                    this.lockManager.releaseLock((Object)Thread.currentThread(), (Object)iRid, OLockManager.LOCK.EXCLUSIVE);
                    Object var15_14 = null;
                    this.lock.releaseExclusiveLock();
                    OProfiler.getInstance().stopChrono(this.PROFILER_UPDATE_RECORD, timer);
                    return n;
                }
                if (iVersion > -1 && iVersion != ppos.version) {
                    throw new OConcurrentModificationException("Can't update record " + iRid + " because the version is not the latest one. Probably you are updating an old record or it has been modified by another user (db=v" + ppos.version + " your=v" + iVersion + ")");
                }
                if (ppos.type != iRecordType) {
                    iClusterSegment.updateRecordType(iRid.clusterPosition, iRecordType);
                }
                iClusterSegment.updateVersion(iRid.clusterPosition, ++ppos.version);
                long newDataSegmentOffset = ppos.dataPosition == -1L ? this.getDataSegment(ppos.dataSegment).addRecord(iRid, iContent) : this.getDataSegment(ppos.dataSegment).setRecord(ppos.dataPosition, iRid, iContent);
                if (newDataSegmentOffset != ppos.dataPosition) {
                    iClusterSegment.setPhysicalPosition(iRid.clusterPosition, ppos.dataSegment, newDataSegmentOffset, iRecordType, ppos.version);
                }
                this.incrementVersion();
                int n = ppos.version;
                Object var13_12 = null;
                this.lockManager.releaseLock((Object)Thread.currentThread(), (Object)iRid, OLockManager.LOCK.EXCLUSIVE);
                Object var15_15 = null;
                this.lock.releaseExclusiveLock();
                OProfiler.getInstance().stopChrono(this.PROFILER_UPDATE_RECORD, timer);
                return n;
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "Error on updating record " + iRid + " (cluster: " + iClusterSegment + ")", (Throwable)e, new Object[0]);
                Object var15_16 = null;
                this.lock.releaseExclusiveLock();
                OProfiler.getInstance().stopChrono(this.PROFILER_UPDATE_RECORD, timer);
                return -1;
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            this.lock.releaseExclusiveLock();
            OProfiler.getInstance().stopChrono(this.PROFILER_UPDATE_RECORD, timer);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean deleteRecord(OCluster iClusterSegment, ORecordId iRid, int iVersion) {
        long timer = OProfiler.getInstance().startChrono();
        this.lock.acquireExclusiveLock();
        try {
            try {
                OPhysicalPosition ppos;
                block9: {
                    boolean bl;
                    this.lockManager.acquireLock((Object)Thread.currentThread(), (Object)iRid, OLockManager.LOCK.EXCLUSIVE);
                    try {
                        ppos = iClusterSegment.getPhysicalPosition(iRid.clusterPosition, new OPhysicalPosition());
                        if (this.checkForRecordValidity(ppos)) break block9;
                        bl = false;
                        Object var9_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_11 = null;
                        this.lockManager.releaseLock((Object)Thread.currentThread(), (Object)iRid, OLockManager.LOCK.EXCLUSIVE);
                        throw throwable;
                    }
                    this.lockManager.releaseLock((Object)Thread.currentThread(), (Object)iRid, OLockManager.LOCK.EXCLUSIVE);
                    Object var11_12 = null;
                    this.lock.releaseExclusiveLock();
                    OProfiler.getInstance().stopChrono(this.PROFILER_DELETE_RECORD, timer);
                    return bl;
                }
                if (iVersion > -1 && ppos.version != iVersion) {
                    throw new OConcurrentModificationException("Can't delete the record " + iRid + " because the version is not the latest one. Probably you are deleting an old record or it has been modified by another user (db=v" + ppos.version + " your=v" + iVersion + ")");
                }
                iClusterSegment.removePhysicalPosition(iRid.clusterPosition, ppos);
                if (ppos.dataPosition > -1L) {
                    this.getDataSegment(ppos.dataSegment).deleteRecord(ppos.dataPosition);
                }
                this.incrementVersion();
                boolean bl = true;
                Object var9_10 = null;
                this.lockManager.releaseLock((Object)Thread.currentThread(), (Object)iRid, OLockManager.LOCK.EXCLUSIVE);
                Object var11_13 = null;
                this.lock.releaseExclusiveLock();
                OProfiler.getInstance().stopChrono(this.PROFILER_DELETE_RECORD, timer);
                return bl;
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "Error on deleting record " + iRid + "( cluster: " + iClusterSegment + ")", (Throwable)e, new Object[0]);
                Object var11_14 = null;
                this.lock.releaseExclusiveLock();
                OProfiler.getInstance().stopChrono(this.PROFILER_DELETE_RECORD, timer);
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            this.lock.releaseExclusiveLock();
            OProfiler.getInstance().stopChrono(this.PROFILER_DELETE_RECORD, timer);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveVersion() throws IOException {
        this.lock.acquireExclusiveLock();
        try {
            this.dataSegments[0].saveVersion(this.version.get());
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.lock.releaseExclusiveLock();
            throw throwable;
        }
        this.lock.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long loadVersion() throws IOException {
        long l;
        this.lock.acquireExclusiveLock();
        try {
            long v = this.dataSegments[0].loadVersion();
            this.version.set(v);
            l = v;
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            this.lock.releaseExclusiveLock();
            throw throwable;
        }
        this.lock.releaseExclusiveLock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addPhysicalCluster(String iClusterName, String iClusterFileName, int iStartSize) throws IOException {
        int n;
        this.lock.acquireExclusiveLock();
        try {
            OClusterLocal cluster;
            if (iClusterName != null) {
                OStoragePhysicalClusterConfiguration config = new OStoragePhysicalClusterConfiguration(this.configuration, iClusterName, this.clusters.length);
                this.configuration.clusters.add(config);
                cluster = new OClusterLocal(this, config);
            } else {
                cluster = null;
            }
            int id = this.registerCluster(cluster);
            if (iClusterName != null) {
                this.clusters[id].create(iStartSize);
                this.configuration.update();
            }
            n = id;
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.lock.releaseExclusiveLock();
            throw throwable;
        }
        this.lock.releaseExclusiveLock();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private int addLogicalCluster(String iClusterName, int iPhysicalCluster) throws IOException {
        int n;
        this.lock.acquireExclusiveLock();
        try {
            OClusterLogical cluster;
            if (iClusterName != null) {
                OStorageLogicalClusterConfiguration config = new OStorageLogicalClusterConfiguration(iClusterName, this.clusters.length, iPhysicalCluster, null);
                this.configuration.clusters.add(config);
                cluster = new OClusterLogical(this, this.clusters.length, iClusterName, iPhysicalCluster);
                config.map = cluster.getRID();
            } else {
                cluster = null;
            }
            int id = this.registerCluster(cluster);
            if (iClusterName != null) {
                this.configuration.update();
            }
            n = id;
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.lock.releaseExclusiveLock();
            throw throwable;
        }
        this.lock.releaseExclusiveLock();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addMemoryCluster(String iClusterName) throws IOException {
        int n;
        this.lock.acquireExclusiveLock();
        try {
            OClusterMemory cluster;
            if (iClusterName != null) {
                OStorageMemoryClusterConfiguration config = new OStorageMemoryClusterConfiguration(iClusterName, this.clusters.length);
                this.configuration.clusters.add(config);
                cluster = new OClusterMemory(this.clusters.length, iClusterName);
            } else {
                cluster = null;
            }
            int id = this.registerCluster(cluster);
            if (iClusterName != null) {
                this.configuration.update();
            }
            n = id;
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.lock.releaseExclusiveLock();
            throw throwable;
        }
        this.lock.releaseExclusiveLock();
        return n;
    }

    private void installProfilerHooks() {
        OProfiler.getInstance().registerHookValue("storage." + this.name + ".data.holes", new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return OStorageLocal.this.getHoles();
            }
        });
        OProfiler.getInstance().registerHookValue("storage." + this.name + ".data.holeSize", new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return OStorageLocal.this.getHoleSize();
            }
        });
    }
}

