/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OStorageTxConfiguration;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.impl.local.OClusterLocal;
import com.orientechnologies.orient.core.storage.impl.local.ODataLocal;
import com.orientechnologies.orient.core.storage.impl.local.OSingleFileSegment;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocal;
import com.orientechnologies.orient.core.tx.OTransaction;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OTxSegment
extends OSingleFileSegment {
    public static final byte STATUS_FREE = 0;
    public static final byte STATUS_COMMITTING = 1;
    public static final byte OPERATION_CREATE = 0;
    public static final byte OPERATION_DELETE = 1;
    public static final byte OPERATION_UPDATE = 2;
    private static final int DEF_START_SIZE = 262144;
    private static final int RECORD_SIZE = 32;

    public OTxSegment(OStorageLocal iStorage, OStorageTxConfiguration iConfig) throws IOException {
        super(iStorage, iConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean open() throws IOException {
        this.acquireExclusiveLock();
        try {
            super.open();
            int size = this.file.getFilledUpTo() / 32;
            if (size == 0) {
                boolean bl = true;
                return bl;
            }
            this.recoverTransactions();
            boolean bl = true;
            return bl;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void create(int iStartSize) throws IOException {
        super.create(iStartSize > -1 ? iStartSize : 262144);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLog(byte iOperation, int iTxId, int iClusterId, long iPosition, int iDataId, long iDataOffset, int iRecordVersion) throws IOException {
        this.acquireExclusiveLock();
        try {
            int offset = this.file.allocateSpace(32);
            this.file.writeByte(offset, (byte)1);
            this.file.writeByte(++offset, iOperation);
            this.file.writeInt(++offset, iTxId);
            this.file.writeShort(offset += 4, (short)iClusterId);
            this.file.writeLong(offset += 2, iPosition);
            this.file.writeInt(offset += 8, iDataId);
            this.file.writeLong(offset += 4, iDataOffset);
            this.file.writeInt(offset += 8, iRecordVersion);
            this.synchRecord();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLogEntries(int iTxId) throws IOException {
        this.acquireExclusiveLock();
        try {
            int txId;
            byte status;
            int offset;
            int size = this.file.getFilledUpTo() / 32;
            int recordFreed = 0;
            ORecordId rid = new ORecordId();
            for (int i = 0; i < size; ++i) {
                offset = i * 32;
                status = this.file.readByte(offset);
                ++offset;
                if (status != 1) continue;
                byte operation = this.file.readByte(offset);
                if ((txId = this.file.readInt(++offset)) != iTxId) continue;
                rid.clusterId = this.file.readShort(offset += 4);
                rid.clusterPosition = this.file.readLong(offset += 2);
                int oldDataId = this.file.readInt(offset += 8);
                long oldDataOffset = this.file.readLong(offset += 4);
                this.finalizeTransactionEntry(operation, rid, oldDataId, oldDataOffset);
                this.file.writeByte(offset += 8, (byte)0);
                ++recordFreed;
            }
            int lastRecord = size - 1;
            int i = size - 1;
            while (i > -1 && recordFreed > 0) {
                offset = i * 32;
                status = this.file.readByte(offset);
                ++offset;
                if ((txId = this.file.readInt(++offset)) != iTxId) break;
                lastRecord = i--;
                --recordFreed;
            }
            if (lastRecord > -1) {
                this.file.shrink(lastRecord * 32);
            }
            this.synchTx();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalLogCount() {
        this.acquireSharedLock();
        try {
            int n = this.file.getFilledUpTo() / 32;
            return n;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public void rollback(OTransaction iTx) throws IOException {
        this.recoverTransaction(iTx.getId());
    }

    private void recoverTransactions() throws IOException {
        OLogManager.instance().debug((Object)this, "Started the recovering of pending transactions after a hard shutdown. Found " + this.getTotalLogCount() + " entry logs. Scanning...", new Object[0]);
        int recoveredTxs = 0;
        int recoveredRecords = 0;
        Set<Integer> txToRecover = this.scanForTransactionsToRecover();
        for (Integer txId : txToRecover) {
            int rec = this.recoverTransaction(txId);
            if (rec <= 0) continue;
            ++recoveredTxs;
            recoveredRecords += rec;
        }
        this.file.shrink(0);
        if (recoveredRecords > 0) {
            OLogManager.instance().info((Object)this, "Recovering successfully completed:", new Object[0]);
            OLogManager.instance().info((Object)this, "- Recovered Tx.....: " + recoveredTxs, new Object[0]);
            OLogManager.instance().info((Object)this, "- Recovered Records: " + recoveredRecords, new Object[0]);
        } else {
            OLogManager.instance().debug((Object)this, "Recovering successfully completed: no pending tx records found.", new Object[0]);
        }
    }

    private Set<Integer> scanForTransactionsToRecover() throws IOException {
        HashSet<Integer> txToRecover = new HashSet<Integer>();
        HashSet<Integer> txToNotRecover = new HashSet<Integer>();
        int size = this.file.getFilledUpTo() / 32;
        block4: for (int i = 0; i < size; ++i) {
            int offset = i * 32;
            byte status = this.file.readByte(offset);
            ++offset;
            int txId = this.file.readInt(++offset);
            switch (status) {
                case 0: {
                    txToNotRecover.add(txId);
                    continue block4;
                }
                case 1: {
                    txToRecover.add(txId);
                }
            }
        }
        txToRecover.removeAll(txToNotRecover);
        return txToRecover;
    }

    public void movedRecord(int iDataSegmentId, long iSourcePosition, long iDestinationPosition) throws IOException {
        int size = this.file.getFilledUpTo() / 32;
        for (int i = 0; i < size; ++i) {
            long oldDataOffset;
            int offset = i * 32;
            byte status = this.file.readByte(offset);
            ++offset;
            if (status == 0) continue;
            ++offset;
            offset += 4;
            offset += 2;
            int oldDataId = this.file.readInt(offset += 8);
            if (iDataSegmentId != oldDataId || (oldDataOffset = this.file.readLong(offset += 4)) != iSourcePosition) continue;
            this.file.writeLong(offset, iDestinationPosition);
        }
    }

    private int recoverTransaction(int iTxId) throws IOException {
        OPhysicalPosition ppos = new OPhysicalPosition();
        int recordsRecovered = 0;
        ORecordId rid = new ORecordId();
        int size = this.file.getFilledUpTo() / 32;
        for (int i = 0; i < size; ++i) {
            int txId;
            int offset = i * 32;
            byte status = this.file.readByte(offset);
            ++offset;
            if (status == 0) continue;
            byte operation = this.file.readByte(offset);
            if ((txId = this.file.readInt(++offset)) != iTxId) continue;
            rid.clusterId = this.file.readShort(offset += 4);
            rid.clusterPosition = this.file.readLong(offset += 2);
            int oldDataId = this.file.readInt(offset += 8);
            long oldDataOffset = this.file.readLong(offset += 4);
            int recordVersion = this.file.readInt(offset += 8);
            this.recoverTransactionEntry(status, operation, txId, rid, oldDataId, oldDataOffset, recordVersion, ppos);
            ++recordsRecovered;
            this.file.writeByte(i * 32, (byte)0);
        }
        return recordsRecovered;
    }

    public void finalizeTransactionEntry(byte operation, ORecordId iRid, int oldDataId, long oldDataOffset) throws IOException {
        ODataLocal dataSegment = this.storage.getDataSegment(oldDataId);
        switch (operation) {
            case 0: {
                break;
            }
            case 2: {
                dataSegment.deleteRecord(oldDataOffset);
                break;
            }
            case 1: {
                dataSegment.deleteRecord(oldDataOffset);
            }
        }
    }

    private void recoverTransactionEntry(byte iStatus, byte iOperation, int iTxId, ORecordId iRid, int iOldDataId, long iOldDataOffset, int iRecordVersion, OPhysicalPosition ppos) throws IOException {
        OClusterLocal cluster = (OClusterLocal)this.storage.getClusterById(iRid.clusterId);
        if (!(cluster instanceof OClusterLocal)) {
            return;
        }
        OLogManager.instance().debug((Object)this, "Recovering tx <%d>. Operation <%d> was in status <%d> on record %s in data space %d...", new Object[]{iTxId, iOperation, iStatus, iRid, iOldDataOffset});
        switch (iOperation) {
            case 0: {
                this.storage.deleteRecord(iRid, -1);
                break;
            }
            case 2: {
                cluster.getPhysicalPosition(iRid.clusterPosition, ppos);
                long oldPosition = ppos.dataPosition;
                ppos.dataPosition = iOldDataOffset;
                ppos.recordSize = this.storage.getDataSegment(iOldDataId).getRecordSize(iOldDataOffset);
                cluster.setPhysicalPosition(iRid.clusterPosition, iOldDataId, iOldDataOffset, ppos.type, --ppos.version);
                this.storage.getDataSegment(iOldDataId).updateRid(iOldDataOffset, iRid);
                this.storage.getDataSegment(ppos.dataSegment).deleteRecord(oldPosition);
                break;
            }
            case 1: {
                cluster.updateVersion(iRid.clusterPosition, iRecordVersion);
                cluster.removeHole(iRid.clusterPosition);
            }
        }
    }

    private void synchRecord() {
        if (((OStorageTxConfiguration)this.config).isSynchRecord()) {
            this.file.synch();
        }
    }

    private void synchTx() {
        if (((OStorageTxConfiguration)this.config).isSynchTx()) {
            this.file.synch();
        }
    }
}

