/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.tx;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.cache.OLevel1RecordCache;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.raw.ODatabaseRaw;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordTx;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionRecordEntry;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OTransactionAbstract
implements OTransaction {
    protected final ODatabaseRecordTx database;
    protected OTransaction.TXSTATUS status = OTransaction.TXSTATUS.INVALID;

    protected OTransactionAbstract(ODatabaseRecordTx iDatabase) {
        this.database = iDatabase;
    }

    @Override
    public boolean isActive() {
        return this.status != OTransaction.TXSTATUS.INVALID;
    }

    @Override
    public OTransaction.TXSTATUS getStatus() {
        return this.status;
    }

    @Override
    public ODatabaseRecordTx getDatabase() {
        return this.database;
    }

    public static void updateCacheFromEntries(OStorage iStorage, OTransaction iTx, Iterable<? extends OTransactionRecordEntry> iEntries, boolean iUpdateStrategy) throws IOException {
        OLevel1RecordCache dbCache = iTx.getDatabase().getLevel1Cache();
        for (OTransactionRecordEntry oTransactionRecordEntry : iEntries) {
            if (!iUpdateStrategy) {
                dbCache.deleteRecord(oTransactionRecordEntry.getRecord().getIdentity());
                continue;
            }
            if (oTransactionRecordEntry.status == 2) {
                dbCache.deleteRecord(oTransactionRecordEntry.getRecord().getIdentity());
                continue;
            }
            if (oTransactionRecordEntry.status != 1 && oTransactionRecordEntry.status != 3) continue;
            dbCache.updateRecord(oTransactionRecordEntry.getRecord());
        }
    }

    protected void invokeCommitAgainstListeners() {
        for (ODatabaseListener listener : ((ODatabaseRaw)this.database.getUnderlying()).getListeners()) {
            try {
                listener.onBeforeTxCommit((ODatabase)this.database.getUnderlying());
            }
            catch (Throwable t) {
                OLogManager.instance().error((Object)this, "Error on commit callback against listener: " + listener, t, new Object[0]);
            }
        }
    }

    protected void invokeRollbackAgainstListeners() {
        for (ODatabaseListener listener : ((ODatabaseRaw)this.database.getUnderlying()).getListeners()) {
            try {
                listener.onBeforeTxRollback((ODatabase)this.database.getUnderlying());
            }
            catch (Throwable t) {
                OLogManager.instance().error((Object)this, "Error on rollback callback against listener: " + listener, t, new Object[0]);
            }
        }
    }
}

