/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.tx;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordTx;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionRealAbstract;
import com.orientechnologies.orient.core.tx.OTransactionRecordEntry;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OTransactionOptimistic
extends OTransactionRealAbstract {
    private boolean usingLog = OGlobalConfiguration.TX_USE_LOG.getValueAsBoolean();
    private static AtomicInteger txSerial = new AtomicInteger();

    public OTransactionOptimistic(ODatabaseRecordTx iDatabase) {
        super(iDatabase, txSerial.incrementAndGet());
    }

    @Override
    public void begin() {
        this.status = OTransaction.TXSTATUS.BEGUN;
    }

    @Override
    public void commit() {
        this.checkTransaction();
        this.status = OTransaction.TXSTATUS.COMMITTING;
        this.database.executeCommit();
    }

    @Override
    public void rollback() {
        this.checkTransaction();
        this.status = OTransaction.TXSTATUS.ROLLBACKING;
        this.database.getLevel1Cache().invalidate();
        for (OTransactionRecordEntry v : this.recordEntries.values()) {
            v.getRecord().unload();
        }
        for (OTransactionRecordEntry v : this.allEntries.values()) {
            v.getRecord().unload();
        }
    }

    @Override
    public ORecordInternal<?> loadRecord(ORID iRid, ORecordInternal<?> iRecord, String iFetchPlan) {
        this.checkTransaction();
        ORecordInternal<?> txRecord = this.getRecord(iRid);
        if (txRecord != null) {
            return txRecord;
        }
        return this.database.executeReadRecord((ORecordId)iRid, iRecord, iFetchPlan, false);
    }

    @Override
    public void deleteRecord(ORecordInternal<?> iRecord) {
        this.addRecord(iRecord, (byte)2, null);
    }

    @Override
    public void saveRecord(ORecordInternal<?> iRecord, String iClusterName) {
        this.addRecord(iRecord, iRecord.getIdentity().isValid() ? (byte)1 : 3, iClusterName);
    }

    private void addRecord(ORecordInternal<?> iRecord, byte iStatus, String iClusterName) {
        this.checkTransaction();
        if (this.status == OTransaction.TXSTATUS.COMMITTING && this.database.getStorage() instanceof OStorageEmbedded) {
            switch (iStatus) {
                case 1: 
                case 3: {
                    this.database.executeSaveRecord(iRecord, iClusterName, iRecord.getVersion(), iRecord.getRecordType());
                    break;
                }
                case 2: {
                    this.database.executeDeleteRecord(iRecord, iRecord.getVersion());
                }
            }
        } else {
            ORecordId rid = (ORecordId)iRecord.getIdentity();
            if (!rid.isValid()) {
                iRecord.onBeforeIdentityChanged(rid);
                rid.clusterPosition = this.newObjectCounter--;
                iRecord.onAfterIdentityChanged(iRecord);
            } else {
                this.database.getLevel1Cache().freeRecord(rid);
            }
            OTransactionRecordEntry txEntry = this.getRecordEntry(rid);
            if (txEntry == null) {
                txEntry = new OTransactionRecordEntry(iRecord, iStatus, iClusterName);
                this.recordEntries.put(rid, txEntry);
            } else {
                txEntry.setRecord(iRecord);
                switch (txEntry.status) {
                    case 0: {
                        switch (iStatus) {
                            case 1: {
                                txEntry.status = 1;
                                break;
                            }
                            case 2: {
                                txEntry.status = (byte)2;
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (iStatus) {
                            case 2: {
                                txEntry.status = (byte)2;
                            }
                        }
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        switch (iStatus) {
                            case 2: {
                                this.recordEntries.remove(rid);
                            }
                        }
                    }
                }
            }
        }
    }

    public String toString() {
        return "OTransactionOptimistic [id=" + this.id + ", status=" + (Object)((Object)this.status) + ", recEntries=" + this.recordEntries.size() + ", idxEntries=" + this.indexEntries.size() + "]";
    }

    @Override
    public boolean isUsingLog() {
        return this.usingLog;
    }

    @Override
    public void setUsingLog(boolean useLog) {
        this.usingLog = useLog;
    }
}

