/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.tx;

import com.orientechnologies.orient.core.db.record.ODatabaseRecordTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerStringAbstract;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionAbstract;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import com.orientechnologies.orient.core.tx.OTransactionRecordEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OTransactionRealAbstract
extends OTransactionAbstract {
    protected Map<ORID, OTransactionRecordEntry> allEntries = new HashMap<ORID, OTransactionRecordEntry>();
    protected Map<ORID, OTransactionRecordEntry> recordEntries = new HashMap<ORID, OTransactionRecordEntry>();
    protected Map<String, OTransactionIndexChanges> indexEntries = new HashMap<String, OTransactionIndexChanges>();
    protected int id;
    protected int newObjectCounter = -2;

    protected OTransactionRealAbstract(ODatabaseRecordTx iDatabase, int iId) {
        super(iDatabase);
        this.id = iId;
    }

    @Override
    public void close() {
        this.allEntries.clear();
        this.recordEntries.clear();
        this.indexEntries.clear();
        this.newObjectCounter = -2;
        this.status = OTransaction.TXSTATUS.INVALID;
        this.database.setDefaultTransactionMode();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void clearRecordEntries() {
        this.allEntries.putAll(this.recordEntries);
        this.recordEntries.clear();
    }

    public Collection<OTransactionRecordEntry> getCurrentRecordEntries() {
        return this.recordEntries.values();
    }

    public Collection<OTransactionRecordEntry> getAllRecordEntries() {
        return this.allEntries.values();
    }

    @Override
    public OTransactionRecordEntry getRecordEntry(ORID rid) {
        OTransactionRecordEntry e = this.recordEntries.get(rid);
        if (e != null) {
            return e;
        }
        e = this.allEntries.get(rid);
        if (e != null) {
            return e;
        }
        return null;
    }

    @Override
    public ORecordInternal<?> getRecord(ORID rid) {
        OTransactionRecordEntry e = this.getRecordEntry(rid);
        if (e != null && e.status != 2) {
            return e.record;
        }
        return null;
    }

    @Override
    public List<OTransactionRecordEntry> getRecordEntriesByClass(String iClassName) {
        ArrayList<OTransactionRecordEntry> result = new ArrayList<OTransactionRecordEntry>();
        if (iClassName == null || iClassName.length() == 0) {
            for (OTransactionRecordEntry entry : this.recordEntries.values()) {
                result.add(entry);
            }
        } else {
            for (OTransactionRecordEntry entry : this.recordEntries.values()) {
                if (entry.getRecord() == null || !(entry.getRecord() instanceof ODocument) || !iClassName.equals(((ODocument)entry.getRecord()).getClassName())) continue;
                result.add(entry);
            }
        }
        return result;
    }

    @Override
    public List<OTransactionRecordEntry> getRecordEntriesByClusterIds(int[] iIds) {
        ArrayList<OTransactionRecordEntry> result = new ArrayList<OTransactionRecordEntry>();
        if (iIds == null) {
            for (OTransactionRecordEntry entry : this.recordEntries.values()) {
                result.add(entry);
            }
        } else {
            block1: for (OTransactionRecordEntry entry : this.recordEntries.values()) {
                for (int id : iIds) {
                    if (entry.getRecord() == null || entry.getRecord().getIdentity().getClusterId() != id) continue;
                    result.add(entry);
                    continue block1;
                }
            }
        }
        return result;
    }

    @Override
    public void clearIndexEntries() {
        this.indexEntries.clear();
    }

    @Override
    public List<String> getInvolvedIndexes() {
        ArrayList<String> list = null;
        for (String indexName : this.indexEntries.keySet()) {
            if (list == null) {
                list = new ArrayList<String>();
            }
            list.add(indexName);
        }
        return list;
    }

    @Override
    public ODocument getIndexChanges() {
        StringBuilder value = new StringBuilder();
        ODocument result = new ODocument();
        for (Map.Entry<String, OTransactionIndexChanges> indexEntry : this.indexEntries.entrySet()) {
            ODocument indexDoc = new ODocument();
            result.field(indexEntry.getKey(), indexDoc);
            if (indexEntry.getValue().cleared) {
                indexDoc.field("clear", Boolean.TRUE);
            }
            ArrayList<ODocument> entries = new ArrayList<ODocument>();
            indexDoc.field("entries", entries);
            for (OTransactionIndexChangesPerKey entry : indexEntry.getValue().changesPerKey.values()) {
                value.setLength(0);
                if (entry.key != null) {
                    ORecordSerializerStringAbstract.fieldTypeToString(value, null, OType.getTypeByClass(entry.key.getClass()), entry.key);
                } else {
                    value.append('*');
                }
                String key = value.toString();
                ArrayList<ODocument> operations = new ArrayList<ODocument>();
                if (entry.entries != null && !entry.entries.isEmpty()) {
                    for (OTransactionIndexChangesPerKey.OTransactionIndexEntry e : entry.entries) {
                        ODocument changeDoc = new ODocument();
                        changeDoc.field("o", e.operation.ordinal());
                        if (e.value instanceof ORecord && e.value.getIdentity().isNew()) {
                            ((ORecord)e.value).save();
                        }
                        changeDoc.field("v", e.value.getIdentity());
                        operations.add(changeDoc);
                    }
                }
                entries.add(new ODocument().field("k", OStringSerializerHelper.encode(key)).field("ops", operations));
            }
        }
        this.indexEntries.clear();
        return result;
    }

    @Override
    public OTransactionIndexChanges getIndexChanges(String iIndexName) {
        return this.indexEntries.get(iIndexName);
    }

    @Override
    public void addIndexEntry(OIndex<?> delegate, String iIndexName, OTransactionIndexChanges.OPERATION iOperation, Object iKey, OIdentifiable iValue) {
        OTransactionIndexChanges indexEntry = this.indexEntries.get(iIndexName);
        if (indexEntry == null) {
            indexEntry = new OTransactionIndexChanges();
            this.indexEntries.put(iIndexName, indexEntry);
        }
        if (iOperation == OTransactionIndexChanges.OPERATION.CLEAR) {
            indexEntry.setCleared();
        } else {
            indexEntry.getChangesPerKey(iKey).add(iValue, iOperation);
        }
    }

    protected void checkTransaction() {
        if (this.status == OTransaction.TXSTATUS.INVALID) {
            throw new OTransactionException("Invalid state of the transaction. The transaction must be begun.");
        }
    }
}

