/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.type.tree;

import com.orientechnologies.common.collection.OMVRBTreeEntry;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeEntryDatabase;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeEntryPersistent;
import com.orientechnologies.orient.core.type.tree.OMVRBTreePersistent;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMVRBTreeDatabase<K, V>
extends OMVRBTreePersistent<K, V> {
    public OMVRBTreeDatabase(ODatabaseRecord iDatabase, ORID iRID) {
        super(iDatabase.getClusterNameById(iRID.getClusterId()), iRID);
    }

    public OMVRBTreeDatabase(ODatabaseRecord iDatabase, String iClusterName, OStreamSerializer iKeySerializer, OStreamSerializer iValueSerializer) {
        super(iClusterName, iKeySerializer, iValueSerializer);
    }

    public void delete() {
        this.getDatabase();
        this.clear();
        this.record.delete();
    }

    protected OMVRBTreeEntryDatabase<K, V> createEntry(K key, V value) {
        this.adjustPageSize();
        return new OMVRBTreeEntryDatabase<K, V>(this, key, value, null);
    }

    protected OMVRBTreeEntryDatabase<K, V> createEntry(OMVRBTreeEntry<K, V> parent) {
        this.adjustPageSize();
        return new OMVRBTreeEntryDatabase<K, V>(parent, parent.getPageSplitItems());
    }

    @Override
    protected OMVRBTreeEntryDatabase<K, V> loadEntry(OMVRBTreeEntryPersistent<K, V> iParent, ORID iRecordId) throws IOException {
        this.checkForOptimization();
        OMVRBTreeEntryDatabase entry = (OMVRBTreeEntryDatabase)this.searchNodeInCache(iRecordId);
        if (entry == null) {
            OMVRBTreeEntryPersistent rightNode;
            OMVRBTreeEntryPersistent leftNode;
            OMVRBTreeEntryPersistent parentNode;
            entry = new OMVRBTreeEntryDatabase(this, (OMVRBTreeEntryDatabase)iParent, iRecordId);
            this.addNodeInCache(entry);
            if (entry.parent == null && entry.parentRid.isValid() && (parentNode = this.searchNodeInCache(entry.parentRid)) != null) {
                entry.setParent(parentNode);
            }
            if (entry.left == null && entry.leftRid.isValid() && (leftNode = this.searchNodeInCache(entry.leftRid)) != null) {
                entry.setLeft(leftNode);
            }
            if (entry.right == null && entry.rightRid.isValid() && (rightNode = this.searchNodeInCache(entry.rightRid)) != null) {
                entry.setRight(rightNode);
            }
        } else if (iParent != null) {
            entry.setParent(iParent);
        }
        entry.checkEntryStructure();
        return entry;
    }

    @Override
    public OMVRBTreePersistent<K, V> load() {
        if (!this.record.getIdentity().isValid()) {
            return this;
        }
        this.getDatabase();
        this.record.reload();
        this.record.recycle(this);
        this.fromStream(this.record.toStream());
        this.setLastSearchNode(null, null);
        return this;
    }

    @Override
    public OMVRBTreePersistent<K, V> save() throws IOException {
        this.getDatabase();
        this.record.save(this.clusterName);
        return this;
    }

    public void onAfterTxCommit() {
        Set<ORID> nodesInMemory = this.getAllNodesInCache();
        if (nodesInMemory.isEmpty()) {
            return;
        }
        HashSet<ORID> keys = new HashSet<ORID>(nodesInMemory);
        for (ORID rid : keys) {
            if (rid.getClusterPosition() >= -1L) continue;
            OMVRBTreeEntryDatabase entry = (OMVRBTreeEntryDatabase)this.searchNodeInCache(rid);
            this.removeNodeFromCache(rid);
            this.addNodeInCache(entry);
        }
    }
}

