/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.type.tree;

import com.orientechnologies.common.collection.OMVRBTreeEntry;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeDatabase;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeEntryPersistent;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMVRBTreeEntryDatabase<K, V>
extends OMVRBTreeEntryPersistent<K, V> {
    public OMVRBTreeEntryDatabase(OMVRBTreeEntry<K, V> iParent, int iPosition) {
        super(iParent, iPosition);
    }

    public OMVRBTreeEntryDatabase(OMVRBTreeDatabase<K, V> iTree, OMVRBTreeEntryDatabase<K, V> iParent, ORID iRecordId) throws IOException {
        super(iTree, iParent, iRecordId);
    }

    public OMVRBTreeEntryDatabase(OMVRBTreeDatabase<K, V> iTree, K key, V value, OMVRBTreeEntryDatabase<K, V> iParent) {
        super(iTree, key, value, iParent);
    }

    @Override
    public OMVRBTreeEntryDatabase<K, V> load() throws IOException {
        this.pTree.checkForOptimization();
        try {
            this.record.setDatabase((ODatabaseRecord)ODatabaseRecordThreadLocal.INSTANCE.get());
            this.record.reload();
        }
        catch (Exception e) {
            OLogManager.instance().warn((Object)this, "Error on loading index node record %s", (Throwable)e, new Object[]{this.record.getIdentity()});
        }
        this.record.recycle(this);
        this.fromStream(this.record.toStream());
        if (OLogManager.instance().isDebugEnabled()) {
            OLogManager.instance().debug((Object)this, "Loaded tree node %s (%s-%s)", new Object[]{this.record.getIdentity(), this.getFirstKey(), this.getLastKey()});
        }
        return this;
    }

    @Override
    public OMVRBTreeEntryDatabase<K, V> save() throws OSerializationException {
        if (!this.record.isDirty()) {
            return this;
        }
        super.save();
        if (this.parent != null && !this.parent.record.getIdentity().equals(this.parentRid)) {
            OLogManager.instance().error((Object)this, "[save]: Tree node %s has parentRid '%s' different by the rid of the assigned parent node: %s", new Object[]{this.record.getIdentity(), this.parentRid, this.parent.record.getIdentity()});
        }
        this.checkEntryStructure();
        if (this.pTree.searchNodeInCache(this.record.getIdentity()) != this) {
            this.pTree.addNodeInCache(this);
        }
        return this;
    }

    @Override
    public OMVRBTreeEntryDatabase<K, V> delete() throws IOException {
        super.delete();
        if (this.getLeft() != null) {
            ((OMVRBTreeEntryPersistent)this.getLeft()).delete();
        }
        this.leftRid = null;
        if (this.getRight() != null) {
            ((OMVRBTreeEntryPersistent)this.getRight()).delete();
        }
        this.rightRid = null;
        this.record.setDatabase((ODatabaseRecord)ODatabaseRecordThreadLocal.INSTANCE.get());
        this.record.delete();
        this.keys = null;
        this.values = null;
        this.serializedKeys = null;
        this.serializedValues = null;
        return this;
    }

    @Override
    protected Object keyFromStream(int iIndex) throws IOException {
        return this.pTree.keySerializer.fromStream(((OMVRBTreeDatabase)this.pTree).getDatabase(), this.inStream.getAsByteArray(this.serializedKeys[iIndex]));
    }

    @Override
    protected Object valueFromStream(int iIndex) throws IOException {
        return this.pTree.valueSerializer.fromStream(((OMVRBTreeDatabase)this.pTree).getDatabase(), this.inStream.getAsByteArray(this.serializedValues[iIndex]));
    }
}

