/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.type.tree;

import com.orientechnologies.common.collection.OMVRBTreeEntry;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.impl.ORecordBytesLazy;
import com.orientechnologies.orient.core.serialization.OMemoryInputStream;
import com.orientechnologies.orient.core.serialization.OMemoryOutputStream;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.serialization.serializer.record.OSerializationThreadLocal;
import com.orientechnologies.orient.core.type.tree.OMVRBTreePersistent;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OMVRBTreeEntryPersistent<K, V>
extends OMVRBTreeEntry<K, V>
implements OSerializableStream {
    protected OMVRBTreePersistent<K, V> pTree;
    int[] serializedKeys;
    int[] serializedValues;
    protected ORID parentRid;
    protected ORID leftRid;
    protected ORID rightRid;
    public ORecordBytesLazy record;
    protected OMVRBTreeEntryPersistent<K, V> parent;
    protected OMVRBTreeEntryPersistent<K, V> left;
    protected OMVRBTreeEntryPersistent<K, V> right;
    protected OMemoryInputStream inStream = new OMemoryInputStream();

    public OMVRBTreeEntryPersistent(OMVRBTreeEntry<K, V> iParent, int iPosition) {
        super(iParent, iPosition);
        this.pTree = (OMVRBTreePersistent)this.tree;
        this.record = new ORecordBytesLazy(this);
        this.setParent(iParent);
        this.parentRid = new ORecordId();
        this.leftRid = new ORecordId();
        this.rightRid = new ORecordId();
        this.pageSize = this.pTree.getPageSize();
        this.serializedKeys = new int[this.pageSize];
        this.serializedValues = new int[this.pageSize];
        OMVRBTreeEntryPersistent p = (OMVRBTreeEntryPersistent)iParent;
        this.inStream.setSource(p.inStream.copy());
        System.arraycopy(p.serializedKeys, iPosition, this.serializedKeys, 0, this.size);
        System.arraycopy(p.serializedValues, iPosition, this.serializedValues, 0, this.size);
        Arrays.fill(p.serializedKeys, iPosition, p.pageSize, 0);
        Arrays.fill(p.serializedValues, iPosition, p.pageSize, 0);
        this.markDirty();
        this.pTree.addNodeAsEntrypoint(this);
    }

    public OMVRBTreeEntryPersistent(OMVRBTreePersistent<K, V> iTree, OMVRBTreeEntryPersistent<K, V> iParent, ORID iRecordId) throws IOException {
        super(iTree);
        this.pTree = iTree;
        this.record = new ORecordBytesLazy(this);
        this.record.setIdentity((ORecordId)iRecordId);
        this.parent = iParent;
        this.parentRid = iParent == null ? ORecordId.EMPTY_RECORD_ID : this.parent.record.getIdentity();
        this.load();
        this.pTree.addNodeAsEntrypoint(this);
    }

    public OMVRBTreeEntryPersistent(OMVRBTreePersistent<K, V> iTree, K key, V value, OMVRBTreeEntryPersistent<K, V> iParent) {
        super(iTree, key, value, iParent);
        this.pTree = iTree;
        this.parentRid = new ORecordId();
        this.leftRid = new ORecordId();
        this.rightRid = new ORecordId();
        this.record = new ORecordBytesLazy(this);
        this.pageSize = this.pTree.getPageSize();
        this.serializedKeys = new int[this.pageSize];
        this.serializedValues = new int[this.pageSize];
        this.tree.getListener().signalNodeChanged((OMVRBTreeEntry)this);
        this.pTree.addNodeAsEntrypoint(this);
    }

    protected abstract Object keyFromStream(int var1) throws IOException;

    protected abstract Object valueFromStream(int var1) throws IOException;

    public OMVRBTreeEntryPersistent<K, V> load() throws IOException {
        return this;
    }

    public OMVRBTreeEntryPersistent<K, V> save() throws OSerializationException {
        if (!this.record.isDirty()) {
            return this;
        }
        boolean isNew = this.record.getIdentity().isNew();
        if (this.record.isDirty()) {
            this.record.setDatabase((ODatabaseRecord)ODatabaseRecordThreadLocal.INSTANCE.get());
            if (this.record.getDatabase() == null) {
                throw new IllegalStateException("Current thread has no database setted and the tree can't be saved correctly. Assure to close the database before the application if off.");
            }
            this.record.save(this.pTree.getClusterName());
        }
        if (isNew) {
            ORecordId rid = (ORecordId)this.record.getIdentity();
            if (this.left != null) {
                this.left.parentRid = rid;
                this.left.markDirty();
            }
            if (this.right != null) {
                this.right.parentRid = rid;
                this.right.markDirty();
            }
            if (this.parent != null) {
                this.parentRid = this.parent.record.getIdentity();
                if (this.parent.left == this) {
                    this.parent.leftRid = rid;
                } else if (this.parent.right == this) {
                    this.parent.rightRid = rid;
                }
                this.parent.markDirty();
            }
        }
        return this;
    }

    public OMVRBTreeEntryPersistent<K, V> delete() throws IOException {
        this.pTree.removeNodeFromMemory(this);
        this.pTree.removeEntry(this.record.getIdentity());
        return this;
    }

    protected int disconnect(boolean iForceDirty, int iLevel) {
        if (this.record == null) {
            return 1;
        }
        int totalDisconnected = 0;
        ORID rid = this.record.getIdentity();
        if (!(this.record.isDirty() && !iForceDirty || this.pTree.isNodeEntryPoint(this))) {
            totalDisconnected = 1;
            this.pTree.removeNodeFromMemory(this);
            this.clear();
        }
        if (this.parent != null) {
            if (this.parent.left == this) {
                this.parent.left = null;
            } else if (this.parent.right == this) {
                this.parent.right = null;
            } else {
                OLogManager.instance().warn((Object)this, "Node " + rid + " has the parent (" + this.parent + ") unlinked to itself. It links to " + this.parent, new Object[0]);
            }
            totalDisconnected += this.parent.disconnect(iForceDirty, iLevel + 1);
            this.parent = null;
        }
        if (this.left != null) {
            if (this.left.parent == this) {
                this.left.parent = null;
            } else {
                OLogManager.instance().warn((Object)this, "Node " + rid + " has the left (" + this.left + ") unlinked to itself. It links to " + this.left.parent, new Object[0]);
            }
            totalDisconnected += this.left.disconnect(iForceDirty, iLevel + 1);
            this.left = null;
        }
        if (this.right != null) {
            if (this.right.parent == this) {
                this.right.parent = null;
            } else {
                OLogManager.instance().warn((Object)this, "Node " + rid + " has the right (" + this.right + ")unlinked to itself. It links to " + this.right.parent, new Object[0]);
            }
            totalDisconnected += this.right.disconnect(iForceDirty, iLevel + 1);
            this.right = null;
        }
        return totalDisconnected;
    }

    public void clear() {
        this.keys = null;
        this.values = null;
        if (this.inStream != null) {
            this.inStream.close();
            this.inStream = null;
        }
        this.serializedKeys = null;
        this.serializedValues = null;
        this.pTree = null;
        this.tree = null;
        this.record.recycle(null);
        this.record = null;
        this.size = 0;
    }

    protected int disconnectLinked(boolean iForce) {
        return this.disconnect(iForce, 0);
    }

    public int getDepthInMemory() {
        int level = 0;
        OMVRBTreeEntryPersistent<K, V> entry = this;
        while (entry.parent != null) {
            ++level;
            entry = entry.parent;
        }
        return level;
    }

    public int getDepth() {
        int level = 0;
        OMVRBTreeEntryPersistent entry = this;
        while (entry.getParent() != null) {
            ++level;
            entry = (OMVRBTreeEntryPersistent)entry.getParent();
        }
        return level;
    }

    public OMVRBTreeEntry<K, V> getParent() {
        if (this.parentRid == null) {
            return null;
        }
        if (this.parent == null && this.parentRid.isValid()) {
            try {
                this.parent = this.pTree.loadEntry(null, this.parentRid);
                this.checkEntryStructure();
                if (this.parent != null) {
                    if (this.parent.leftRid.isValid() && this.parent.leftRid.equals(this.record.getIdentity())) {
                        this.parent.left = this;
                    } else if (this.parent.rightRid.isValid() && this.parent.rightRid.equals(this.record.getIdentity())) {
                        this.parent.right = this;
                    } else {
                        OLogManager.instance().error((Object)this, "getParent: Can't assign node %s to parent. Nodes parent-left=%s, parent-right=%s", new Object[]{this.parentRid, this.parent.leftRid, this.parent.rightRid});
                    }
                }
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "getParent: Can't load the tree. The tree could be invalid.", (Throwable)e, ODatabaseException.class, new Object[0]);
            }
        }
        return this.parent;
    }

    public OMVRBTreeEntry<K, V> setParent(OMVRBTreeEntry<K, V> iParent) {
        if (iParent != this.parent) {
            this.parent = (OMVRBTreeEntryPersistent)iParent;
            if (this.parent != null && !this.parent.record.getIdentity().equals(this.parentRid)) {
                this.markDirty();
            }
            ORID oRID = this.parentRid = iParent == null ? ORecordId.EMPTY_RECORD_ID : this.parent.record.getIdentity();
            if (this.parent != null) {
                if (this.parent.left == this && !this.parent.leftRid.equals(this.record.getIdentity())) {
                    this.parent.leftRid = this.record.getIdentity();
                }
                if (this.parent.left != this && this.parent.leftRid.isValid() && this.parent.leftRid.equals(this.record.getIdentity())) {
                    this.parent.left = this;
                }
                if (this.parent.right == this && !this.parent.rightRid.equals(this.record.getIdentity())) {
                    this.parent.rightRid = this.record.getIdentity();
                }
                if (this.parent.right != this && this.parent.rightRid.isValid() && this.parent.rightRid.equals(this.record.getIdentity())) {
                    this.parent.right = this;
                }
            }
        }
        return iParent;
    }

    public OMVRBTreeEntry<K, V> getLeft() {
        if (this.left == null && this.leftRid.isValid()) {
            try {
                this.left = this.pTree.loadEntry(this, this.leftRid);
                this.checkEntryStructure();
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "getLeft: Can't load the tree. The tree could be invalid.", (Throwable)e, ODatabaseException.class, new Object[0]);
            }
        }
        return this.left;
    }

    public void setLeft(OMVRBTreeEntry<K, V> iLeft) {
        if (iLeft != this.left) {
            this.left = (OMVRBTreeEntryPersistent)iLeft;
            if (this.left != null && !this.left.record.getIdentity().equals(this.leftRid)) {
                this.markDirty();
            }
            ORID oRID = this.leftRid = iLeft == null ? ORecordId.EMPTY_RECORD_ID : this.left.record.getIdentity();
            if (this.left != null && this.left.parent != this) {
                this.left.setParent(this);
            }
            this.checkEntryStructure();
        }
    }

    public OMVRBTreeEntry<K, V> getRight() {
        if (this.rightRid.isValid() && this.right == null) {
            try {
                this.right = this.pTree.loadEntry(this, this.rightRid);
                this.checkEntryStructure();
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "getRight: Can't load tree. The tree could be invalid.", (Throwable)e, ODatabaseException.class, new Object[0]);
            }
        }
        return this.right;
    }

    public OMVRBTreeEntry<K, V> setRight(OMVRBTreeEntry<K, V> iRight) {
        if (iRight != this.right) {
            this.right = (OMVRBTreeEntryPersistent)iRight;
            if (this.right != null && !this.right.record.getIdentity().equals(this.rightRid)) {
                this.markDirty();
            }
            ORID oRID = this.rightRid = iRight == null ? ORecordId.EMPTY_RECORD_ID : this.right.record.getIdentity();
            if (this.right != null && this.right.parent != this) {
                this.right.setParent(this);
            }
            this.checkEntryStructure();
        }
        return this.right;
    }

    public void checkEntryStructure() {
        if (!this.tree.isRuntimeCheckEnabled()) {
            return;
        }
        if (this.parentRid == null) {
            OLogManager.instance().error((Object)this, "checkEntryStructure: Node %s has parentRid null!\n", new Object[]{this});
        }
        if (this.leftRid == null) {
            OLogManager.instance().error((Object)this, "checkEntryStructure: Node %s has leftRid null!\n", new Object[]{this});
        }
        if (this.rightRid == null) {
            OLogManager.instance().error((Object)this, "checkEntryStructure: Node %s has rightRid null!\n", new Object[]{this});
        }
        if (this == this.left || this.record.getIdentity().isValid() && this.record.getIdentity().equals(this.leftRid)) {
            OLogManager.instance().error((Object)this, "checkEntryStructure: Node %s has left that points to itself!\n", new Object[]{this});
        }
        if (this == this.right || this.record.getIdentity().isValid() && this.record.getIdentity().equals(this.rightRid)) {
            OLogManager.instance().error((Object)this, "checkEntryStructure: Node %s has right that points to itself!\n", new Object[]{this});
        }
        if (this.left != null && this.left == this.right) {
            OLogManager.instance().error((Object)this, "checkEntryStructure: Node %s has left and right equals!\n", new Object[]{this});
        }
        if (this.left != null && !this.left.record.getIdentity().equals(this.leftRid)) {
            OLogManager.instance().error((Object)this, "checkEntryStructure: Wrong left node loaded: " + this.leftRid, new Object[0]);
        }
        if (this.right != null && !this.right.record.getIdentity().equals(this.rightRid)) {
            OLogManager.instance().error((Object)this, "checkEntryStructure: Wrong right node loaded: " + this.rightRid, new Object[0]);
        }
    }

    protected void copyFrom(OMVRBTreeEntry<K, V> iSource) {
        int i;
        this.markDirty();
        OMVRBTreeEntryPersistent source = (OMVRBTreeEntryPersistent)iSource;
        this.parent = source.parent;
        this.left = source.left;
        this.right = source.right;
        this.parentRid = source.parentRid;
        this.leftRid = source.leftRid;
        this.rightRid = source.rightRid;
        this.serializedKeys = new int[source.serializedKeys.length];
        for (i = 0; i < source.serializedKeys.length; ++i) {
            this.serializedKeys[i] = source.serializedKeys[i];
        }
        this.serializedValues = new int[source.serializedValues.length];
        for (i = 0; i < source.serializedValues.length; ++i) {
            this.serializedValues[i] = source.serializedValues[i];
        }
        super.copyFrom((OMVRBTreeEntry)source);
    }

    protected void insert(int iPosition, K key, V value) {
        this.markDirty();
        if (iPosition < this.size) {
            System.arraycopy(this.serializedKeys, iPosition, this.serializedKeys, iPosition + 1, this.size - iPosition);
            System.arraycopy(this.serializedValues, iPosition, this.serializedValues, iPosition + 1, this.size - iPosition);
        }
        this.serializedKeys[iPosition] = 0;
        this.serializedValues[iPosition] = 0;
        super.insert(iPosition, key, value);
        if (iPosition == 0) {
            this.pTree.updateEntryPoint(this.keys[1], this);
        }
    }

    protected void remove() {
        Object oldKey;
        this.markDirty();
        int index = this.tree.getPageIndex();
        Object k = oldKey = index == 0 ? (Object)this.getKeyAt(0) : null;
        if (index != this.size - 1 && index > -1) {
            System.arraycopy(this.serializedKeys, index + 1, this.serializedKeys, index, this.size - index - 1);
            System.arraycopy(this.serializedValues, index + 1, this.serializedValues, index, this.size - index - 1);
        }
        this.serializedKeys[this.size - 1] = 0;
        this.serializedValues[this.size - 1] = 0;
        super.remove();
        if (index == 0) {
            this.pTree.updateEntryPoint(oldKey, this);
        }
    }

    public K getKeyAt(int iIndex) {
        if (this.keys[iIndex] == null) {
            try {
                OProfiler.getInstance().updateCounter("OMVRBTreeEntryP.unserializeKey", 1L);
                this.keys[iIndex] = this.keyFromStream(iIndex);
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "Can't lazy load the key #" + iIndex + " in tree node " + this, (Throwable)e, OSerializationException.class, new Object[0]);
            }
        }
        return (K)this.keys[iIndex];
    }

    protected V getValueAt(int iIndex) {
        if (this.values[iIndex] == null) {
            try {
                OProfiler.getInstance().updateCounter("OMVRBTreeEntryP.unserializeValue", 1L);
                this.values[iIndex] = this.valueFromStream(iIndex);
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "Can't lazy load the value #" + iIndex + " in tree node " + this, (Throwable)e, OSerializationException.class, new Object[0]);
            }
        }
        return (V)this.values[iIndex];
    }

    public V setValue(V value) {
        this.markDirty();
        Object oldValue = super.setValue(value);
        this.serializedValues[this.tree.getPageIndex()] = -1;
        return (V)oldValue;
    }

    public int getMaxDepthInMemory() {
        return this.getMaxDepthInMemory(0);
    }

    private int getMaxDepthInMemory(int iCurrDepthLevel) {
        int rightDepth;
        int depth = this.left != null ? super.getMaxDepthInMemory(iCurrDepthLevel + 1) : iCurrDepthLevel;
        if (this.right != null && (rightDepth = super.getMaxDepthInMemory(iCurrDepthLevel + 1)) > depth) {
            depth = rightDepth;
        }
        return depth;
    }

    public OMVRBTreeEntryPersistent<K, V> getNextInMemory() {
        OMVRBTreeEntryPersistent<K, V> t = this;
        OMVRBTreeEntryPersistent<K, V> p = null;
        if (t.right != null) {
            p = t.right;
            while (p.left != null) {
                p = p.left;
            }
        } else {
            p = t.parent;
            while (p != null && t == p.right) {
                t = p;
                p = p.parent;
            }
        }
        return p;
    }

    @Override
    public final OSerializableStream fromStream(byte[] iStream) throws OSerializationException {
        OMVRBTreeEntryPersistent i;
        long timer = OProfiler.getInstance().startChrono();
        this.inStream.setSource(iStream);
        try {
            int i2;
            this.pageSize = this.inStream.getAsInteger();
            this.parentRid = new ORecordId().fromStream(this.inStream.getAsByteArrayFixed(10));
            this.leftRid = new ORecordId().fromStream(this.inStream.getAsByteArrayFixed(10));
            this.rightRid = new ORecordId().fromStream(this.inStream.getAsByteArrayFixed(10));
            this.color = this.inStream.getAsBoolean();
            this.init();
            this.size = this.inStream.getAsInteger();
            if (this.size > this.pageSize) {
                throw new OConfigurationException("Loaded index with page size setted to " + this.pageSize + " while the loaded was built with: " + this.size);
            }
            this.serializedKeys = new int[this.pageSize];
            for (i2 = 0; i2 < this.size; ++i2) {
                this.serializedKeys[i2] = this.inStream.getAsByteArrayOffset();
            }
            this.keys = new Object[this.pageSize];
            this.serializedValues = new int[this.pageSize];
            for (i2 = 0; i2 < this.size; ++i2) {
                this.serializedValues[i2] = this.inStream.getAsByteArrayOffset();
            }
            this.values = new Object[this.pageSize];
            i = this;
            Object var6_6 = null;
        }
        catch (IOException e) {
            try {
                throw new OSerializationException("Can't unmarshall RB+Tree node", e);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OProfiler.getInstance().stopChrono("OMVRBTreeEntryP.fromStream", timer);
                throw throwable;
            }
        }
        OProfiler.getInstance().stopChrono("OMVRBTreeEntryP.fromStream", timer);
        return i;
    }

    @Override
    public final byte[] toStream() throws OSerializationException {
        byte[] byArray;
        this.record.setDatabase((ODatabaseRecord)ODatabaseRecordThreadLocal.INSTANCE.get());
        Integer identityRecord = System.identityHashCode(this.record);
        Set marshalledRecords = (Set)OSerializationThreadLocal.INSTANCE.get();
        if (marshalledRecords.contains(identityRecord)) {
            return new byte[0];
        }
        marshalledRecords.add(identityRecord);
        if (this.parent != null && this.parentRid.isNew()) {
            this.parent.record.setDirty();
            this.parent.save();
            this.parentRid = this.parent.record.getIdentity();
            this.record.setDirty();
        }
        if (this.left != null && this.leftRid.isNew()) {
            this.left.record.setDirty();
            this.left.save();
            this.leftRid = this.left.record.getIdentity();
            this.record.setDirty();
        }
        if (this.right != null && this.rightRid.isNew()) {
            this.right.record.setDirty();
            this.right.save();
            this.rightRid = this.right.record.getIdentity();
            this.record.setDirty();
        }
        long timer = OProfiler.getInstance().startChrono();
        OMemoryOutputStream outStream = new OMemoryOutputStream();
        try {
            int i;
            outStream.add(this.pageSize);
            outStream.addAsFixed(this.parentRid.toStream());
            outStream.addAsFixed(this.leftRid.toStream());
            outStream.addAsFixed(this.rightRid.toStream());
            outStream.add(this.color);
            outStream.add(this.size);
            for (i = 0; i < this.size; ++i) {
                this.serializedKeys[i] = outStream.add(this.serializeNewKey(i));
            }
            for (i = 0; i < this.size; ++i) {
                this.serializedValues[i] = outStream.add(this.serializeNewValue(i));
            }
            outStream.flush();
            byte[] buffer = outStream.getByteArray();
            this.inStream.setSource(buffer);
            this.record.fromStream(buffer);
            byArray = buffer;
            Object var9_9 = null;
            marshalledRecords.remove(identityRecord);
        }
        catch (IOException e) {
            try {
                throw new OSerializationException("Can't marshall RB+Tree node", e);
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                marshalledRecords.remove(identityRecord);
                this.checkEntryStructure();
                OProfiler.getInstance().stopChrono("OMVRBTreeEntryP.toStream", timer);
                throw throwable;
            }
        }
        this.checkEntryStructure();
        OProfiler.getInstance().stopChrono("OMVRBTreeEntryP.toStream", timer);
        return byArray;
    }

    private byte[] serializeNewKey(int iIndex) throws IOException {
        if (this.serializedKeys[iIndex] <= 0) {
            OProfiler.getInstance().updateCounter("OMVRBTreeEntryP.serializeValue", 1L);
            return this.pTree.keySerializer.toStream(null, this.keys[iIndex]);
        }
        return this.inStream.getAsByteArray(this.serializedKeys[iIndex]);
    }

    private byte[] serializeNewValue(int iIndex) throws IOException {
        if (this.serializedValues[iIndex] <= 0) {
            OProfiler.getInstance().updateCounter("OMVRBTreeEntryP.serializeKey", 1L);
            return this.pTree.valueSerializer.toStream(null, this.values[iIndex]);
        }
        return this.inStream.getAsByteArray(this.serializedValues[iIndex]);
    }

    protected void setColor(boolean iColor) {
        if (iColor == this.color) {
            return;
        }
        this.markDirty();
        super.setColor(iColor);
    }

    void markDirty() {
        if (this.record == null || this.record.isDirty()) {
            return;
        }
        this.record.setDirty();
        this.tree.getListener().signalNodeChanged((OMVRBTreeEntry)this);
    }

    protected OMVRBTreeEntry<K, V> getLeftInMemory() {
        return this.left;
    }

    protected OMVRBTreeEntry<K, V> getParentInMemory() {
        return this.parent;
    }

    protected OMVRBTreeEntry<K, V> getRightInMemory() {
        return this.right;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.record != null && this.record.getIdentity().isValid()) {
            builder.append('@').append(this.record.getIdentity()).append(" ");
        }
        builder.append(super.toString());
        return builder.toString();
    }
}

