/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.type.tree;

import com.orientechnologies.common.collection.OMVRBTreeEntry;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocal;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeEntryPersistent;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeEntryStorage;
import com.orientechnologies.orient.core.type.tree.OMVRBTreePersistent;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMVRBTreeStorage<K, V>
extends OMVRBTreePersistent<K, V> {
    protected OStorageLocal storage;
    int clusterId;

    public OMVRBTreeStorage(OStorageLocal iStorage, String iClusterName, ORID iRID) {
        super(iClusterName, iRID);
        this.storage = iStorage;
        this.clusterId = this.storage.getClusterIdByName("internal");
    }

    public OMVRBTreeStorage(OStorageLocal iStorage, String iClusterName, OStreamSerializer iKeySerializer, OStreamSerializer iValueSerializer) {
        super(iClusterName, iKeySerializer, iValueSerializer);
        this.storage = iStorage;
        this.clusterId = this.storage.getClusterIdByName("internal");
    }

    protected OMVRBTreeEntryPersistent<K, V> createEntry(OMVRBTreeEntry<K, V> iParent) {
        return new OMVRBTreeEntryStorage<K, V>(iParent, iParent.getPageSplitItems());
    }

    protected OMVRBTreeEntryPersistent<K, V> createEntry(K key, V value) {
        this.adjustPageSize();
        return new OMVRBTreeEntryStorage<K, V>(this, key, value, null);
    }

    @Override
    protected OMVRBTreeEntryStorage<K, V> loadEntry(OMVRBTreeEntryPersistent<K, V> iParent, ORID iRecordId) throws IOException {
        OMVRBTreeEntryStorage<K, V> entry = null;
        if (entry == null) {
            entry = new OMVRBTreeEntryStorage<K, V>(this, iParent, iRecordId);
        }
        return entry;
    }

    @Override
    public OMVRBTreePersistent<K, V> load() throws IOException {
        ((ORecordId)this.record.getIdentity()).clusterId = this.clusterId;
        ORawBuffer raw = this.storage.readRecord(null, (ORecordId)this.record.getIdentity(), null);
        if (raw == null) {
            throw new OConfigurationException("Can't load map with id " + this.clusterId + ":" + this.record.getIdentity().getClusterPosition());
        }
        this.record.setVersion(raw.version);
        this.fromStream(raw.buffer);
        return this;
    }

    @Override
    public OMVRBTreePersistent<K, V> save() throws IOException {
        this.record.fromStream(this.toStream());
        if (this.record.getIdentity().isValid()) {
            this.record.setVersion(this.storage.updateRecord((ORecordId)this.record.getIdentity(), this.record.toStream(), -1, this.record.getRecordType()));
        } else {
            if (this.record.getIdentity().getClusterId() == -1) {
                ((ORecordId)this.record.getIdentity()).clusterId = this.clusterId;
            }
            this.storage.createRecord((ORecordId)this.record.getIdentity(), this.record.toStream(), this.record.getRecordType());
        }
        this.record.unsetDirty();
        return this;
    }

    public void delete() {
        this.clear();
        this.storage.deleteRecord((ORecordId)this.record.getIdentity(), this.record.getVersion());
    }
}

