/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.collection;

import com.orientechnologies.common.collection.OMVRBTree;
import com.orientechnologies.common.collection.OMVRBTreeEntry;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractEntryIterator<K, V, T>
implements Iterator<T> {
    OMVRBTree<K, V> tree;
    OMVRBTreeEntry<K, V> next;
    OMVRBTreeEntry<K, V> lastReturned;
    int expectedModCount;

    AbstractEntryIterator(OMVRBTreeEntry<K, V> first) {
        if (first == null) {
            return;
        }
        this.tree = first.getTree();
        this.next = first;
        this.expectedModCount = this.tree.modCount;
        this.lastReturned = null;
        this.tree.pageIndex = -1;
    }

    @Override
    public final boolean hasNext() {
        return this.next != null && (OMVRBTree.successor(this.next) != null || this.tree.pageIndex < this.next.getSize() - 1);
    }

    final OMVRBTreeEntry<K, V> nextEntry() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        if (this.tree.pageIndex < this.next.size - 1) {
            ++this.tree.pageIndex;
        } else {
            if (this.tree.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.next = OMVRBTree.successor(this.next);
            this.tree.pageIndex = 0;
            this.lastReturned = this.next;
        }
        return this.next;
    }

    final OMVRBTreeEntry<K, V> prevEntry() {
        OMVRBTreeEntry<K, V> e = this.next;
        if (e == null) {
            throw new NoSuchElementException();
        }
        if (this.tree.pageIndex > 0) {
            --this.tree.pageIndex;
        } else {
            if (this.tree.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.next = OMVRBTree.predecessor(e);
            this.tree.pageIndex = this.next.size - 1;
            this.lastReturned = e;
        }
        return e;
    }

    @Override
    public void remove() {
        if (this.lastReturned == null) {
            throw new IllegalStateException();
        }
        if (this.tree.modCount != this.expectedModCount) {
            throw new ConcurrentModificationException();
        }
        if (this.lastReturned.getLeft() != null && this.lastReturned.getRight() != null) {
            this.next = this.lastReturned;
        }
        this.tree.deleteEntry(this.lastReturned);
        this.expectedModCount = this.tree.modCount;
        this.lastReturned = null;
    }
}

