/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.concur.resource;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class OSharedResourceTimeout {
    protected ReadWriteLock lock = new ReentrantReadWriteLock();
    protected int timeout;

    public OSharedResourceTimeout(int timeout) {
        this.timeout = timeout;
    }

    protected void acquireSharedLock() throws InterruptedException {
        if (!this.lock.readLock().tryLock(this.timeout, TimeUnit.MILLISECONDS)) {
            throw new InterruptedException("Timeout on acquiring shared resource");
        }
    }

    protected void releaseSharedLock() {
        this.lock.readLock().unlock();
    }

    protected void acquireExclusiveLock() throws InterruptedException {
        if (!this.lock.writeLock().tryLock(this.timeout, TimeUnit.MILLISECONDS)) {
            throw new InterruptedException("Timeout on acquiring shared resource");
        }
    }

    protected void releaseExclusiveLock() {
        this.lock.writeLock().unlock();
    }
}

