/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.parser;

import java.util.ArrayList;

public class OStringParser {
    public static final String WHITE_SPACE = " ";
    public static final String COMMON_JUMP = " \r\n";

    public static String getWordFromString(String iText, int iBeginIndex, String ioSeparatorChars) {
        return OStringParser.getWord(iText.trim(), iBeginIndex, ioSeparatorChars);
    }

    public static String getWord(CharSequence iText, int iBeginIndex, String ioSeparatorChars) {
        StringBuilder buffer = new StringBuilder();
        int stringBeginChar = 32;
        for (int i = iBeginIndex; i < iText.length(); ++i) {
            int c = iText.charAt(i);
            if (c == 39 || c == 34) {
                if (stringBeginChar != 32) {
                    if (stringBeginChar == c) {
                        stringBeginChar = 32;
                    }
                } else {
                    stringBeginChar = c;
                }
            } else if (stringBeginChar == 32) {
                for (int sepIndex = 0; sepIndex < ioSeparatorChars.length(); ++sepIndex) {
                    if (ioSeparatorChars.charAt(sepIndex) != c || buffer.length() <= 0) continue;
                    return buffer.toString();
                }
            }
            buffer.append((char)c);
        }
        return buffer.toString();
    }

    public static String[] getWords(String iRecord, String iSeparatorChars) {
        return OStringParser.getWords(iRecord, iSeparatorChars, false);
    }

    public static String[] getWords(String iRecord, String iSeparatorChars, boolean iIncludeStringSep) {
        return OStringParser.getWords(iRecord, iSeparatorChars, " \n\r\t", iIncludeStringSep);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String[] getWords(String iText, String iSeparatorChars, String iJumpChars, boolean iIncludeStringSep) {
        iText = iText.trim();
        ArrayList<String> fields = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        int stringBeginChar = ' ';
        int openBraket = 0;
        int openGraph = 0;
        boolean escape = false;
        int i = 0;
        while (true) {
            block19: {
                char c;
                block31: {
                    boolean charFound;
                    block27: {
                        block30: {
                            block20: {
                                block29: {
                                    block28: {
                                        block25: {
                                            block26: {
                                                block21: {
                                                    block24: {
                                                        block23: {
                                                            block22: {
                                                                if (i >= iText.length()) break block20;
                                                                c = iText.charAt(i);
                                                                if (openBraket != 0 || openGraph != 0 || escape || c != '\\') break block21;
                                                                if (iText.charAt(i + 1) != 'u') break block22;
                                                                i = OStringParser.readUnicode(iText, i + 2, buffer);
                                                                break block19;
                                                            }
                                                            if (iText.charAt(i + 1) != 'n') break block23;
                                                            buffer.append("\n");
                                                            ++i;
                                                            break block19;
                                                        }
                                                        if (iText.charAt(i + 1) != 'r') break block24;
                                                        buffer.append("\r");
                                                        ++i;
                                                        break block19;
                                                    }
                                                    if (iText.charAt(i + 1) == 't') {
                                                        buffer.append("\t");
                                                        ++i;
                                                        break block19;
                                                    } else if (iText.charAt(i + 1) == 'f') {
                                                        buffer.append("\f");
                                                        ++i;
                                                        break block19;
                                                    } else {
                                                        escape = true;
                                                    }
                                                    break block19;
                                                }
                                                if (openBraket != 0 || openGraph != 0 || escape || c != '\'' && c != '\"') break block25;
                                                if (stringBeginChar == 32) break block26;
                                                if (stringBeginChar != c) break block27;
                                                stringBeginChar = 32;
                                                if (iIncludeStringSep) {
                                                    buffer.append(c);
                                                }
                                                fields.add(buffer.toString());
                                                buffer.setLength(0);
                                                break block19;
                                            }
                                            stringBeginChar = c;
                                            if (iIncludeStringSep) {
                                                buffer.append(c);
                                            }
                                            break block19;
                                        }
                                        if (stringBeginChar != 32) break block27;
                                        if (c == '[') {
                                            ++openBraket;
                                        } else if (c == ']') {
                                            --openBraket;
                                        }
                                        if (c != '{') break block28;
                                        ++openGraph;
                                        break block27;
                                    }
                                    if (c != '}') break block29;
                                    --openGraph;
                                    break block27;
                                }
                                if (openBraket != 0 || openGraph != 0) break block27;
                                charFound = false;
                                break block30;
                            }
                            if (buffer.length() > 0) {
                                fields.add(buffer.toString());
                            }
                            String[] result = new String[fields.size()];
                            fields.toArray(result);
                            return result;
                        }
                        for (int sepIndex = 0; sepIndex < iSeparatorChars.length(); ++sepIndex) {
                            if (iSeparatorChars.charAt(sepIndex) != c) continue;
                            charFound = true;
                            if (buffer.length() <= 0) break;
                            fields.add(buffer.toString());
                            buffer.setLength(0);
                            break;
                        }
                        if (charFound) break block19;
                    }
                    if (buffer.length() != 0) break block31;
                    charFound = false;
                    for (int jumpIndex = 0; jumpIndex < iJumpChars.length(); ++jumpIndex) {
                        if (iJumpChars.charAt(jumpIndex) != c) continue;
                        charFound = true;
                        break;
                    }
                    if (charFound) break block19;
                }
                buffer.append(c);
                if (escape) {
                    escape = false;
                }
            }
            ++i;
        }
    }

    public static String[] split(String iText, char iSplitChar, String iJumpChars) {
        iText = iText.trim();
        ArrayList<String> fields = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        char stringChar = ' ';
        boolean escape = false;
        boolean jumpSplitChar = false;
        for (int i = 0; i < iText.length(); ++i) {
            char c = iText.charAt(i);
            if (!escape && c == '\\') {
                if (iText.charAt(i + 1) == 'u') {
                    i = OStringParser.readUnicode(iText, i + 2, buffer);
                    continue;
                }
                escape = true;
                buffer.append(c);
                continue;
            }
            if (c == '\'' || c == '\"') {
                if (!jumpSplitChar) {
                    jumpSplitChar = true;
                    stringChar = c;
                } else if (!escape && c == stringChar) {
                    jumpSplitChar = false;
                }
            }
            if (c == iSplitChar && !jumpSplitChar) {
                fields.add(buffer.toString());
                buffer.setLength(0);
                continue;
            }
            if (buffer.length() == 0) {
                boolean charFound = false;
                for (int jumpIndex = 0; jumpIndex < iJumpChars.length(); ++jumpIndex) {
                    if (iJumpChars.charAt(jumpIndex) != c) continue;
                    charFound = true;
                    break;
                }
                if (charFound) continue;
            }
            buffer.append(c);
            if (!escape) continue;
            escape = false;
        }
        if (buffer.length() > 0) {
            fields.add(buffer.toString());
            buffer.setLength(0);
        }
        String[] result = new String[fields.size()];
        fields.toArray(result);
        return result;
    }

    public static int jumpWhiteSpaces(CharSequence iText, int iCurrentPosition) {
        return OStringParser.jump(iText, iCurrentPosition, WHITE_SPACE);
    }

    public static int jump(CharSequence iText, int iCurrentPosition, String iJumpChars) {
        if (iCurrentPosition < 0) {
            return -1;
        }
        int size = iText.length();
        int jumpCharSize = iJumpChars.length();
        boolean found = true;
        while (iCurrentPosition < size) {
            found = false;
            char c = iText.charAt(iCurrentPosition);
            for (int jumpIndex = 0; jumpIndex < jumpCharSize; ++jumpIndex) {
                if (iJumpChars.charAt(jumpIndex) != c) continue;
                found = true;
                break;
            }
            if (!found) break;
            ++iCurrentPosition;
        }
        return iCurrentPosition >= size ? -1 : iCurrentPosition;
    }

    public static int readUnicode(String iText, int position, StringBuilder buffer) {
        StringBuilder buff = new StringBuilder();
        int lastPos = position + 4;
        while (position < lastPos) {
            buff.append(iText.charAt(position));
            ++position;
        }
        buffer.append((char)Integer.parseInt(buff.toString(), 16));
        return position - 1;
    }
}

