/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.parser;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OVariableParserListener;

public class OVariableParser {
    public static String resolveVariables(String iText, String iBegin, String iEnd, OVariableParserListener iListener) {
        if (iListener == null) {
            throw new IllegalArgumentException("Missed VariableParserListener listener");
        }
        int beginPos = iText.lastIndexOf(iBegin);
        if (beginPos == -1) {
            return iText;
        }
        int endPos = iText.indexOf(iEnd, beginPos + 1);
        if (endPos == -1) {
            return iText;
        }
        String pre = iText.substring(0, beginPos);
        String var = iText.substring(beginPos + iBegin.length(), endPos);
        String post = iText.substring(endPos + iEnd.length());
        String resolved = iListener.resolve(var);
        if (resolved == null) {
            OLogManager.instance().error(null, "[OVariableParser.resolveVariables] Error on resolving property: %s", var);
            resolved = "null";
        }
        String path = pre + resolved + post;
        return OVariableParser.resolveVariables(path, iBegin, iEnd, iListener);
    }
}

