/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.thread;

import com.orientechnologies.common.util.OService;

public abstract class OSoftThread
extends Thread
implements OService {
    protected volatile boolean running = true;

    public OSoftThread() {
    }

    public OSoftThread(ThreadGroup iThreadGroup) {
        super(iThreadGroup, OSoftThread.class.getSimpleName());
        this.setDaemon(true);
    }

    public OSoftThread(String name) {
        super(name);
        this.setDaemon(true);
    }

    public OSoftThread(ThreadGroup group, String name) {
        super(group, name);
        this.setDaemon(true);
    }

    protected abstract void execute() throws Exception;

    public void startup() {
        this.running = true;
    }

    public void shutdown() {
        this.running = false;
    }

    public void sendShutdown() {
        this.running = false;
        this.interrupt();
    }

    public void run() {
        this.startup();
        while (this.running) {
            try {
                this.beforeExecution();
                this.execute();
                this.afterExecution();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.shutdown();
    }

    public boolean isRunning() {
        return this.running;
    }

    public static boolean pauseCurrentThread(long iTime) {
        try {
            if (iTime <= 0L) {
                iTime = Long.MAX_VALUE;
            }
            Thread.sleep(iTime);
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    protected void beforeExecution() throws InterruptedException {
    }

    protected void afterExecution() throws InterruptedException {
    }
}

