/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server;

import com.orientechnologies.common.concur.resource.OSharedResourceAbstract;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocol;
import com.orientechnologies.orient.server.network.protocol.binary.ONetworkProtocolBinary;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OClientConnectionManager
extends OSharedResourceAbstract {
    protected Map<Integer, OClientConnection> connections = new HashMap<Integer, OClientConnection>();
    protected Map<Integer, ONetworkProtocol> handlers = new HashMap<Integer, ONetworkProtocol>();
    protected int connectionSerial = 0;
    private static final OClientConnectionManager instance = new OClientConnectionManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClientConnection connect(Socket iSocket, ONetworkProtocol iProtocol) throws IOException {
        OClientConnection connection;
        OProfiler.getInstance().updateCounter("OServer.threads.actives", 1L);
        this.acquireExclusiveLock();
        try {
            connection = new OClientConnection(++this.connectionSerial, iSocket, iProtocol);
            this.connections.put(connection.id, connection);
            this.handlers.put(connection.id, connection.protocol);
        }
        finally {
            this.releaseExclusiveLock();
        }
        OLogManager.instance().config((Object)this, "Remote client connected from: " + connection, new Object[0]);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClientConnection getConnection(int iChannelId) {
        this.acquireSharedLock();
        try {
            OClientConnection oClientConnection = this.connections.get(iChannelId);
            return oClientConnection;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(int iChannelId) {
        OProfiler.getInstance().updateCounter("OServer.threads.actives", -1L);
        this.acquireExclusiveLock();
        try {
            OClientConnection conn = this.connections.remove(iChannelId);
            if (conn == null) {
                return;
            }
            this.handlers.remove(iChannelId);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public static OClientConnectionManager instance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OClientConnection> getConnections() {
        this.acquireSharedLock();
        try {
            ArrayList<OClientConnection> arrayList = new ArrayList<OClientConnection>(this.connections.values());
            return arrayList;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ONetworkProtocol> getHandlers() {
        this.acquireSharedLock();
        try {
            ArrayList<ONetworkProtocol> arrayList = new ArrayList<ONetworkProtocol>(this.handlers.values());
            return arrayList;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void broadcastRecord2Clients(ORecordInternal<?> iRecord, OClientConnection iExcludeConnection) throws InterruptedException, IOException {
        this.acquireSharedLock();
        try {
            String dbName = iRecord.getDatabase().getName();
            for (OClientConnection c : this.connections.values()) {
                if (c == iExcludeConnection) continue;
                ONetworkProtocolBinary p = (ONetworkProtocolBinary)c.protocol;
                OChannelBinary channel = (OChannelBinary)p.getChannel();
                if (c.database == null || !c.database.getName().equals(dbName)) continue;
                List<ORecordInternal<?>> list = c.records2Push;
                synchronized (list) {
                    channel.acquireExclusiveLock();
                    try {
                        channel.writeByte((byte)3);
                        channel.writeInt(Integer.MIN_VALUE);
                        channel.writeByte((byte)79);
                        p.writeIdentifiable(iRecord);
                    }
                    finally {
                        channel.releaseExclusiveLock();
                    }
                }
            }
            return;
        }
        finally {
            this.releaseSharedLock();
        }
    }
}

