/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.OConstants;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandManager;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.security.OSecurityManager;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.memory.OStorageMemory;
import com.orientechnologies.orient.enterprise.command.script.OCommandScript;
import com.orientechnologies.orient.server.OServerShutdownHook;
import com.orientechnologies.orient.server.command.script.OCommandExecutorScript;
import com.orientechnologies.orient.server.config.OServerConfiguration;
import com.orientechnologies.orient.server.config.OServerConfigurationLoaderXml;
import com.orientechnologies.orient.server.config.OServerEntryConfiguration;
import com.orientechnologies.orient.server.config.OServerHandlerConfiguration;
import com.orientechnologies.orient.server.config.OServerNetworkListenerConfiguration;
import com.orientechnologies.orient.server.config.OServerNetworkProtocolConfiguration;
import com.orientechnologies.orient.server.config.OServerStorageConfiguration;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import com.orientechnologies.orient.server.handler.OServerHandler;
import com.orientechnologies.orient.server.managed.OrientServer;
import com.orientechnologies.orient.server.network.OServerNetworkListener;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocol;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class OServer {
    protected ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    protected volatile boolean running = true;
    protected OServerConfigurationLoaderXml configurationLoader;
    protected OServerConfiguration configuration;
    protected OContextConfiguration contextConfiguration;
    protected OServerShutdownHook shutdownHook;
    protected List<OServerHandler> handlers = new ArrayList<OServerHandler>();
    protected Map<String, Class<? extends ONetworkProtocol>> protocols = new HashMap<String, Class<? extends ONetworkProtocol>>();
    protected List<OServerNetworkListener> listeners = new ArrayList<OServerNetworkListener>();
    protected Map<String, OStorageMemory> memoryDatabases = new HashMap<String, OStorageMemory>();
    protected static ThreadGroup threadGroup;
    private OrientServer managedServer;
    private ObjectName onProfiler = new ObjectName("OrientDB:type=Profiler");
    private ObjectName onServer = new ObjectName("OrientDB:type=Server");

    public OServer() throws ClassNotFoundException, MalformedObjectNameException, NullPointerException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        this.defaultSettings();
        OLogManager.installCustomFormatter();
        threadGroup = new ThreadGroup("OrientDB Server");
        OCommandManager.instance().registerExecutor(OCommandScript.class, OCommandExecutorScript.class);
        OGlobalConfiguration.STORAGE_KEEP_OPEN.setValue(true);
        System.setProperty("com.sun.management.jmxremote", "true");
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        mBeanServer.registerMBean(OProfiler.getInstance().startRecording(), this.onProfiler);
        this.managedServer = new OrientServer();
        mBeanServer.registerMBean(this.managedServer, this.onServer);
        this.shutdownHook = new OServerShutdownHook();
    }

    public void startup() throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException {
        String config = "config/orientdb-server-config.xml";
        if (System.getProperty("orientdb.config.file") != null) {
            config = System.getProperty("orientdb.config.file");
        }
        this.startup(new File(config));
    }

    public void startup(File iConfigurationFile) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException {
        this.startup(this.loadConfigurationFromFile(iConfigurationFile));
    }

    public void startup(String iConfiguration) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException, IOException {
        this.configurationLoader = new OServerConfigurationLoaderXml(OServerConfiguration.class, iConfiguration);
        this.configuration = this.configurationLoader.load();
        this.startup(this.configuration);
    }

    public void startup(OServerConfiguration iConfiguration) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException {
        OLogManager.instance().info((Object)this, "OrientDB Server v" + OConstants.getVersion() + " is starting up...", new Object[0]);
        this.loadConfiguration(iConfiguration);
        Orient.instance();
        Orient.instance().removeShutdownHook();
        for (OServerNetworkProtocolConfiguration p : this.configuration.network.protocols) {
            this.protocols.put(p.name, Class.forName(p.implementation));
        }
        for (OServerNetworkListenerConfiguration l : this.configuration.network.listeners) {
            this.listeners.add(new OServerNetworkListener(this, l.ipAddress, l.portRange, l.protocol, this.protocols.get(l.protocol), l.parameters, l.commands));
        }
        this.registerHandlers();
        OLogManager.instance().info((Object)this, "OrientDB Server v1.0rc5 is active.", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (!this.running) {
            return;
        }
        this.running = false;
        OLogManager.instance().info((Object)this, "OrientDB Server is shutdowning...", new Object[0]);
        try {
            this.lock.writeLock().lock();
            for (OServerNetworkListener l : this.listeners) {
                OLogManager.instance().info((Object)this, "Shutdowning connection listener '" + l + "'...", new Object[0]);
                l.shutdown();
            }
            for (OServerHandler h : this.handlers) {
                OLogManager.instance().info((Object)this, "Shutdowning handler %s...", new Object[]{h.getName()});
                try {
                    h.shutdown();
                }
                catch (Throwable throwable) {}
            }
            this.protocols.clear();
            this.memoryDatabases.clear();
            try {
                MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                mBeanServer.unregisterMBean(this.onProfiler);
                mBeanServer.unregisterMBean(this.onServer);
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "OrientDB Server v1.0rc5 unregisterMBean error.", (Throwable)e, new Object[0]);
            }
            Orient.instance().shutdown();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        OLogManager.instance().info((Object)this, "OrientDB Server shutdown complete", new Object[0]);
        System.out.println();
    }

    public String getStoragePath(String iName) {
        String name = iName.indexOf(58) > -1 ? iName.substring(iName.indexOf(58) + 1) : iName;
        OStorage stg = Orient.instance().getStorage(name);
        if (stg != null) {
            return stg.getURL();
        }
        String dbPath = this.configuration.getStoragePath(name);
        if (dbPath == null) {
            dbPath = OSystemVariableResolver.resolveSystemVariables((String)("${ORIENTDB_HOME}/databases/" + name + "/"));
            File f = new File(dbPath + "default.odh");
            if (!f.exists()) {
                throw new OConfigurationException("Database '" + name + "' is not configured on server");
            }
            dbPath = "local:${ORIENTDB_HOME}/databases/" + name;
        }
        return dbPath;
    }

    public ThreadGroup getServerThreadGroup() {
        return threadGroup;
    }

    public boolean authenticate(String iUserName, String iPassword, String iResourceToCheck) {
        OServerUserConfiguration user = this.getUser(iUserName);
        if (user != null && (iPassword == null || user.password.equals(iPassword))) {
            String[] resourceParts;
            if (user.resources.equals("*")) {
                return true;
            }
            for (String r : resourceParts = user.resources.split(",")) {
                if (!r.equals(iResourceToCheck)) continue;
                return true;
            }
        }
        return false;
    }

    public OServerUserConfiguration getUser(String iUserName) {
        return this.configuration.getUser(iUserName);
    }

    public boolean existsStoragePath(String iURL) {
        return this.configuration.getStoragePath(iURL) != null;
    }

    public OServerConfiguration getConfiguration() {
        return this.configuration;
    }

    public void saveConfiguration() throws IOException {
        this.configurationLoader.save(this.configuration);
    }

    public Map<String, OStorageMemory> getMemoryDatabases() {
        return this.memoryDatabases;
    }

    public Map<String, Class<? extends ONetworkProtocol>> getProtocols() {
        return this.protocols;
    }

    public List<OServerNetworkListener> getListeners() {
        return this.listeners;
    }

    public <RET extends OServerNetworkListener> RET getListenerByProtocol(Class<? extends ONetworkProtocol> iProtocolClass) {
        for (OServerNetworkListener l : this.listeners) {
            if (!l.getProtocolType().equals(iProtocolClass)) continue;
            return (RET)l;
        }
        return null;
    }

    public OrientServer getManagedServer() {
        return this.managedServer;
    }

    public static String getOrientHome() {
        String v = System.getenv("ORIENTDB_HOME");
        if (v == null) {
            v = System.getProperty("orient.home");
        }
        return v;
    }

    public List<OServerHandler> getHandlers() {
        return this.handlers;
    }

    public OContextConfiguration getContextConfiguration() {
        return this.contextConfiguration;
    }

    public <RET extends OServerHandler> RET getHandler(Class<RET> iHandlerClass) {
        for (OServerHandler h : this.handlers) {
            if (!h.getClass().equals(iHandlerClass)) continue;
            return (RET)h;
        }
        return null;
    }

    protected void loadConfiguration(OServerConfiguration iConfiguration) {
        try {
            this.configuration = iConfiguration;
            this.contextConfiguration = new OContextConfiguration();
            if (iConfiguration.properties != null) {
                for (OServerEntryConfiguration prop : iConfiguration.properties) {
                    this.contextConfiguration.setValue(prop.name, (Object)prop.value);
                }
            }
            this.loadStorages();
            this.loadUsers();
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on reading server configuration.", OConfigurationException.class);
        }
    }

    protected OServerConfiguration loadConfigurationFromFile(File iFile) {
        try {
            this.configurationLoader = new OServerConfigurationLoaderXml(OServerConfiguration.class, iFile);
            return this.configurationLoader.load();
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on reading server configuration from file: " + iFile, (Throwable)e, OConfigurationException.class, new Object[0]);
            return null;
        }
    }

    protected void loadUsers() throws IOException {
        if (this.configuration.users != null && this.configuration.users.length > 0) {
            for (OServerUserConfiguration u : this.configuration.users) {
                if (!u.name.equals("root")) continue;
                return;
            }
        }
        this.createAdminUser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadStorages() {
        if (this.configuration.storages == null) {
            return;
        }
        for (OServerStorageConfiguration stg : this.configuration.storages) {
            if (!stg.loadOnStartup) continue;
            if (stg.userName == null) {
                stg.userName = "admin";
            }
            if (stg.userPassword == null) {
                stg.userPassword = "admin";
            }
            String type = stg.path.substring(0, stg.path.indexOf(58));
            ODatabaseDocumentTx db = null;
            try {
                db = new ODatabaseDocumentTx(stg.path);
                if (db.exists()) {
                    db.open(stg.userName, stg.userPassword);
                } else {
                    db.create();
                }
                OLogManager.instance().info((Object)this, "-> Loaded " + type + " database '" + stg.name + "'", new Object[0]);
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "-> Can't load " + type + " database '" + stg.name + "': " + e, new Object[0]);
            }
            finally {
                if (db != null) {
                    db.close();
                }
            }
        }
    }

    protected void createAdminUser() throws IOException {
        this.configuration.users = new OServerUserConfiguration[1];
        long generatedPassword = new Random(System.currentTimeMillis()).nextLong();
        String encodedPassword = OSecurityManager.instance().digest2String(String.valueOf(generatedPassword));
        this.configuration.users[0] = new OServerUserConfiguration("root", encodedPassword, "*");
        this.saveConfiguration();
    }

    protected void registerHandlers() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (this.configuration.handlers != null) {
            for (OServerHandlerConfiguration h : this.configuration.handlers) {
                OServerHandler handler = (OServerHandler)Class.forName(h.clazz).newInstance();
                this.handlers.add(handler);
                handler.config(this, h.parameters);
                handler.startup();
            }
        }
    }

    protected void defaultSettings() {
        OGlobalConfiguration.CACHE_LEVEL1_ENABLED.setValue(Boolean.FALSE);
        OGlobalConfiguration.CACHE_LEVEL1_SIZE.setValue(0);
        OGlobalConfiguration.FILE_LOCK.setValue(true);
        OGlobalConfiguration.TX_USE_LOG.setValue(true);
        OGlobalConfiguration.TX_COMMIT_SYNCH.setValue(true);
    }
}

