/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.command.script;

import com.orientechnologies.orient.core.command.OCommandExecutorAbstract;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.enterprise.command.script.OCommandScript;
import com.orientechnologies.orient.enterprise.command.script.OCommandScriptException;
import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class OCommandExecutorScript
extends OCommandExecutorAbstract {
    protected static final String DEF_LANGUAGE = "JavaScript";
    protected static ScriptEngineManager scriptEngineManager;
    protected static Map<String, ScriptEngine> engines;
    protected static String defaultLanguage;
    protected OCommandScript request;

    public OCommandExecutorScript parse(OCommandRequestText iRequest) {
        this.request = (OCommandScript)iRequest;
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        String language = this.request.getLanguage();
        String script = this.request.getText();
        if (language == null) {
            throw new OCommandScriptException("No language was specified");
        }
        if (!engines.containsKey(language)) {
            throw new OCommandScriptException("Unsupported language: " + language + ". Supported languages are: " + engines);
        }
        if (script == null) {
            throw new OCommandScriptException("Invalid script: null");
        }
        ScriptEngine scriptEngine = engines.get(language);
        if (scriptEngine == null) {
            throw new OCommandScriptException("Cannot find script engine: " + language);
        }
        Bindings binding = scriptEngine.createBindings();
        binding.put("db", (Object)this.database);
        if (iArgs != null) {
            for (int i = 0; i < iArgs.size(); ++i) {
                binding.put("$" + i, iArgs.get(i));
            }
        }
        try {
            Object result = null;
            result = scriptEngine.eval(script, binding);
            return result;
        }
        catch (ScriptException e) {
            throw new OCommandScriptException("Error on execution of the script", this.request.getText(), 0, e);
        }
    }

    static {
        defaultLanguage = DEF_LANGUAGE;
        if (engines == null) {
            engines = new HashMap<String, ScriptEngine>();
            scriptEngineManager = new ScriptEngineManager();
            for (ScriptEngineFactory f : scriptEngineManager.getEngineFactories()) {
                engines.put(f.getLanguageName(), f.getScriptEngine());
                if (defaultLanguage != null) continue;
                defaultLanguage = f.getLanguageName();
            }
            if (!engines.containsKey(DEF_LANGUAGE)) {
                engines.put(DEF_LANGUAGE, scriptEngineManager.getEngineByName(DEF_LANGUAGE));
                defaultLanguage = DEF_LANGUAGE;
            }
        }
    }
}

